<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>Laravel</title>

        <!-- Fonts -->
        <link href="https://fonts.googleapis.com/css?family=Nunito:200,600" rel="stylesheet">

        <!-- Styles -->
        <style>
            html, body {
                background-color: #fff;
                color: #636b6f;
                font-family: 'Nunito', sans-serif;
                font-weight: 200;
                height: 100vh;
                margin: 0;
            }

            .full-height {
                height: 100vh;
            }

            .flex-center {
                align-items: center;
                display: flex;
                justify-content: center;
            }

            .position-ref {
                position: relative;
            }

            .top-right {
                position: absolute;
                right: 10px;
                top: 18px;
            }

            .content {
                text-align: center;
            }

            .title {
                font-size: 84px;
            }

            .links > a {
                color: #636b6f;
                padding: 0 25px;
                font-size: 13px;
                font-weight: 600;
                letter-spacing: .1rem;
                text-decoration: none;
                text-transform: uppercase;
            }

            .m-b-md {
                margin-bottom: 30px;
            }
        </style>
    </head>
    <body>
            <?php if($meeting == 'office') { ?>
                <p class="alert-danger">Appointment Scheduled</p>
                <p> Appointment scheduled for Mr./Mrs. <?php echo e($request->first_name); ?> at <strong><?php echo e(date('M d,Y',strtotime($request->appointment_date))); ?> <?php echo e($request->appointment_time); ?></strong>
                
                
            <?php } else { ?>
                <p class="alert-danger">Download Zoom before the call</p>
                <p> Appointment scheduled for Mr./Mrs. <?php echo e($request->first_name); ?> at <strong><?php echo e(date('M d,Y',strtotime($request->appointment_date))); ?> <?php echo e($request->appointment_time); ?></strong>
                <p> Please follow the link below to connect the call at <strong><?php echo e(date('M d,Y',strtotime($request->appointment_date))); ?> <?php echo e($request->appointment_time); ?></strong></p>
                <a href="<?php echo e($meeting); ?>"><?php echo e($meeting); ?></a>
            <?php } ?>
    </body>
</html>
<?php /**PATH C:\xampp\htdocs\skinscapelaravel\resources\views/zoom-meeting.blade.php ENDPATH**/ ?>