<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/', 'FrontendController@index');
Route::post('/signin', 'DashboardController@signin')->name('signin');
Route::get('/page', 'FrontendController@general');
Route::get('/setSession', 'FrontendController@setSession')->name('setSession');
Route::get('/general', 'FrontendController@general')->name('general');
Route::get('/botox','FrontendController@botox');
Route::get('/filler','FrontendController@filler');
Route::get('/telemedicine','FrontendController@teleMedicine');
Route::get('/conditions/dvt','FrontendController@conditionDvt');
Route::get('/conditions/mental','FrontendController@conditionMental');
Route::get('/conditions/venous','FrontendController@conditionVenous');
Route::get('/conditions/varicose','FrontendController@conditionVaricose');
Route::get('/conditions/poorcirculation','FrontendController@conditionPoorCirculation');
Route::get('/conditions/spider','FrontendController@conditionSpider');
Route::get('/conditions/wrinkle','FrontendController@conditionWrinkle');
Route::get('/conditions/crow','FrontendController@conditionCrow');
Route::get('/conditions/glabellar','FrontendController@conditionGlabellar');
Route::get('/treatment/varicose','FrontendController@treatmentVaricose');
Route::get('/treatment/varicose/visual','FrontendController@treatmentVaricoseVisual');
Route::get('/treatment/varicose/ugs','FrontendController@treatmentVaricoseUgs'); 
Route::get('/treatment/varicose/endovenous','FrontendController@treatmentVaricoseEndovenous');
Route::get('/treatment/varicose/compression','FrontendController@treatmentVaricoseCompression');
Route::get('/treatment/hair/platelet','FrontendController@treatmentHairPlatelet');
Route::get('/treatment/acne/vampire','FrontendController@treatmentAcneVampire');
Route::get('/treatment/common','FrontendController@treatmentCommon');
Route::get('/our-values','FrontendController@Values');

Route::get('/treatment/spider','FrontendController@treatmentSpider');
Route::get('/treatment/reticular','FrontendController@treatmentReticular');
Route::get('/treatment/rest','FrontendController@treatmentRest');
Route::get('/treatment/acne','FrontendController@treatmentAcne');
Route::get('/treatment/hair','FrontendController@treatmentHair');

Route::get('/auth-form','FrontendController@authForm');

Route::get('/dashboard/menu', 'MenuController@index');
Route::get('/dashboard/menu/edit/{id}','MenuController@edit');
Route::get('/dashboard/menu/delete/{id}','MenuController@delete');
Route::post('/dashboard/menu/update/{id}','MenuController@update');
Route::get('/dashboard/menu/create','MenuController@create');
Route::post('/dashboard/menu/store', 'MenuController@store');
Route::get('/dashboard/submenu', 'SubMenuController@index');
Route::get('/dashboard/submenu/edit/{id}','SubMenuController@edit');
Route::get('/dashboard/submenu/delete/{id}','SubMenuController@delete');
Route::post('/dashboard/submenu/update/{id}','SubMenuController@update');
Route::get('/dashboard/submenu/create','SubMenuController@create');
Route::post('/dashboard/submenu/store', 'SubMenuController@store');
Route::get('/dashboard/subchild', 'SubChildController@index');
Route::get('/dashboard/subchild/edit/{id}','SubChildController@edit');
Route::post('/dashboard/subchild/update/{id}','SubChildController@update');
Route::get('/dashboard/subchild/create','SubChildController@create');
Route::post('/dashboard/subchild/store', 'SubChildController@store');
Route::get('/dashboard/subchild/delete/{id}','SubChildController@delete');
Route::get('/dashboard/content','ContentController@index');
Route::get('/dashboard/content/edit/{id}','ContentController@edit');
Route::post('/dashboard/content/update','ContentController@update');
Route::get('/dashboard/media','MediaController@index'); 
Route::get('/dashboard/media/create','MediaController@create');
Route::get('/dashboard/landing','LandingController@index');
Route::post('/dashboard/media/store', 'MediaController@store');
Route::get('/dashboard/media/edit/{id}','MediaController@edit');
Route::post('/dashboard/media/update/{id}','MediaController@update');
Route::get('/dashboard/media/delete/{id}','MediaController@delete');
Route::get('/dashboard/feedback','FeedBackController@index');
Route::get('/dashboard/feedback/create','FeedBackController@create');
Route::post('/dashboard/feedback/store', 'FeedBackController@store');
Route::get('/dashboard/feedback/edit/{id}','FeedBackController@edit');
Route::post('/dashboard/feedback/update/{id}','FeedBackController@update');
Route::get('/dashboard/feedback/delete/{id}','FeedBackController@delete');
Route::get('/dashboard/doctor', 'DoctorController@index');
Route::get('/dashboard/doctor/edit/{id}','DoctorController@edit');
Route::get('/dashboard/doctor/delete/{id}','DoctorController@delete');
Route::post('/dashboard/doctor/update/{id}','DoctorController@update');
Route::get('/dashboard/doctor/create','DoctorController@create');
Route::post('/dashboard/doctor/store', 'DoctorController@store');
Route::get('/dashboard/faq', 'FAQController@index');
Route::get('/dashboard/faq/edit/{id}','FAQController@edit');
Route::get('/dashboard/faq/delete/{id}','FAQController@delete');
Route::post('/dashboard/faq/update/{id}','FAQController@update');
Route::get('/dashboard/faq/create','FAQController@create');
Route::post('/dashboard/faq/store', 'FAQController@store');
Auth::routes([
    'register' => false, // Registration Routes...
    'reset' => false, // Password Reset Routes...
    'verify' => false, // Email Verification Routes...
  ]);
Route::get('/home', 'HomeController@index')->name('home');
Route::get('/contact', 'FrontEndController@contact');
Route::post('/contact', 'FrontEndController@contact');
Route::get('/refer', 'FrontEndController@refer');
Route::post('/refer', 'FrontEndController@refer');
Route::get('/zoom', 'HomeController@zoom');
Route::get('/create-meeting', 'HomeController@createMeeting');
Route::get('/schedule-online', 'FrontEndController@scheduleOnline');
Route::post('/send-email', 'FrontEndController@sendEmail');
Route::get('/get-client/{id}','FrontEndController@getClient');
Route::post('/book-appointment', 'FrontEndController@bookAppointment');
Route::get('/faq', 'FrontEndController@FAQ');
Route::post('/payment/make', 'PaymentController@make')->name('payment.make');
Route::get('/payment/make', 'PaymentController@makeNew');
Route::get('/payment/process', 'PaymentController@process')->name('payment.process'); 
Route::post('/payment/proceed', 'PaymentController@proceedPayment')->name('payment.proceed');
