@extends('layouts.default')
@section('content')
<section>
    <div class="row gray-background general">
        <div class="bannerGeneral">
            <h2 class="aligncenter p-m-0">Schedule Online</h4>
        </div>
        <div class="container p-t-5">
            @if(Session::has('message'))
                <div class="alert {{ Session::get('alert-class', 'alert-info') }} col-md-12"><?php echo Session::get('message'); ?></div>
                <br>
            @endif
            <div class="col-md-12 card p-5">
           
                
                <form role="form" enctype="multipart/form-data" method="post" action="{{url('/payment/make')}}">    
                    <div class="card-header p-0">
                        <div class="text-center py-2">
                            <h2 class="schedule-form-head">Instant Appointment</h2>
                        </div>
                    </div>
                    <div class="card-body p-3">
                        <!--Body-->
                        <input name="_token" type="hidden" value="{{ csrf_token() }}"/>
                        <div class="form-group">
                            <input type="text" class="form-control" name="first_name" placeholder="First Name">
                        </div>
                        <div class="form-group">
                            <input type="text" class="form-control" name="last_name" placeholder="Last Name">
                        </div>
                        <div class="form-group">
                            <input type="email" class="form-control" name="email" placeholder="Email">
                        </div>
                        <div class="form-group">
                            <input type="text" class="form-control" name="contact_no" placeholder="Phone">
                        </div>
                        <div class="form-group">
                            <input type="text" class="form-control" name="city" placeholder="City">
                        </div>
                        <label class="form-control noBorderLabel">Visit Type</label>
                        <select required name="visit_type" class="form-control">
                            <option value="">Select Visit Type</option>
                            <option value="office">Office Visit</option>
                            <option value="telemedicine">Online Visit (Telemedicine)</option>
                        </select>
                        <label class="form-control noBorderLabel">Preferred Date Range</label>
                        <div class="form-group col-md-6">
                            <input type="date" class="form-control" name="preferred_start_date" placeholder="Preferred Start Date">
                        </div>
                        <div class="form-group col-md-6">
                            <input type="date" class="form-control" name="preferred_end_date" placeholder="Preferred End Date">
                        </div>
                        <div class="p-t-5">
                            <label class="form-control noBorderLabel">Preferred Time Range</label>
                        </div>
                        <div class="form-group col-md-6">
                            <input type="time" class="form-control" name="preferred_start_time" placeholder="Preferred Start Time">
                        </div>
                        <div class="form-group col-md-6">
                            <input type="time" class="form-control" name="preferred_end_time" placeholder="Preferred End Time">
                        </div>
                    </div>
                    <div class="aligncenter">
                        <button class="btn btn-primary btn-block w-100">Continue</button>
                    </div>
                </form>
            </div>
        </div>
        <!--Form with header-->
    </div>
<section>
@endsection