@extends('layouts.default')
@section('content')
<section>
    <div class="row gray-background general">
        <div class="bannerGeneral">
            <h2 class="aligncenter p-m-0">Refer A Patient</h4>
        </div>
        <div class="container p-t-5">
            @if(Session::has('message'))
                <div class="alert {{ Session::get('alert-class', 'alert-info') }} col-md-12"><?php echo Session::get('message'); ?></div>
                <br>
            @endif
            <div class="col-md-12 card p-5">
           
                
                <form role="form" enctype="multipart/form-data" method="post" action="{{url('/refer')}}">    
                    <div class="card-header p-0">
                        <div class="text-center py-2">
                            <h2 class="schedule-form-head">Refer</h2>
                        </div>
                    </div>
                    <div class="card-body p-3">
                        <!--Body-->
                        <input name="_token" type="hidden" value="{{ csrf_token() }}"/>
                        <div class="form-group">
                            <input type="text" class="form-control" name="first_name" placeholder="First Name">
                        </div>
                        <div class="form-group">
                            <input type="text" class="form-control" name="last_name" placeholder="Last Name">
                        </div>
                        <div class="form-group">
                            <input type="email" class="form-control" name="email" placeholder="Email">
                        </div>
                        <div class="form-group">
                            <input type="text" class="form-control" name="contact_no" placeholder="Contact #">
                        </div>
                        <div class="form-group">
                            <input type="text" class="form-control" name="city" placeholder="City">
                        </div>
                        <div class="form-group col-md-6">
                            <input type="text" class="form-control" name="referred_by" placeholder="Referred By">
                        </div>
                        <div class="form-group col-md-6">
                            <input type="text" class="form-control" name="referrer_relation" placeholder="Referrer Relation">
                        </div>
                        <div class="form-group col-md-6">
                            <input type="text" class="form-control" name="referrer_contact_no" placeholder="Referrer Contact #">
                        </div>
                        <div class="form-group col-md-6">
                            <input type="text" class="form-control" name="referrer_email" placeholder="Referrer Email">
                        </div>
                        <textarea placeholder="Message" name="message" class="form-control" rows="9" cols="25"></textarea>
                            
                        </div>
                       
                        
                    </div>
                    <div class="aligncenter">
                        <button class="btn btn-primary btn-block w-100">Continue</button>
                    </div>
                </form>
            </div>
        </div>
        <!--Form with header-->
    </div>
<section>
@endsection