<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-9aIt2nRpC12Uk9gS9baDl411NQApFmC26EwAOH8WgZl5MYYxFfc+NcPb1dKGj7Sk" crossorigin="anonymous">
        <title>Laravel</title>

    </head>
    <body>
       
<section>
    <div class="row gray-background general">
        
        <div class="container p-t-5">
            <div class="col-md-12 card p-5">
                <form role="form" enctype="multipart/form-data" method="post" action="{{url('/book-appointment')}}">    
                    <div class="card-header p-0">
                        <div class="text-center py-2">
                            <h2 class="schedule-form-head">Instant Appointment</h2>
                        </div>
                    </div>
                    <div class="card-body p-3">
                        <!--Body-->
                        <input name="_token" type="hidden" value="{{ csrf_token() }}"/>
                        <div class="form-group">
                            <label>Patient Name</label>
                            <input type="hidden" name="patient_id" value="{{$client['id']}}">
                            <input type="text" readonly class="form-control" value="{{$client['first_name'].' '.$client['last_name']}}" name="first_name" placeholder="Patient Name">
                        </div>
                        <div class="form-group">
                        <label>Doctor</label>
                            <select name="doctor" class="form-control">
                                @foreach($doctors as $doc)
                                    <option value="{{$doc->email}}">{{$doc->name}} ({{$doc->email}})</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                        <label>Patient Email</label>
                            <input type="email" readonly class="form-control" value="{{$client['email']}}" name="email" placeholder="Email">
                        </div>
                        <div class="form-group">
                        <label>Patient Phone</label>
                            <input type="text" disabled class="form-control" name="contact_no" value="{{$client['contact_no']}}" placeholder="Phone">
                        </div>
                        <label>Visit Type</label>
                            <input type="text" disabled class="form-control" name="type" value="{{$client['visit_type']}}" placeholder="Visit Type">
                        </div>
                        <label class="noBorderLabel">Preferred Date Range</label>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <input type="date" class="form-control" value="{{$client['preferred_start_date']}}" name="preferred_start_date" placeholder="Preferred Start Date">
                            </div>
                            <div class="form-group col-md-6">
                                <input type="date" class="form-control" value="{{$client['preferred_end_date']}}"  name="preferred_end_date" placeholder="Preferred End Date">
                            </div>
                        </div>
                        <label class="noBorderLabel">Preferred Time Range</label>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <input type="time" class="form-control" value="{{$client['preferred_start_time']}}"  name="preferred_start_time" placeholder="Preferred Start Time">
                            </div>
                            <div class="form-group col-md-6">
                                <input type="time" class="form-control" value="{{$client['preferred_end_time']}}"  name="preferred_end_time" placeholder="Preferred End Time">
                            </div>
                        </div>
                        <div class="form-group">
                            <label>Appointment Date</label>
                            <input onfocus="(this.type='date')" class="form-control" name="appointment_date" placeholder="Appointment Date">
                        </div>
                        <div class="form-group">
                        <label>Appointment Time</label>
                            <input type="time" class="form-control" name="appointment_time" placeholder="Appointment Time">
                        </div>
                    </div>
                    <div class="aligncenter">
                        <button class="btn btn-primary btn-block w-100">Continue</button>
                    </div>
                </form>
            </div>
        </div>
        <!--Form with header-->
    </div>
<section>
</body>
</html>