<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSubChildColumnToContent extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        //
        Schema::table('contents', function ($table) {
            $table->bigInteger('sub_child_id')->nullable()->unsigned();
            $table->index('sub_child_id')->nullable();
            $table->foreign('sub_child_id')->nullable()->references('id')->on('sub_childs')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
        Schema::table('contents', function($table) {
            $table->dropColumn('sub_child_id');
        });
    }
}
