<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSubChildTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sub_childs', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('sub_menu_id')->unsigned();
            $table->foreign('sub_menu_id')
            ->references('id')
            ->on('sub_menus');
            
            $table->string('name');
            $table->integer('display_order')->default(0);
            $table->timestamps();
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sub_menus');
    }
}
