<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateContentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contents', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('menu_id')->nullable()->unsigned();
            $table->index('menu_id')->nullable();
            $table->foreign('menu_id')->nullable()->references('id')->on('menus')->onDelete('cascade');
            $table->bigInteger('sub_menu_id')->nullable()->unsigned();
            $table->index('sub_menu_id')->nullable();
            $table->foreign('sub_menu_id')->nullable()->references('id')->on('sub_menus')->onDelete('cascade');
            $table->longText('description');
            $table->string('media');
            $table->timestamps();
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contents');
    }
}
