<?php

namespace App\Http\Controllers;
use App\SubMenu;
use App\Menu;
use Session;
use Redirect;
use Illuminate\Http\Request;

use Auth;

class SubMenuController extends Controller
{
    //
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $subMenu=SubMenu::all();
        return view('dashboard.submenu.index', ['subMenu'=>$subMenu]);
    }
    public function edit($id)
    {
        $subMenu=SubMenu::where('id',$id)->first();
        $menu=Menu::all();
        return view('dashboard.submenu.edit', ['menu'=>$menu,'subMenu'=>$subMenu]);
        
    }
    public function update($id,Request $request)
    {
        
        SubMenu::where('id', $id)
            ->update(['name' => $request->name,'menu_id'=>$request->menu_id]); 
        return redirect('/dashboard/submenu');

    }
    public function create()
    {
        $menu=Menu::all();
        return view('dashboard.submenu.create',['menu'=>$menu]);
    }
    public function store(Request $request)
    {
        $submenu=new SubMenu();
        $submenu->name=$request->name;
        $submenu->menu_id=$request->menu_id;
        $submenu->save();
        return redirect('/dashboard/submenu');
    }
    public function delete($id)
    {
        SubMenu::where('id',$id)->delete();
        return redirect('/dashboard/submenu');
    }
}

