<?php

namespace App\Http\Controllers;
use App\SubMenu;
use App\Menu;
use App\SubChild;
use Session;
use Redirect;
use Illuminate\Http\Request;
use DB;

use Auth;

class SubChildController extends Controller
{
    //
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $subChild=DB::table('sub_childs')
                    ->join('sub_menus','sub_childs.sub_menu_id','sub_menus.id')
                    ->join('menus','sub_menus.menu_id','menus.id')
                    ->select('sub_childs.*', 'sub_menus.name as subName','menus.name as menName')
                    ->get();
        // dd($subChild);
        return view('dashboard.subchild.index', ['subChild'=>$subChild]);
    }
    public function edit($id)
    {
        $subChild=SubChild::where('id',$id)->first();
        $subMenu=SubMenu::all();
        return view('dashboard.subchild.edit', ['subMenu'=>$subMenu,'subChild'=>$subChild]);
        
    }
    public function update($id,Request $request)
    {
        
        SubChild::where('id', $id)
            ->update(['name' => $request->name,'sub_menu_id'=>$request->sub_menu_id]); 
        return redirect('/dashboard/subchild');

    }
    public function create()
    {
        $subMenu=SubMenu::all();
        return view('dashboard.subchild.create',['subMenu'=>$subMenu]);
    }
    public function store(Request $request)
    {
        $subchild=new SubChild();
        $subchild->name=$request->name;
        $subchild->sub_menu_id=$request->sub_menu_id;
        $subchild->save();
        return redirect('/dashboard/subchild');
    }
    public function delete($id)
    {
        SubChild::where('id',$id)->delete();
        return redirect('/dashboard/subchild');
    }
}

