<?php

namespace App\Http\Controllers;
use App\Menu;
use Redirect;
use Session;

use Illuminate\Http\Request;

class MenuController extends Controller
{
    //
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $menu=Menu::all();
        return view('dashboard.menu.index', ['menu'=>$menu]);
    }
    public function edit($id)
    {
        $menu=Menu::where('id',$id)->first();
        return view('dashboard.menu.edit', ['menu'=>$menu]);
        
    }
    public function update($id,Request $request)
    {
        $preMenu=Menu::where('display_order',$request->display_order)->first();
        if(!empty($preMenu) )
        {
            if($preMenu['id'] == $id)
            {
                Menu::where('id', $id)
                    ->update(['name' => $request->name,'display_order'=>$request->display_order]);
                    return redirect('/dashboard/menu');
            }
            return Redirect::back()->withErrors(['Some other menu already have this order']);
        }
        Menu::where('id', $id)
            ->update(['name' => $request->name,'display_order'=>$request->display_order]); 
        return redirect('/dashboard/menu');

    }
    public function create()
    {
        return view('dashboard.menu.create');
    }
    public function store(Request $request)
    {
        $preMenu=Menu::where('display_order',$request->display_order)->first();
        if(!empty($preMenu) )
        {
            return Redirect::back()->withErrors(['Some other menu already have this order']);
        }
        // dd("yes");
        $menu=new Menu();
        $menu->name=$request->name;
        $menu->display_order=$request->display_order;
        $menu->save();
        return redirect('/dashboard/menu');
    }
    public function delete($id)
    {
        Menu::where('id',$id)->delete();
        return redirect('/dashboard/menu');
    }
}
