<?php

namespace App\Http\Controllers;
use App\Media;
use Session;
use Redirect;
use Illuminate\Http\Request;

class MediaController extends Controller
{
    //
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $media=Media::all();
        return view('dashboard.media.index', ['media'=>$media]);
    }
    public function create()
    {
        return view('dashboard.media.create');
    }
    public function store(Request $request)
    {
        // dd($request->image);
        // echo public_path('media');exit;
        if($request->hasFile('image'))
        {
            // echo "yes";
            $image = $request->file('image');
            $image_name = $image->getClientOriginalName();
            $destinationPath = public_path('img');
            $destinationPath=$destinationPath.'/'.$request->folder;
            // dd($destinationPath);
            $image->move($destinationPath, $image_name);
            $url=$destinationPath.'\\/'.$image_name;
            $media=new Media();
            $media->name=$image_name;
            $media->folder=$request->folder;
            $media->title=$request->title;
            $media->display_order=$request->display_order;
            $media->url='/img/'.$request->folder.'/'.$image_name;
            $media->path=$url;
            $media->save();
        }
        
        
        // dd("yes");
       
        return redirect('/dashboard/media');
    }
    public function edit($id)
    {
        $media=Media::where('id',$id)->first();
        return view('dashboard.media.edit', ['media'=>$media]);
        
    }
    public function update($id,Request $request)
    {
        
        Media::where('id', $id)
            ->update(['folder' => $request->folder,'title'=>$request->title]); 
        return redirect('/dashboard/media');

    }
    public function delete($id)
    {
        $media=Media::where('id',$id)->first();
        $file_path = public_path().$media['url'];
        $media->delete();
        return redirect('/dashboard/media');
    }
}
