<?php

namespace App\Http\Controllers;
use App\Menu;
use App\SubMenu;
use App\SubChild;
use App\Content;
use App\User;
use App\Media;
use App\FeedBack;
use App\Client;
use App\Doctor;
use App\Faq;
use App\FaqType;
use App\Contact;
use Illuminate\Http\Request;
use Session;
use Mail;
use URL;
use PDF;

class FrontendController extends Controller
{
    //
    public function index()
    {
        $newMenu=array();
        $menus=Menu::orderBy('menus.display_order', 'Asc')->get();
        $subNew=array();
        $menuNew=array();
        $subMenus=SubMenu::orderBy('display_order', 'Asc')->get();
        $subChild=SubChild::orderBy('id')->get();
        // dd($subChild)
        $i=0;
        foreach($menus as $menu)
        {
            $subNew=array();
            foreach($subMenus as $sub)
            {
                $subChildNew=array();
                foreach($subChild as $child)
                {
                    // echo $child->sub_menu_id."  ".$sub->id;exit;
                    if($child->sub_menu_id == $sub->id)
                    {
                        $subChildNew[]=$child;
                    }
                }
                // $menuNew[$i]['sub']['child']=$subChildNew;
                // dd($subChild);
                $sub['child']=$subChildNew;
                if($sub->menu_id == $menu->id)
                {
                    $subNew[]=$sub;
                }
                
            }
            $menuNew[$i]=$menu;
            $menuNew[$i]['sub']=$subNew;
            $i++;
        }
        $clinic=Media::where('folder','clinic')->orderBy('display_order', 'Asc')->get();
        $services=Media::where('folder','services')->orderBy('display_order', 'Asc')->get();
        $beforeAfter=Media::where('folder','before-after')->orderBy('display_order', 'Asc')->get();
        $feedback=FeedBack::orderBy('display_order', 'Asc')->get();
        // dd($menuNew);
        return view('landing', ['menus'=>$menuNew,'submenu'=>$subMenus,'clinic'=>$clinic,'services'=>$services,'beforeAfter'=>$beforeAfter,'feedback'=>$feedback]);
    }
    public function setSession(Request $request)
    {
           
        Session::put('menuId', $request->input('menuId'));
        Session::put('handler', $request->input('handler'));
        
    }
    public function botox()
    {
        $subMenu=SubMenu::where('name','Botox')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'sub');
        return redirect('/general');
    }
    public function filler()
    {
        $subMenu=SubMenu::where('name','Fillers')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'sub');
        return redirect('/general');
    }
    public function teleMedicine()
    {
        $subMenu=SubMenu::where('name','What is Telemedicine?')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'sub');
        return redirect('/general');
    }
    public function conditionDvt()
    {
        $subMenu=SubMenu::where('name','Deep Vein Thrombosis')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'sub');
        return redirect('/general');
    }
    public function conditionPoorCirculation()
    {
        $subMenu=SubMenu::where('name','Poor Circulation Symptoms')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'sub');
        return redirect('/general');
    }
    public function conditionMental()
    {
        $subMenu=SubMenu::where('name','Mental Health')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'sub');
        return redirect('/general');
    }
    public function Values()
    {
        $subMenu=SubMenu::where('name','Our Values')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'sub');
        return redirect('/general');
    }
    public function treatmentVaricose()
    {
        $subMenu=SubChild::where('name','Minimally Invasive Approach')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'child');
        return redirect('/general');
    }
    public function treatmentCommon()
    {
        $subMenu=SubMenu::where('name','Common Skin Conditions')->where('menu_id',6)->first();
        // dd($subMenu['id']);
        $subChild=SubChild::where('sub_menu_id',$subMenu['id'])->first();
        // dd($subChild);
        Session::put('menuId', $subChild['id']);
        Session::put('handler', 'child');
        return redirect('/general');
    }
    public function treatmentSpider()
    {
        $subMenu=SubMenu::where('name','Spider Veins')->where('menu_id',6)->first();
        // dd($subMenu['id']);
        $subChild=SubChild::where('sub_menu_id',$subMenu['id'])->first();
        // dd($subChild);
        Session::put('menuId', $subChild['id']);
        Session::put('handler', 'child');
        return redirect('/general');
    }
    public function treatmentReticular()
    {
        $subMenu=SubMenu::where('name','Reticular Veins')->where('menu_id',6)->first();
        // dd($subMenu['id']);
        $subChild=SubChild::where('sub_menu_id',$subMenu['id'])->first();
        // dd($subChild);
        Session::put('menuId', $subChild['id']);
        Session::put('handler', 'child');
        return redirect('/general');
    }
    public function treatmentRest()
    {
        $subMenu=SubMenu::where('name','Restless Leg Syndrome - RLS')->where('menu_id',6)->first();
        // dd($subMenu['id']);
        $subChild=SubChild::where('sub_menu_id',$subMenu['id'])->first();
        // dd($subChild);
        Session::put('menuId', $subChild['id']);
        Session::put('handler', 'child');
        return redirect('/general');
    }
    public function treatmentAcne()
    {
        $subMenu=SubMenu::where('name','Acne Scars')->where('menu_id',6)->first();
        // dd($subMenu['id']);
        $subChild=SubChild::where('sub_menu_id',$subMenu['id'])->first();
        // dd($subChild);
        Session::put('menuId', $subChild['id']);
        Session::put('handler', 'child');
        return redirect('/general');
    }
    public function treatmentHair()
    {
        $subMenu=SubMenu::where('name','Hair Fall & Thinning')->where('menu_id',6)->first();
        // dd($subMenu['id']);
        $subChild=SubChild::where('sub_menu_id',$subMenu['id'])->first();
        // dd($subChild);
        Session::put('menuId', $subChild['id']);
        Session::put('handler', 'child');
        return redirect('/general');
    }
    public function treatmentVaricoseVisual()
    {
        $subMenu=SubChild::where('name','Visual Sclerotherapy')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'child');
        return redirect('/general');
    }
    public function treatmentVaricoseUgs()
    {
        $subMenu=SubChild::where('name','Ultrasound Guided Sclerotherapy')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'child');
        return redirect('/general');
    }
    public function treatmentVaricoseEndovenous()
    {
        $subMenu=SubChild::where('name','Endovenous Laser Treatment')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'child');
        return redirect('/general');
    }
    public function treatmentVaricoseCompression()
    {
        $subMenu=SubChild::where('name','Compression Therapy')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'child');
        return redirect('/general');
    }
    public function treatmentHairPlatelet()
    {
        $subMenu=SubChild::where('name','Platelet Rich Plasma')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'child');
        return redirect('/general');
    }
    public function treatmentAcneVampire()
    {
        $subMenu=SubChild::where('name','Vampire Facial-PRP')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'child');
        return redirect('/general');
    }
    public function conditionVenous()
    {
        $subMenu=SubMenu::where('name','Venous Ulcers')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'sub');
        return redirect('/general');
    }
    public function conditionVaricose()
    {
        $subMenu=SubMenu::where('name','Varicose Veins')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'sub');
        return redirect('/general');
    }
    public function conditionSpider()
    {
        $subMenu=SubMenu::where('name','Spider Veins')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'sub');
        return redirect('/general');
    }
    public function conditionWrinkle()
    {
        $subMenu=SubChild::where('name','Wrinkles & Sagging')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'child');
        return redirect('/general');
    }
    public function conditionCrow()
    {
        $subMenu=SubChild::where('name','Crows Feet')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'child');
        return redirect('/general');
    }
    public function conditionGlabellar()
    {
        $subMenu=SubChild::where('name','Glabellar Lines')->first();
        Session::put('menuId', $subMenu['id']);
        Session::put('handler', 'child');
        return redirect('/general');
    }
    public function general()
    {
        $newMenu=array();
        $menus=Menu::orderBy('menus.display_order', 'Asc')->get();
        $subNew=array();
        $menuNew=array();
        $subMenus=SubMenu::orderBy('display_order', 'Asc')->get();
        $subChild=SubChild::orderBy('id')->get();
        // dd($subChild)
        $i=0;
        foreach($menus as $menu)
        {
            $subNew=array();
            foreach($subMenus as $sub)
            {
                $subChildNew=array();
                foreach($subChild as $child)
                {
                    // echo $child->sub_menu_id."  ".$sub->id;exit;
                    if($child->sub_menu_id == $sub->id)
                    {
                        $subChildNew[]=$child;
                    }
                }
                // $menuNew[$i]['sub']['child']=$subChildNew;
                // dd($subChild);
                $sub['child']=$subChildNew;
                if($sub->menu_id == $menu->id)
                {
                    $subNew[]=$sub;
                }
                
            }
            $menuNew[$i]=$menu;
            $menuNew[$i]['sub']=$subNew;
            $i++;
        }
        $id=Session::get('menuId');
        $handler=Session::get('handler');
        if($handler == 'menu')
        {
            Session::put('activeMenu', $id);
            $menu=Menu::where('id',$id)->first();
            $subMenu['single']=$menu->name;
            $subActive=Menu::where('id',$id)->first();
            $content=Content::where('menu_id',$id)->first();
        }
        else if($handler == 'sub')
        {
            // dd($id);
            $subMenu=SubMenu::where('id',$id)->first();
            // return $subMenu['menu_id'];
            Session::put('activeMenu', $subMenu['menu_id']);
            $menu=Menu::where('id',$subMenu['menu_id'])->first();
            $subMenu=SubMenu::where('menu_id',$subMenu['menu_id'])->orderBy('display_order', 'Asc')->get();
            $subActive=SubMenu::where('id',$id)->first();
            $content=Content::where('sub_menu_id',$id)->first();
        }
        else{
            $subChild=SubChild::where('id',$id)->first();
            $menu=SubMenu::where('id',$subChild['sub_menu_id'])->first();
            $menuActive=$menu['menu_id'];
            // return $subMenu['menu_id'];
            $child=true;
            Session::put('activeMenu', $menuActive);
            $subMenu=SubMenu::where('id',$subChild['sub_menu_id'])->first();
            $subChild=SubChild::where('sub_menu_id',$subChild['sub_menu_id'])->orderBy('id')->get();
            $subActive=SubChild::where('id',$id)->first();
            $content=Content::where('sub_child_id',$id)->first();
            return view('general', ['menu'=>$menu,'subMenus'=>$subMenu,'content'=>$content,'menus'=>$menuNew,'subActive'=>$subActive,'subChild'=>$subChild,'child'=>$child]);
        }
        // dd('hsjkf');
        return view('general', ['menu'=>$menu,'subMenus'=>$subMenu,'content'=>$content,'menus'=>$menuNew,'subActive'=>$subActive]);
    }
    public function authForm()
    {
        $pdf = PDF::loadView('auth-form');
        
        // return view('auth-form');
        return $pdf->download('pdfview.pdf');
    }
    public function scheduleOnline()
    {
        $newMenu=array();
        $menus=Menu::orderBy('menus.display_order', 'Asc')->get();
        $subNew=array();
        $menuNew=array();
        $subMenus=SubMenu::orderBy('display_order', 'Asc')->get();
        $subChild=SubChild::orderBy('id')->get();
        // dd($subChild)
        $i=0;
        foreach($menus as $menu)
        {
            $subNew=array();
            foreach($subMenus as $sub)
            {
                $subChildNew=array();
                foreach($subChild as $child)
                {
                    // echo $child->sub_menu_id."  ".$sub->id;exit;
                    if($child->sub_menu_id == $sub->id)
                    {
                        $subChildNew[]=$child;
                    }
                }
                // $menuNew[$i]['sub']['child']=$subChildNew;
                // dd($subChild);
                $sub['child']=$subChildNew;
                if($sub->menu_id == $menu->id)
                {
                    $subNew[]=$sub;
                }
                
            }
            $menuNew[$i]=$menu;
            $menuNew[$i]['sub']=$subNew;
            $i++;
        }
        session()->forget('activeMenu');
        $clinic=Media::where('folder','clinic')->orderBy('display_order', 'Asc')->get();
        $services=Media::where('folder','services')->orderBy('display_order', 'Asc')->get();
        $beforeAfter=Media::where('folder','before-after')->orderBy('display_order', 'Asc')->get();
        $feedback=FeedBack::orderBy('display_order', 'Asc')->get();
        return view('schedule-online',['menus'=>$menuNew,'submenu'=>$subMenus]);
    }
    public function sendEmail(Request $request)
    {
        $client=new Client();
        $client->first_name=$request->first_name;
        $client->last_name=$request->last_name;
        $client->email=$request->email;
        $client->contact_no=$request->contact_no;
        $client->save();
        // dd($client->id);
        $link=URL::to('/get-client');
        // dd($link);
        $data = array('id'=>$client->id,'link'=>$link);
        Mail::send('mail', $data, function($message) {
            $message->to('skinscapeusa@gmail.com', 'Tutorials Point')->subject
            ('Laravel HTML Testing Mail');
            $message->from('xyz@gmail.com','Virat Gandhi');
        });
        return redirect('/');
        // Mail::send(['mail'], $data, function($message) {
        //     $message->to('junaid.ranjha92@gmail.com', 'Tutorials Point')->subject
        //        ('Laravel Basic Testing Mail');
        //     $message->from('xyz@gmail.com','Virat Gandhi');
        //  });
        // 
    }
    public function getClient($id)
    {
        $client=Client::where('id',$id)->first();
        $doctors=Doctor::all();
        return view('get-client',['client'=>$client,'doctors'=>$doctors]);
    }
    public function bookAppointment(Request $request)
    {
        // dd($request->email);
        $client=Client::where('id',$request->patient_id)->first();
        Client::where('id', $request->patient_id)
            ->update(['appointment_date' => $request->appointment_date,'appointment_time'=>$request->appointment_time]
        );
        $doctor=Doctor::where('email',$request->doctor)->first();
        if($doctor['jwt'] == null)
        {
           $token= $this->generateJWT($doctor);
           Doctor::where('id', $doctor['id'])
                ->update(['jwt' => $token,'expiry_time'=>date('y-m-d H:i:s',strtotime(now()->addDay(365)))]
            );
            $doctor=Doctor::where('email',$request->doctor)->first();
        }
        if($client['visit_type'] == 'telemedicine') 
        {
            $meeting=$this->createMeeting($doctor,$request);
            // echo "<pre>";print_r($meeting);//exit;
            // dd($doctor['email']);
            $data = array('meeting'=>$meeting->start_url,'doctor'=>$doctor,'request'=>$request);
            Mail::send('zoom-meeting', $data, function($message) use ($doctor) {
                $message->to($doctor['email'], 'Online Appointment')->subject
                ('Zoom Meeting URL');
                $message->from('xyz@gmail.com','Skin Scape');
            });
            // dd($request);
            // echo $request->email;exit;
            $data = array('meeting'=>$meeting->join_url,'request'=>$request);
            Mail::send('zoom-meeting', $data, function($message) use($request) {
                $message->to($request->email, 'Online Appointment')->subject
                ('Zoom Meeting URL');
                $message->from('xyz@gmail.com','Skin Scape');
            });
            return view('success');
        }
        else
        {
            $data = array('meeting'=>'office','doctor'=>$doctor,'request'=>$request);
            Mail::send('zoom-meeting', $data, function($message) use ($doctor) {
                $message->to($doctor['email'], 'Clinic Appointment')->subject
                ('Appointment Confirmation');
                $message->from('xyz@gmail.com','Skin Scape');
            });
            // dd($request);
            // echo $request->email;exit;
            $data = array('meeting'=>'office','request'=>$request);
            Mail::send('zoom-meeting', $data, function($message) use($request) {
                $message->to($request->email, 'Clinic Appointment')->subject
                ('Appointment Confirmation');
                $message->from('xyz@gmail.com','Skin Scape');
            });
            return view('success');
        }

    }
    public function createMeeting($doctor,$request)
    {
        // $token=$this->generateJWT();
        // dd($token);
        
        // $request_url = 'https://api.zoom.us/v2/users/me/meetings';
        $url_events = 'https://api.zoom.us/v2/users/' . 'qLZR4RAhRSGNez9FgnGpfg/' . 'meetings?access_token='.$doctor['jwt'];
        $ch = curl_init($url_events);
            // $headers = array(
				
			// 	'Content-Type'  => 'application/json'
            // );
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                
                "Content-Type: application/json"
            ));
            $data=array();
            $data['topic']= 'Meeting with patient';
            $data['type']=5;
            $data['start_time']= $request->appointment_date.'T'.$request->appointment_time;
            $data['duration']= 10;
            $data['timezone']= 'Asia/Tashkent';
            $data['password']= '123';
            $data['agenda']= 'Diagnosis';
            $postFields = json_encode($data);
		    // print_r($postFields);exit;
			// curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
			// curl_setopt($ch, CURLOPT_URL, $request_url);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
			// curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
            $response = curl_exec($ch);
            
			$err = curl_error($ch);
			curl_close($ch);
			if(!$response){
				return $err;
			}
			return json_decode($response);
    }
    public function base64UrlEncode($string)
    {
        return str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($string));
    }

    public function generateJWT($doctor)
    {
        $headers = json_encode([
          'alg' => 'HS256',
          'typ' => 'JWT'
        ]);

        $payload = json_encode([
          'iss' => $doctor['api_key'],//api-key
          'exp' => now()->addDay(365)->timestamp
        ]);

        $base64Header = $this->base64UrlEncode($headers);
        $base64Payload = $this->base64UrlEncode($payload);

        $data = sprintf(
            '%s.%s',
            $base64Header,
            $base64Payload
        );

        $signature = hash_hmac('sha256', $data, $doctor['api_secret'], true);//api secret
        $base64Signature = $this->base64UrlEncode($signature);

        /*
        HMACSHA256(
        base64UrlEncode(header) + "." +
        base64UrlEncode(payload),
        API_SECRET)
        */
        $token = sprintf(
            '%s.%s.%s',
            $base64Header,
            $base64Payload,
            $base64Signature
        );

        return $token;
    }
    public function FAQ()
    {
        $newMenu=array();
        $menus=Menu::orderBy('menus.display_order', 'Asc')->get();
        $subNew=array();
        $menuNew=array();
        $subMenus=SubMenu::orderBy('display_order', 'Asc')->get();
        $subChild=SubChild::orderBy('id')->get();
        // dd($subChild)
        $i=0;
        foreach($menus as $menu)
        {
            $subNew=array();
            foreach($subMenus as $sub)
            {
                $subChildNew=array();
                foreach($subChild as $child)
                {
                    // echo $child->sub_menu_id."  ".$sub->id;exit;
                    if($child->sub_menu_id == $sub->id)
                    {
                        $subChildNew[]=$child;
                    }
                }
                // $menuNew[$i]['sub']['child']=$subChildNew;
                // dd($subChild);
                $sub['child']=$subChildNew;
                if($sub->menu_id == $menu->id)
                {
                    $subNew[]=$sub;
                }
                
            }
            $menuNew[$i]=$menu;
            $menuNew[$i]['sub']=$subNew;
            $i++;
        }
        Session::put('activeMenu', 10);
        $clinic=Media::where('folder','clinic')->orderBy('display_order', 'Asc')->get();
        $services=Media::where('folder','services')->orderBy('display_order', 'Asc')->get();
        $beforeAfter=Media::where('folder','before-after')->orderBy('display_order', 'Asc')->get();
        $feedback=FeedBack::orderBy('display_order', 'Asc')->get();
        $faqVein=Faq::where('type_id',1)->get();
        $faqRisk=Faq::where('type_id',2)->get();
        $faqDiagnosis=Faq::where('type_id',3)->get();
        $faqSchedule=Faq::where('type_id',4)->get();
        $faqCompression=Faq::where('type_id',5)->get();
        $faqCommon=Faq::where('type_id',6)->get();
        return view('faq',['menus'=>$menuNew,'submenu'=>$subMenus,'faqVein'=>$faqVein,'faqRisk'=>$faqRisk,'faqSchedule'=>$faqSchedule,'faqDiagnosis'=>$faqDiagnosis,'faqCompression'=>$faqCompression,'faqCommon'=>$faqCommon]);
    }
    public function contact(Request $request)
    {
        // dd($request);
        $newMenu=array();
        $menus=Menu::orderBy('menus.display_order', 'Asc')->get();
        $subNew=array();
        $menuNew=array();
        $subMenus=SubMenu::orderBy('display_order', 'Asc')->get();
        $subChild=SubChild::orderBy('id')->get();
        // dd($subChild)
        $i=0;
        foreach($menus as $menu)
        {
            $subNew=array();
            foreach($subMenus as $sub)
            {
                $subChildNew=array();
                foreach($subChild as $child)
                {
                    // echo $child->sub_menu_id."  ".$sub->id;exit;
                    if($child->sub_menu_id == $sub->id)
                    {
                        $subChildNew[]=$child;
                    }
                }
                // $menuNew[$i]['sub']['child']=$subChildNew;
                // dd($subChild);
                $sub['child']=$subChildNew;
                if($sub->menu_id == $menu->id)
                {
                    $subNew[]=$sub;
                }
                
            }
            $menuNew[$i]=$menu;
            $menuNew[$i]['sub']=$subNew;
            $i++;
        }
        Session::put('activeMenu', 9);
        if($request->isMethod('post'))
        {
            $contact=new Contact();
            $contact->first_name=$request->first_name;
            $contact->last_name=$request->last_name;
            $contact->email=$request->email;
            $contact->contact_no=$request->contact_no;
            $contact->message=$request->message;
            $contact->save();
            $data = array('contact'=>$request);
            Mail::send('contact-email', $data, function($message) {
            $message->to('skinscapeusa@gmail.com', 'Tutorials Point')->subject
            ('Laravel HTML Testing Mail');
            $message->from('xyz@gmail.com','Virat Gandhi');
            $msg='<p>You query have been received!</p>
            <p>We will contact you regarding your query shortly.</p>';
            Session::flash('message', $msg); 
            Session::flash('alert-class', 'alert-success'); 
            
        });
        }
        else
        {
            return view('contact', ['menus'=>$menuNew,'submenu'=>$subMenus]); 
        }
        return view('contact', ['menus'=>$menuNew,'submenu'=>$subMenus]); 
    }
    public function refer(Request $request)
    {
        // dd($request);
        $newMenu=array();
        $menus=Menu::orderBy('menus.display_order', 'Asc')->get();
        $subNew=array();
        $menuNew=array();
        $subMenus=SubMenu::orderBy('display_order', 'Asc')->get();
        $subChild=SubChild::orderBy('id')->get();
        // dd($subChild)
        $i=0;
        foreach($menus as $menu)
        {
            $subNew=array();
            foreach($subMenus as $sub)
            {
                $subChildNew=array();
                foreach($subChild as $child)
                {
                    // echo $child->sub_menu_id."  ".$sub->id;exit;
                    if($child->sub_menu_id == $sub->id)
                    {
                        $subChildNew[]=$child;
                    }
                }
                // $menuNew[$i]['sub']['child']=$subChildNew;
                // dd($subChild);
                $sub['child']=$subChildNew;
                if($sub->menu_id == $menu->id)
                {
                    $subNew[]=$sub;
                }
                
            }
            $menuNew[$i]=$menu;
            $menuNew[$i]['sub']=$subNew;
            $i++;
        }
        Session::put('activeMenu', 8);
        if($request->isMethod('post'))
        {
            $contact=new Contact();
            $contact->first_name=$request->first_name;
            $contact->last_name=$request->last_name;
            $contact->email=$request->email;
            $contact->contact_no=$request->contact_no;
            $contact->referred_by=$request->referred_by;
            $contact->referrer_relation=$request->referrer_relation;
            $contact->referrer_email=$request->referrer_email;
            $contact->referrer_contact_no=$request->referrer_contact_no;
            $contact->message=$request->message;
            $contact->save();
            $data = array('contact'=>$request);
            Mail::send('refer-email', $data, function($message) {
            $message->to('skinscapeusa@gmail.com', 'Tutorials Point')->subject
            ('Laravel HTML Testing Mail');
            $message->from('xyz@gmail.com','Virat Gandhi');
            $msg='<p>Thanks a lot for refering a patient!</p>';
            Session::flash('message', $msg); 
            Session::flash('alert-class', 'alert-success'); 
            
        });
        }
        else
        {
            return view('refer', ['menus'=>$menuNew,'submenu'=>$subMenus]); 
        }
        return view('refer', ['menus'=>$menuNew,'submenu'=>$subMenus]); 
    }
}
