<?php

namespace App\Http\Controllers;
use App\FeedBack;
use Illuminate\Http\Request;

class FeedBackController extends Controller
{
    //
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $feedBack=FeedBack::all();
        return view('dashboard.feedback.index', ['feedBack'=>$feedBack]);
    }
    public function create()
    {
        return view('dashboard.feedback.create');
    }
    public function store(Request $request)
    {
        $feedback=new FeedBack();
        $feedback->customer_name=$request->customer_name;
        $feedback->feedback_content=$request->feedback_content;
        $feedback->display_order=$request->display_order;
        $feedback->save();
        return redirect('/dashboard/feedback');
    }
    public function edit($id)
    {
        $feedback=FeedBack::where('id',$id)->first();
        return view('dashboard.feedback.edit', ['feedback'=>$feedback]);
        
    }
    public function update($id,Request $request)
    {
        
        FeedBack::where('id', $id)
            ->update(['feedback_content' => $request->feedback_content,'customer_name'=>$request->customer_name,'display_order'=>$request->display_order]); 
        return redirect('/dashboard/feedback');

    }
    public function delete($id)
    {
        $feedback=FeedBack::where('id',$id)->first();
        $feedback->delete();
        return redirect('/dashboard/feedback');
    }
}
