<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Faq;
use App\FaqType;
class FAQController extends Controller
{
    //
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $faq=Faq::all();
        return view('dashboard.faq.index', ['faq'=>$faq]);
    }
    public function edit($id)
    {
        $faq=Faq::where('id',$id)->first();
        $faqType=FaqType::all();
        return view('dashboard.faq.edit', ['faq'=>$faq,'faqType'=>$faqType]);
        
    }
    public function update($id,Request $request)
    {
       
        Faq::where('id', $id)
            ->update(['question' => $request->question,'answer'=>$request->answer,'type_id'=>$request->type_id]); 
        return redirect('/dashboard/faq');

    }
    public function create()
    {
        $faqType=FaqType::all();
        return view('dashboard.faq.create', ['faqType'=>$faqType]);
    }
    public function store(Request $request)
    {
        
        // dd("yes");
        $faq=new Faq();
        $faq->question=$request->question;
        $faq->answer=$request->answer;
        $faq->type_id=$request->type_id;
        $faq->save();
        return redirect('/dashboard/faq');
    }
    public function delete($id)
    {
        Faq::where('id',$id)->delete();
        return redirect('/dashboard/faq');
    }
}
