<?php

namespace App\Http\Controllers;
use App\Doctor;
use Illuminate\Http\Request;
use Session;
use Mail;
use URL;

class DoctorController extends Controller
{
    //
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $doctors=Doctor::all();
        // dd($doctors);
        return view('dashboard.doctor.index', ['doctors'=>$doctors]);
    }
    public function edit($id)
    {
        $doctor=Doctor::where('id',$id)->first();
        return view('dashboard.doctor.edit', ['doctor'=>$doctor]);
        
    }
    public function update($id,Request $request)
    {
        
        Doctor::where('id', $id)
            ->update(['name' => $request->name,'email'=>$request->email,'contact_no'=>$request->contact_no,'api_key'=>$request->api_key,'api_secret'=>$request->api_secret]); 
        return redirect('/dashboard/doctor');

    }
    public function create()
    {
        return view('dashboard.doctor.create');
    }
    public function store(Request $request)
    {
        
        // dd("yes");
        $doctor=new doctor();
        $doctor->name=$request->name;
        $doctor->email=$request->email;
        $doctor->contact_no=$request->contact_no;
        $doctor->api_key=$request->api_key;
        $doctor->api_secret=$request->api_secret;
        $doctor->save();
        return redirect('/dashboard/doctor');
    }
    public function delete($id)
    {
        Doctor::where('id',$id)->delete();
        return redirect('/dashboard/doctor');
    }
}
