<?php

namespace App\Http\Controllers;
use DB;
use App\SubMenu;
use App\Menu;
use App\Content;
use App\SubChild;
use Session;
use Redirect;
use Illuminate\Http\Request;

class ContentController extends Controller
{
    //
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $subMenu=SubMenu::all();
        $menuArray=array();
        foreach($subMenu as $sub)
        {
            $menuArray[]=$sub->menu_id;
        }
        // dd($menuArray);
        $menu=Menu::whereNotIn('menus.id', $menuArray)->get();
        $subChild=DB::table('sub_childs')
        ->join('sub_menus','sub_childs.sub_menu_id','sub_menus.id')
        ->join('menus','sub_menus.menu_id','menus.id')
        ->select('sub_childs.*', 'sub_menus.name as subName','menus.name as menName')
        ->get();
        // dd($menu);
        return view('dashboard.content.index', ['menu'=>$menu,'subMenu'=>$subMenu,'subChild'=>$subChild]);
        
    }
    public function edit($id)
    {
        $idType=$id;
        $id=explode('-',$id);
        $type_id=$id[0];
        $type=$id[1];
        if($type == 'sub'){
            // echo "sub";exit;
            $content=Content::where('sub_menu_id',$type_id)->first();
        }
        else if($type == 'child'){
            // echo "sub";exit;
            $content=Content::where('sub_child_id',$type_id)->first();
        }
        else
        {
            // echo "menu";exit;
            $content=Content::where('menu_id',$type_id)->first();   
        }
        return view('dashboard.content.edit', ['content'=>$content,'idType'=>$idType]);
    }
    public function update(Request $request)
    {
        // dd($request->idType);exit;
        $idType=$request->idType;
        $idType=explode('-',$idType);
        $id=$idType[0];
        $type=$idType[1];
        $preMenu=Menu::where('display_order',$request->display_order)->first();
        if($type == 'sub' )
        {
            $content=Content::where('sub_menu_id',$id)->first();
            if(empty($content))
            {
                $saveContent= new Content();
                $saveContent->sub_menu_id=$id;
                $saveContent->description=$request->description;
                $saveContent->save();
                return redirect('/dashboard/content');
            }
            else
            {
                Content::where('sub_menu_id', $id)
                ->update(['description' => $request->description]); 
                return redirect('/dashboard/content');
            }
        }
        else if($type == 'child' )
        {
            $content=Content::where('sub_child_id',$id)->first();
            if(empty($content))
            {
                $saveContent= new Content();
                $saveContent->sub_child_id=$id;
                $saveContent->description=$request->description;
                $saveContent->save();
                return redirect('/dashboard/content');
            }
            else
            {
                Content::where('sub_child_id', $id)
                ->update(['description' => $request->description]); 
                return redirect('/dashboard/content');
            }
        }
        else
        {
            $content=Content::where('menu_id',$id)->first();
            if(empty($content))
            {
                $saveContent= new Content();
                $saveContent->menu_id=$id;
                $saveContent->description=$request->description;
                $saveContent->save();
                return redirect('/dashboard/content');
            }
            else
            {
                Content::where('menu_id', $id)
                ->update(['description' => $request->description]); 
                return redirect('/dashboard/content');
            }
        }
            

    }
}
