<?php

class Patients_Form_Profile extends Zend_Form
{
    public function init()
    {
	
	}
	
	public function edit_password()
	{
		$this->setMethod('post'); 
		$this->setAttrib('class', 'sky-form');
		$this->setAttrib('id', 'form_edit_prof');
		
        $this->addElement('password', 'IMT_prof_oldpassword', array('label'=> 'Old Password:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('placeholder' => 'Password')));
		$this->addElement('password', 'IMT_prof_newpassword', array('label'=> 'New Password:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => 'Password')));
		$this->addElement('password', 'IMT_prof_confirmpassword', array('label'=> 'Confirm Password:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => 'Password'),'validators' => array(array('identical', false, array('token' => 'IMT_prof_newpassword')))));
		//$this->getValidator('NotEmpty')->setMessage('%value% should not be empty');
		$this->addDisplayGroup(array('IMT_prof_oldpassword', 'IMT_prof_newpassword', 'IMT_prof_confirmpassword'), 'topf');
		$submit = new Zend_Form_Element_Button('Save');
		$submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');
		$cancel = new Zend_Form_Element_Button('Cancel');
		$cancel->setAttrib('id','cancel')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-danger pull-left');		
		$this->addElements(array($cancel, $submit));
        $this->addElement('hash', 'csrf', array('ignore' => false,));	
		$this->addDisplayGroup(array($cancel, $submit, 'csrf'), 'topb');
		
		//Setting decorators//
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('divWrapper' => 'HtmlTag'), array('tag' => 'i', 'placement' => 'prepend', 'class' => 'icon-append fa fa-lock')),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_oldpassword'));
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('divWrapper' => 'HtmlTag'), array('tag' => 'i', 'placement' => 'prepend', 'class' => 'icon-append fa fa-lock')),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_newpassword'));
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array(array('divWrapper' => 'HtmlTag'), array('tag' => 'i', 'placement' => 'prepend', 'class' => 'icon-append fa fa-lock')),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_confirmpassword'));		
		$submit->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6')))); 
		$cancel->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6'))));
		//$this->getElement('csrf')->removeDecorator('errors')  ;   
        $this->getDisplayGroup('topf')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset')))); 
		$this->getDisplayGroup('topb')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset'))));  
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input-error-m">')->setElementEnd('</span>');  	  
	}
	
	public function medical()
	{
		$this->setMethod('post'); 
		$this->setAttrib('class', 'sky-form');
		$this->setAttrib('id', 'form_edit_prof');
		
		$this->addElement('text', 'IMT_prof_medical', array('label'=> 'Medical Insurance:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('placeholder' => '')));
		
		$this->addDisplayGroup(array('IMT_prof_medical'), 'topf');
		$submit = new Zend_Form_Element_Button('Save');
		$submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');
		$cancel = new Zend_Form_Element_Button('Cancel');
		$cancel->setAttrib('id','cancel')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-danger pull-left');		
		$this->addElements(array($cancel, $submit));
        $this->addElement('hash', 'csrf', array('ignore' => false,));	
		$this->addDisplayGroup(array($cancel, $submit, 'csrf'), 'topb');
		
		//Setting decorators//
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('divWrapper' => 'HtmlTag'), array('tag' => 'i', 'placement' => 'prepend', 'class' => 'icon-append fa fa-building')),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_medical'));
			
		$submit->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6')))); 
		$cancel->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6'))));   
        $this->getDisplayGroup('topf')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset')))); 
		$this->getDisplayGroup('topb')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset'))));  
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input-error-m">')->setElementEnd('</span>');
	}
	
	public function basicprofile()
	{
		$this->setMethod('post'); 
		$this->setAttrib('class', 'sky-form');
		$this->setAttrib('id', 'form_edit_prof');
		$this->addElement('text', 'IMT_prof_firstname', array('label'=> 'First Name:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('placeholder' => '')));
		$this->addElement('text', 'IMT_prof_middlename', array('label'=> 'Middle Name:', 'required' => false, 'filters' => array('StringTrim', 'StringToLower'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('text', 'IMT_prof_lastname', array('label'=> 'Last Name:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('select', 'IMT_prof_gender', array('label'=> 'Gender:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control','placeholder' => ''),'multiOptions' => array('' => 'Click to select', 'male' => 'Male', 'female' => 'Female')));
		$this->addElement('select', 'IMT_prof_maritalstatus', array('label'=> 'Marital Status:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => ''),'multiOptions' => array('' => 'Click to select', 'single' => 'Single', 'married' => 'Married','divorced' => 'Divorced','widowed' => 'Widowed','separated' => 'Separated')));
		$this->addElement('text', 'IMT_prof_dob', array('label'=> 'Birth date:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addDisplayGroup(array('IMT_prof_firstname', 'IMT_prof_middlename', 'IMT_prof_lastname','IMT_prof_gender', 'IMT_prof_maritalstatus', 'IMT_prof_dob'), 'topf');
		$submit = new Zend_Form_Element_Button('Save');
		$submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');
		$cancel = new Zend_Form_Element_Button('Cancel');
		$cancel->setAttrib('id','cancel')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-danger pull-left');		
		$this->addElements(array($cancel, $submit));
        $this->addElement('hash', 'csrf', array('ignore' => false,));	
		$this->addDisplayGroup(array($cancel, $submit, 'csrf'), 'topb');
		
		//Setting decorators//
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('divWrapper' => 'HtmlTag'), array('tag' => 'i', 'placement' => 'prepend', 'class' => 'icon-append fa fa-user')),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_firstname'));
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('divWrapper' => 'HtmlTag'), array('tag' => 'i', 'placement' => 'prepend', 'class' => 'icon-append fa fa-user')),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_middlename'));
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array(array('divWrapper' => 'HtmlTag'), array('tag' => 'i', 'placement' => 'prepend', 'class' => 'icon-append fa fa-user')),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_lastname'));
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_gender'));
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_maritalstatus'));
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array(array('divWrapper' => 'HtmlTag'), array('tag' => 'i', 'placement' => 'prepend', 'class' => 'icon-append fa fa-calendar')),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_dob'));		
		$submit->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6')))); 
		$cancel->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6'))));
		//$this->getElement('csrf')->removeDecorator('errors')  ;   
        $this->getDisplayGroup('topf')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset')))); 
		$this->getDisplayGroup('topb')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset'))));  
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input-error-m">')->setElementEnd('</span>'); 
	}
	
	public function contact_details()
	{
		$this->setMethod('post'); 
		$this->setAttrib('class', 'sky-form');
		$this->setAttrib('id', 'form_edit_prof');
		$subContent = new Common_Model_Countries();
		$result = $subContent->getAllCountries(true);
		
	//	print_r($result['keys']); die('s');
		
		$this->addElement('text', 'IMT_prof_email', array('label'=> 'Email:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('placeholder' => '')));
		$this->addElement('text', 'IMT_prof_address', array('label'=> 'Address:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('text', 'IMT_prof_apartnum', array('label'=> 'Apartment number:', 'required' => false, 'filters' => array('StringTrim', 'StringToLower'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('text', 'IMT_prof_streetnum', array('label'=> 'Street Name:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control','placeholder' => '')));
		$this->addElement('text', 'IMT_prof_zip', array('label'=> 'Zip Code:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('select', 'IMT_prof_country', array('label'=> 'Country:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array(array(
                    'InArray', true, array(
                        'haystack' => array_keys($result['keys']),
                        'messages' => array(
                            Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found"
                        )
                    )
                )), 'attribs'=>array('class' => 'form-control', 'placeholder' => ''),'multiOptions' => $result['keys']));
		
		$this->addElement('text', 'IMT_prof_city', array('label'=> 'City:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('placeholder' => '')));
		$this->addElement('text', 'IMT_prof_state', array('label'=> 'State:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('text', 'IMT_prof_cellphone', array('label'=> 'Cell Phone:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('text', 'IMT_prof_homephone', array('label'=> 'Home Phone:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control','placeholder' => '')));
		$this->addElement('text', 'IMT_prof_workphone', array('label'=> 'Work Phone:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		
		$this->addDisplayGroup(array('IMT_prof_email', 'IMT_prof_address', 'IMT_prof_apartnum','IMT_prof_streetnum', 'IMT_prof_zip', 'IMT_prof_country','IMT_prof_city', 'IMT_prof_state', 'IMT_prof_cellphone','IMT_prof_homephone', 'IMT_prof_workphone'), 'topf');
		$submit = new Zend_Form_Element_Button('Save');
		$submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');
		$cancel = new Zend_Form_Element_Button('Cancel');
		$cancel->setAttrib('id','cancel')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-danger pull-left');		
		$this->addElements(array($cancel, $submit));
        $this->addElement('hash', 'csrf', array('ignore' => false,));	
		$this->addDisplayGroup(array($cancel, $submit, 'csrf'), 'topb');
		
		//Setting decorators//
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('divWrapper' => 'HtmlTag'), array('tag' => 'i', 'placement' => 'prepend', 'class' => 'icon-append fa fa-envelope')),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_email'));
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('divWrapper' => 'HtmlTag'), array('tag' => 'i', 'placement' => 'prepend', 'class' => 'icon-append fa fa-building')),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_address'));
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('divWrapper' => 'HtmlTag'), array('tag' => 'i', 'placement' => 'prepend', 'class' => 'icon-append fa fa-building')),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_apartnum'));
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_streetnum'));
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_zip'));
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_country'));		
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_city'));
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_state'));
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('divWrapper' => 'HtmlTag'), array('tag' => 'i', 'placement' => 'prepend', 'class' => 'icon-append fa fa-mobile')),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_cellphone'));
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('divWrapper' => 'HtmlTag'), array('tag' => 'i', 'placement' => 'prepend', 'class' => 'icon-append fa fa-phone')), array('Errors'),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_homephone'));
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('divWrapper' => 'HtmlTag'), array('tag' => 'i', 'placement' => 'prepend', 'class' => 'icon-append fa fa-phone')), array('Errors'),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_workphone'));

		$submit->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6')))); 
		$cancel->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6'))));
		//$this->getElement('csrf')->removeDecorator('errors')  ;   
        $this->getDisplayGroup('topf')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset')))); 
		$this->getDisplayGroup('topb')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset'))));  
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input-error-m">')->setElementEnd('</span>'); 		
	}
	
	public function occupation()
	{
		$this->setMethod('post'); 
		$this->setAttrib('class', 'sky-form');
		$this->setAttrib('id', 'form_edit_prof');
		
		$this->addElement('text', 'IMT_prof_profession', array('label'=> 'Occupation:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('placeholder' => '')));
		
		$this->addDisplayGroup(array('IMT_prof_profession'), 'topf');
		$submit = new Zend_Form_Element_Button('Save');
		$submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');
		$cancel = new Zend_Form_Element_Button('Cancel');
		$cancel->setAttrib('id','cancel')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-danger pull-left');		
		$this->addElements(array($cancel, $submit));
        $this->addElement('hash', 'csrf', array('ignore' => false,));	
		$this->addDisplayGroup(array($cancel, $submit, 'csrf'), 'topb');
		
		//Setting decorators//
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('divWrapper' => 'HtmlTag'), array('tag' => 'i', 'placement' => 'prepend', 'class' => 'icon-append fa fa-building')),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_profession'));
			
		$submit->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6')))); 
		$cancel->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6'))));   
        $this->getDisplayGroup('topf')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset')))); 
		$this->getDisplayGroup('topb')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset'))));  
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input-error-m">')->setElementEnd('</span>');
	}
	
	public function profilepicture()
	{
		$this->setMethod('post'); 
		$this->setAttrib('class', 'sky-form');
		$this->setAttrib('id', 'form_edit_prof');
		$this->setAttrib('enctype', 'multipart/form-data'); 
		
		$this->addElement('file', 'IMT_prof_profilepicture', array('label'=> 'Profile Picture:', 'required' => true,'destination'=> CCPATH_APPLICATION."/../public/images/profilepics", 'validators' => array(array('Count', false, 1),array('Size', false, 1024000),array('Extension', false, 'jpg, png')),'attribs'=>array() ));
		
		$this->addDisplayGroup(array('IMT_prof_profilepicture'), 'topf');
		$submit = new Zend_Form_Element_Button('Save');
		$submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');
		$cancel = new Zend_Form_Element_Button('Cancel');
		$cancel->setAttrib('id','cancel')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-danger pull-left');		
		$this->addElements(array($cancel, $submit));
        $this->addElement('hash', 'csrf', array('ignore' => false,));	
		$this->addDisplayGroup(array($cancel, $submit, 'csrf'), 'topb');
		
		//Setting decorators//
		//$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('divWrapper' => 'HtmlTag'), array('tag' => 'i', 'placement' => 'prepend', 'class' => 'icon-append fa fa-building')),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_profilepicture'));
			
		$submit->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6')))); 
		$cancel->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6'))));   
        $this->getDisplayGroup('topf')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset')))); 
		$this->getDisplayGroup('topb')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset'))));  
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input-error-m">')->setElementEnd('</span>');
	}
	
	public function settings($settings)
	{
		$this->setMethod('post'); 
		$this->setAttrib('class', 'sky-form');
		$this->setAttrib('id', 'form_edit_prof');
		$fields = array();
		foreach ($settings as $k=>$v)
		{
			$namefield = 'IMT_settings'.$v['id'];
			if ($v['type'] == 'set')
			{
				$keys_fields = explode(',',$v['options']);
				$values_fields = explode(',',$v['displayoptions']);
				$this->addElement('select', $namefield, array('label'=> $v['name'].':', 'required' => true, 'filters' => array('StringTrim'), 
					'validators' => array(array('InArray', true, array('haystack' => $keys_fields,'messages' => array(Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found")))), 'attribs'=>array('class' => 'form-control', 'placeholder' => ''),'multiOptions' => array_combine($keys_fields, $values_fields)));
			}
			elseif ($v['type'] == 'int')
			{
				$this->addElement('text', $namefield, array('label'=> $v['name'].':', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
			}
			
			$fields[] = $namefield;
			if (isset($v['value'])) 
			{
				$this->setDefaults(array(
					$namefield => $v['value']
				));
			}
			else {
				$this->setDefaults(array(
					$namefield => $v['default_value']
				));
			}
		}
		
		$this->addDisplayGroup($fields, 'topf');
		$submit = new Zend_Form_Element_Button('Save');
		$submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');
		$cancel = new Zend_Form_Element_Button('Cancel');
		$cancel->setAttrib('id','cancel')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-danger pull-left');		
		$this->addElements(array($cancel, $submit));
        $this->addElement('hash', 'csrf', array('ignore' => false,));	
		$this->addDisplayGroup(array($cancel, $submit, 'csrf'), 'topb');
		
		//Setting decorators//
		foreach ($fields as $field => $datafield)
		{
			$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array($datafield));
		}
			
		$submit->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6')))); 
		$cancel->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6'))));   
        $this->getDisplayGroup('topf')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset')))); 
		$this->getDisplayGroup('topb')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset'))));  
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input-error-m">')->setElementEnd('</span>');
	}
	
}