<?php

class Providers_PortalController extends Zend_Controller_Action
{
    public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$this->view->userislogged = $this->_helper->AccessControlTower->checkAccess();
		$this->sogRequestsObj = new Common_Model_Sogcases();
		
		
    }

    public function indexAction()
    {
		$this->view->newAssignedCases = $this->sogRequestsObj->getNewRequestsByProvider($this->view->userislogged[1]['providercode']);

		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('portal_view.php');	
    }
	
	
    public function profileAction()
    {		
		$request = $this->getRequest();
		$prof_sesion = new Zend_Session_Namespace('profile_editing_session');
		if ((null ==  $request->getParam('done')) and isset($prof_sesion->update_completed))
		{
			$done = $request->getParam('done');
			$this->view->orign = $prof_sesion->origin; // = 'password';
			//should be one time operation. So we delete the session space to avoid confusion
			Zend_Session::namespaceUnset('profile_editing_session');
		}
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('profile/profile_view.php');	
	}


    public function settingsAction()
    {		
		$request = $this->getRequest();
		$prof_sesion = new Zend_Session_Namespace('profile_editing_session');
		if ((null ==  $request->getParam('done')) and isset($prof_sesion->update_completed))
		{
			$done = $request->getParam('done');
			$this->view->orign = $prof_sesion->origin; 
			//should be one time operation. So we delete the session space to avoid confusion
			Zend_Session::namespaceUnset('profile_editing_session');
		}
		
		$settings_obj = new Common_Model_Settings();	
		$settinglist = $settings_obj->getGeneralSettingsByCustomer($this->view->userislogged[0][0]);
		
		$this->view->settings = $settinglist;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('settings_view.php');	
	}

    public function logoutAction()
    {		
	
		$cs_session_global = new Zend_Session_Namespace('provider_is_logged_in');	
		unset($cs_session_global->svd_username);
		unset($cs_session_global->svd_password);		
		
		return $this->_redirect('/');
	}	
	
	
}