<?php

class Providers_ConsultsController extends Zend_Controller_Action
{

    public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$loadSession = new Common_Model_Session();	
		$userislogged = $loadSession->_loadDefaultSession();
		if (!$userislogged)
		{
			return $this->_redirect('/auth/access/login');
		}
		else {
			$this->view->userislogged = $userislogged;	
		}	
		$this->sogRequestsObj = new Common_Model_Sogcases();
		$this->request = $this->getRequest();
		
    }

    public function indexAction()
    {
		
		//
    }

    public function newlistingAction()
    {
		$this->view->newAssignedCases = $this->sogRequestsObj->getNewRequestsByProvider($this->view->userislogged[1]['providercode']);

		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('consults/newlisting_view.php');	
    }


    public function viewlistingAction()
    {
		$this->view->caseReferenceId = $this->request->getParam('ckey', 'Missing !!');
		if ($this->view->caseReferenceId == 'Missing !!')
		{
			$this->view->errorProcess = true;
			$this->view->errorDetail = 'CASE_NOT_FOUND';
		}
		else 
		{
			$this->view->caseDetail = $this->sogRequestsObj->getCaseByIdAndProvider($this->view->caseReferenceId, $this->view->userislogged[1]['providercode']);
			if ($this->view->caseDetail == false)
			{
				$this->view->errorProcess = true;
				$this->view->errorDetail = 'CASE_NOT_FOUND';
			}
			else 
			{
				$soghealthObj = new Common_Model_Soghealth();
				$checkIfPHHFilled = $soghealthObj->isPHHFilledForCases($this->view->caseDetail);
				if ($checkIfPHHFilled == 1)
				{
					$this->view->noPHHProvided = true;
				}
				else
				{
					if (strlen(trim($this->view->caseDetail['medicPstInfo'])) != 0)
					{
						$this->view->noHealthInfo = false;
						$pffs = $this->sogRequestsObj->getHealthByCase($this->view->caseDetail['medicPstInfo']);
						if ($pffs)
						{
							$this->view->viewPHHH = true;
							$this->view->allPstQuestions = $pffs;
						}
					}

					if (strlen(trim($this->view->caseDetail['medicFamlInfo'])) != 0)
					{
						$this->view->noHealthInfo = false;
						$pffs = $this->sogRequestsObj->getHealthByCase($this->view->caseDetail['medicFamlInfo']);
						if ($pffs)
						{
							$this->view->viewFHHH = true;
							$this->view->allFamQuestions = $pffs;
						}
					}	

					if (strlen(trim($this->view->caseDetail['medicPrsInfo'])) != 0)
					{
						$this->view->noHealthInfo = false;
						$pffs = $this->sogRequestsObj->getHealthByCase2($this->view->caseDetail['medicPrsInfo']);
						if ($pffs)
						{
							$this->view->viewPreHHH = true;
							$this->view->allPreQuestions = $pffs;
						}
					}	
				}

				$sogfilesObj = new Common_Model_Sogfiles();
    			$this->view->listUploadedFiles = $sogfilesObj->getAttachmentsForCase($this->view->caseReferenceId);
    			$targetDir = CCPATH_APPLICATION."/data/datacases/store/".$this->view->caseReferenceId;

				if (is_object($this->view->listUploadedFiles))
				{
					$caseFilesSession = new Zend_Session_Namespace('new_file_request_for_case');
					
					foreach ($this->view->listUploadedFiles as $key => $val)
					{
						$encryptedFileName = sha1($val['fileRef']);
						$caseFilesSession->objects[$encryptedFileName] = $targetDir.'/'.$val['fileRef'];

						$filesAttach[$val['fileRef']] = $encryptedFileName;
					}
					$this->view->filesAttach = $filesAttach;
				}

				$this->view->allQuestions = $this->sogRequestsObj->getQuestionsByCase($this->view->caseDetail['id'], $this->view->caseDetail['Patient Id']);
				//}
			}
		}

		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('consults/viewlisting_view.php');	
    }


   public function getfileAction()
    {
        $this->view->caseReferenceId = $this->request->getParam('ckey', 'Missing !!');
        if ($this->view->caseReferenceId != 'none')
        {
			$this->view->caseDetail = $this->sogRequestsObj->getCaseByIdAndProvider($this->view->caseReferenceId, $this->view->userislogged[1]['providercode']);
        }


        if ($this->view->caseReferenceId == 'none' or $this->view->caseDetail == false)
        {
            echo  false;
           // $this->view->exitMade = 'provider_not_found';

        }
        else
        {
            $this->view->fileName = $this->request->getParam('_fA', 'none');
            if ($this->view->caseReferenceId != 'none')
            {
                $up_fileinfo = pathinfo(CCPATH_APPLICATION."/data/datacases/store/".$this->view->caseReferenceId.'/'.$this->view->fileName);


                $sendFile = $this->_helper->getHelper('SendFile');
                $sendFile->sendFile(CCPATH_APPLICATION."/data/datacases/store/".$this->view->caseReferenceId.'/'.$this->view->fileName, $up_fileinfo['extension']);
            }
        }

    }


    public function caseclosedAction()
    {
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('consults/caseclosed_view.php');	
    }

    public function currentAction()
    {
		$this->view->newAssignedCases = $this->sogRequestsObj->getCurrentRequestsByProvider($this->view->userislogged[1]['providercode']);

		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('consults/current_view.php');	
    }

    public function completedAction()
    {
    	$this->view->newAssignedCases = $this->sogRequestsObj->getClosedRequestsByProvider($this->view->userislogged[1]['providercode']);
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('consults/completed_view.php');	
    }


    public function viewinprogAction()
    {
		
		$this->view->caseReferenceId = $this->request->getParam('ckey', 'Missing !!');
		if ($this->view->caseReferenceId == 'Missing !!')
		{
			$this->view->errorProcess = true;
			$this->view->errorDetail = 'CASE_NOT_FOUND';
		}
		else 
		{
			$this->view->caseDetail = $this->sogRequestsObj->getCaseByIdAndProvider($this->view->caseReferenceId, $this->view->userislogged[1]['providercode']);
			if ($this->view->caseDetail == false)
			{
				$this->view->errorProcess = true;
				$this->view->errorDetail = 'CASE_NOT_FOUND';
			}
			else 
			{
				//$this->view->caseViewSelected = $this->request->getParam('spf', 'Missing !!');
				
				$soghealthObj = new Common_Model_Soghealth();
				$checkIfPHHFilled = $soghealthObj->isPHHFilledForCases($this->view->caseDetail);
				if ($checkIfPHHFilled == 1)
				{
					$this->view->noPHHProvided = true;
				}
				else
				{
					if (strlen(trim($this->view->caseDetail['medicPstInfo'])) != 0)
					{
						$this->view->noHealthInfo = false;
						$pffs = $this->sogRequestsObj->getHealthByCase($this->view->caseDetail['medicPstInfo']);
						if ($pffs)
						{
							$this->view->viewPHHH = true;
							$this->view->allPstQuestions = $pffs;
						}
					}

					if (strlen(trim($this->view->caseDetail['medicFamlInfo'])) != 0)
					{
						$this->view->noHealthInfo = false;
						$pffs = $this->sogRequestsObj->getHealthByCase($this->view->caseDetail['medicFamlInfo']);
						if ($pffs)
						{
							$this->view->viewFHHH = true;
							$this->view->allFamQuestions = $pffs;
						}
					}	

					if (strlen(trim($this->view->caseDetail['medicPrsInfo'])) != 0)
					{
						$this->view->noHealthInfo = false;
						$pffs = $this->sogRequestsObj->getHealthByCase2($this->view->caseDetail['medicPrsInfo']);
						if ($pffs)
						{
							$this->view->viewPreHHH = true;
							$this->view->allPreQuestions = $pffs;
						}
					}	
				}

				$sogfilesObj = new Common_Model_Sogfiles();
    			$this->view->listUploadedFiles = $sogfilesObj->getAttachmentsForCase($this->view->caseReferenceId);
    			$targetDir = CCPATH_APPLICATION."/data/datacases/store/".$this->view->caseReferenceId;

				if (is_object($this->view->listUploadedFiles))
				{
					$caseFilesSession = new Zend_Session_Namespace('new_file_request_for_case');
					
					foreach ($this->view->listUploadedFiles as $key => $val)
					{
						$encryptedFileName = sha1($val['fileRef']);
						$caseFilesSession->objects[$encryptedFileName] = $targetDir.'/'.$val['fileRef'];

						$filesAttach[$val['fileRef']] = $encryptedFileName;
					}
					$this->view->filesAttach = $filesAttach;
				}
				
					
					
					$this->view->allQuestions = $this->sogRequestsObj->getQuestionsByCase($this->view->caseDetail['id'], $this->view->caseDetail['Patient Id']);
				
				
				
			}
		}

		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('consults/viewinprog_view.php');	
    }


    public function viewclosedAction()
    {
		$this->view->caseReferenceId = $this->request->getParam('ckey', 'Missing !!');
		if ($this->view->caseReferenceId == 'Missing !!')
		{
			$this->view->errorProcess = true;
			$this->view->errorDetail = 'CASE_NOT_FOUND';
		}
		else 
		{
			$this->view->caseDetail = $this->sogRequestsObj->getCaseByIdAndProvider($this->view->caseReferenceId, $this->view->userislogged[1]['providercode']);
			if ($this->view->caseDetail == false)
			{
				$this->view->errorProcess = true;
				$this->view->errorDetail = 'CASE_NOT_FOUND';
			}
			else 
			{
				$this->view->caseViewSelected = $this->request->getParam('spf', 'Missing !!');
				
				if ($this->view->caseViewSelected == 'medical')
				{
					$this->view->noHealthInfo = true;
					
					if (strlen(trim($this->view->caseDetail['medicPstInfo'])) != 0)
					{
						$this->view->noHealthInfo = false;
						$pffs = $sogRequestsObj->getHealthByCase($this->view->caseDetail['medicPstInfo']);
						if ($pffs)
						{
							$this->view->viewPHHH = true;
							$this->view->allPstQuestions = $pffs;
						}
					}

					if (strlen(trim($this->view->caseDetail['medicFamlInfo'])) != 0)
					{
						$this->view->noHealthInfo = false;
						$pffs = $sogRequestsObj->getHealthByCase($this->view->caseDetail['medicFamlInfo']);
						if ($pffs)
						{
							$this->view->viewFHHH = true;
							$this->view->allFamQuestions = $pffs;
						}
					}		
					
					$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
					echo $this->view->render('consults/viewmedical_view.php');
					return;	
				}
				else
				{
					$caseFilesSession = new Zend_Session_Namespace('new_file_request_for_case');
					
					//===== ===/////
					if (file_exists(CCPATH_APPLICATION."/data/datacases/store/".$this->view->caseReferenceId.'/docnotes.pdf'))
					{
						$this->view->docNotesFile = $this->generateKeyFile('docnotes_'.time());
						$caseFilesSession->objects[$this->view->docNotesFile] = CCPATH_APPLICATION."/data/datacases/store/".$this->view->caseReferenceId.'/docnotes.pdf';
					}
					
					//===== ===/////
					if (file_exists(CCPATH_APPLICATION."/data/datacases/store/".$this->view->caseReferenceId.'/labreports.pdf'))
					{
						$this->view->labReportFile = $this->generateKeyFile('labreports_'.time());
						$caseFilesSession->objects[$this->view->labReportFile] = CCPATH_APPLICATION."/data/datacases/store/".$this->view->caseReferenceId.'/labreports.pdf';
					}
					
					//===== ===/////
					if (file_exists(CCPATH_APPLICATION."/data/datacases/store/".$this->view->caseReferenceId.'/imgstudy.pdf'))
					{
						$this->view->imgStudyFile = $this->generateKeyFile('imgstudy_'.time());
						$caseFilesSession->objects[$this->view->imgStudyFile] = CCPATH_APPLICATION."/data/datacases/store/".$this->view->caseReferenceId.'/imgstudy.pdf';
					}
					
					//===== ===/////
					if (file_exists(CCPATH_APPLICATION."/data/datacases/store/".$this->view->caseReferenceId.'/otherdoc.pdf'))
					{
						$this->view->otherDocFile = $this->generateKeyFile('otherdoc_'.time());
						$caseFilesSession->objects[$this->view->otherDocFile] = CCPATH_APPLICATION."/data/datacases/store/".$this->view->caseReferenceId.'/otherdoc.pdf';
					}
					
					$this->view->allQuestions = $this->sogRequestsObj->getQuestionsByCase($this->view->caseDetail['id'], $this->view->caseDetail['Patient Id']);
				}
			}
		}

		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('consults/viewclosed_view.php');	
    }


    public function rejectcaseAction()
    {
		$this->view->caseReferenceId = $this->request->getParam('ckey', 'Missing !!');
		if ($this->view->caseReferenceId == 'Missing !!')
		{
			$this->view->errorProcess = true;
			$this->view->errorDetail = 'CASE_NOT_FOUND';
		}
		else 
		{
			$this->view->caseDetail = $this->sogRequestsObj->getCaseByIdAndProvider($this->view->caseReferenceId, $this->view->userislogged[1]['providercode']);
			//echo '<pre>'; print_r($this->view->caseDetail);
			if ($this->view->caseDetail == false)
			{
				$this->view->errorProcess = true;
				$this->view->errorDetail = 'CASE_NOT_FOUND';
			}
			else 
			{
				if ($this->request->isPost()) 
				{
					$comments = '';
					if ($this->request->getPost('sog_nextaction_rejection') == 'missing')
					{
						$comments = $this->request->getPost('sog_missing_comments');
					}
					elseif ($this->request->getPost('sog_nextaction_rejection') == 'provider')
					{
						$comments = $this->request->getPost('sog_provider_recommend');
					}

					$this->sogRequestsObj->updateRejectionForCase($this->view->caseReferenceId, $this->request->getPost('sog_reasons_rejectioncase'), $this->request->getPost('sog_nextaction_rejection'), $comments);

					$this->sogRequestsObj->updateAdminStatusForCase($this->view->caseReferenceId, 'unresolved');
					return $this->_redirect('/providers/consults/caserejected');
				}
			}
		}


		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('consults/rejectcase_view.php');	
    }


    public function caserejectedAction()
    {
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('consults/caserejected_view.php');	
    }

    public function acceptcaseAction()
    {
		$this->view->caseReferenceId = $this->request->getParam('ckey', 'Missing !!');
		if ($this->view->caseReferenceId == 'Missing !!')
		{
			$this->view->errorProcess = true;
			$this->view->errorDetail = 'CASE_NOT_FOUND';
		}
		else 
		{
			$this->view->caseDetail = $this->sogRequestsObj->getCaseByIdAndProvider($this->view->caseReferenceId, $this->view->userislogged[1]['providercode']);
			if ($this->view->caseDetail == false)
			{
				$this->view->errorProcess = true;
				$this->view->errorDetail = 'CASE_NOT_FOUND';
			}
			else 
			{
				$this->sogRequestsObj->updateAdminStatusForCase($this->view->caseReferenceId, 'accepted');
				
			}
		}
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('consults/acceptcase_view.php');	
    }

    public function closecaseAction()
    {
    	$this->view->caseReferenceId = $this->request->getParam('ckey', 'Missing !!');
		if ($this->view->caseReferenceId == 'Missing !!')
		{
			$this->view->errorProcess = true;
			$this->view->errorDetail = 'CASE_NOT_FOUND';
		}
		else 
		{
			$this->view->caseDetail = $this->sogRequestsObj->getCaseByIdAndProvider($this->view->caseReferenceId, $this->view->userislogged[1]['providercode']);
			if ($this->view->caseDetail == false)
			{
				$this->view->errorProcess = true;
				$this->view->errorDetail = 'CASE_NOT_FOUND';
			}
		}
		
		if ($this->request->isPost()) 
		{
			
			$caseResultsObj = new Common_Model_Caseresults();
			$caseResultsObj->saveResults($this->view->caseReferenceId, $this->request->getPost('sog_treatment_summary'), $this->request->getPost('sog_question1_answer'), $this->request->getPost('sog_question2_answer'), $this->request->getPost('sog_question3_answer'), $this->request->getPost('sog_recommendation'), $this->request->getPost('sog_signature'));
			;
			$this->sogRequestsObj->closeCaseByProvider($this->view->caseReferenceId);
			
			return $this->_redirect('/providers/consults/caseclosed');
		}
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('consults/closecase_view.php');	
    }
	
	public function viewcaseclosureAction()
	{
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('consults/caseclosure_view.php');	
	}
	
}