<?php

class Providers_AccessController extends Zend_Controller_Action
{
	public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		
		
    }
	
	
	
	public function activateAction()
	{
		$this->request = $this->getRequest();
		$keylink = $this->request->getParam('key');
		$actionkey = new Common_Model_Members();
		$results = $actionkey->findKeyActivation($keylink);
		if ($results == false)
		{
			$this->view->notification = 'Sorry, the account you are trying to activate is either already activated or does not exist.';
		}
		else
		{ 
			if ($actionkey->activateMember($results['id']) == false)
			{
				$this->view->notification = 'We are having difficulties to activate this account. Plese try again later.';
			}
			else {
				$ippp = new Common_Model_Ippps();
				$info = $ippp->loadIpp($results['ippid'], true);
				$this->view->notification = 'Your account is now activated.';
				$message_to_opener = "<p><span style=\"font-family:'Segoe UI'\">Dear ".$info['First name'].", <br /><br />Your account is now activated. </span></p><span style=\"font-family:'Segoe UI'\"><p>Sincerely yours.<br />iMatter Automated Registration System</p></span>";
				$subject_to_opener =  "iMatter: Your account is activated";
				$to_to_opener      = $info['Email']; 
				$headers = "From:iMatter Registration Deptm. <registration@imatter.co>";
				$headers  .= 'MIME-Version: 1.0' . "\r\n";
				$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";	
				@mail($to_to_opener, $subject_to_opener, $message_to_opener, $headers);
			}
		}
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('activate_view.php');	
	}
	
	
    public function loginAction()
    {
		$form = new Auth_Form_Accessproviders();
		$form->login();
		$request = $this->getRequest();
		if ($request->isPost()) 
		{
			if ($form->isValid($request->getPost())) 
			{
				$this->ulogin = new Auth_Model_Authproviders();
				$loadProviderCheck = $this->ulogin->findProvider($request->getPost('imatmlogin'),$request->getPost('imatmpassword'));
				if ($loadProviderCheck == false)
				{
					$this->view->notification = 'The username or password you have entered does not exist.';
					$form->populate($request->getPost());
				}
				elseif ($loadProviderCheck[2] == 0)
				{
					$this->view->notification = 'Your account is not yet activated. If you believe this is an error, please kindly contact our service support.';
					$form->populate($request->getPost());
				}
				else
				{
					$cs_session_global = new Zend_Session_Namespace('provider_is_logged_in');
					$cs_session_global->svd_username = $request->getPost('imatmlogin');
					$cs_session_global->svd_password = $request->getPost('imatmpassword');
					return $this->_redirect('providers/portal');	
				}
			}
			else {
				$this->view->notification = 'The username or password is missing or incorrect.';
				$form->populate($request->getPost());	
			}
		}
		$this->view->loginForm = $form;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('plogin_view.php');	
	}
	
    public function signupAction()
    {
		$reg_form = new Auth_Form_Accessproviders();
		$reg_form->signup();
		if ($this->request->isPost()) 
		{
			if ($reg_form->isValid($this->request->getPost())) 
			{
				$ulogin = new Auth_Model_Authproviders();
				if ($ulogin->findProvider($this->request->getPost('imat_prv_username')) != false)
				{
					$this->view->errors_form = true;
					$this->view->notification = 'Sorry, the username is already in use.';
				}
				else {
					if ($this->request->getPost('imat_prv_boardcertified') == 1 and ($this->request->getPost('imat_prv_boardname') == "" or $this->request->getPost('imat_prv_boardyearsdone') == "" or $this->request->getPost('imat_prv_boardname') == null or $this->request->getPost('imat_prv_boardyearsdone') == null))
					{
						if ($this->request->getPost('imat_prv_boardname') == "" or $this->request->getPost('imat_prv_boardname') == null )
						{
							$reg_form->imat_prv_boardname->markAsError();
							$reg_form->imat_prv_boardname->addError('Missing');
						}
						if ($this->request->getPost('imat_prv_boardyearsdone') == "" or $this->request->getPost('imat_prv_boardyearsdone') == null )
						{
							$reg_form->imat_prv_boardyearsdone->markAsError();
							$reg_form->imat_prv_boardyearsdone->addError('Missing');
						}
						$this->view->errors_form = true;
						$this->view->notification = 'Please provide the Board name and the years completed';
					}
					elseif (null == $this->_getParam('imat_prv_conditions', null))
					{
						$this->view->errors_form = true;
						$this->view->notification = 'Please accept the terms and conditions before you can complete the registration.';
					}
					else
					{
						/******************/
						$locationFile = $reg_form->imat_prv_credentials->getFileName(); 
						$up_fileinfo = pathinfo($locationFile);
						$location = $reg_form->imat_prv_credentials->getValue();
						$filename = sha1($this->request->getPost('imat_prv_firstname')).sha1($this->request->getPost('imat_prv_lastname')).'.'.$up_fileinfo['extension'];
						$new_destination = $up_fileinfo['dirname'].'/'.$filename;
						$filterRename = new Zend_Filter_File_Rename(array('target' => $new_destination, 'overwrite' => true)); 
						$filterRename->filter($locationFile); 
						$reg_form->imat_prv_credentials->receive();
						/******************/
						$session_key = sha1($this->request->getPost('imat_prv_firstname')).sha1($this->request->getPost('imat_prv_lastname')).sha1(time());
						$prd_obj = new Common_Model_Eppps();
						$idr = $prd_obj->createEppforProvider($this->request->getPost('imat_prv_lastname'),$this->request->getPost('imat_prv_middlename'),$this->request->getPost('imat_prv_firstname'),$this->request->getPost('imat_prv_professionaldesignation'),$this->request->getPost('imat_prv_practicename'),$this->request->getPost('imat_prv_emailaddress'),$this->request->getPost('imat_prv_phonenumber'),$this->request->getPost('imat_prv_boardcertified'),$this->request->getPost('imat_prv_boardname'),$this->request->getPost('imat_prv_boardyearsdone'),$this->request->getPost('imat_prv_areaspecialisation1'),$this->request->getPost('imat_prv_areaspecialisation2'),$this->request->getPost('imat_prv_areaspecialisation3'),$filename);
						/*********************/
						
						$prd_obj = new Common_Model_Providers();
						$prd_obj->createProvider($idr, $this->request->getPost('imat_prv_username'), $this->request->getPost('imat_prv_password'),$session_key);
						
						$linkofactivation = 'http://imatter.citeso.com1.sws/provider/activate/key/'.$session_key;	
						$message_to_opener ='
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
   <head>
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
      <title>iMatter Registration</title>
      <style type="text/css">
         /* Client-specific Styles */
         #outlook a {padding:0;} /* Force Outlook to provide a "view in browser" menu link. */
         body{width:100% !important; -webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; margin:0; padding:0;}
         /* Prevent Webkit and Windows Mobile platforms from changing default font sizes, while not breaking desktop design. */
         .ExternalClass {width:100%;} /* Force Hotmail to display emails at full width */
         .ExternalClass, .ExternalClass p, .ExternalClass span, .ExternalClass font, .ExternalClass td, .ExternalClass div {line-height: 100%;} /* Force Hotmail to display normal line spacing. */
         #backgroundTable {margin:0; padding:0; width:100% !important; line-height: 100% !important;}
         img {outline:none; text-decoration:none;border:none; -ms-interpolation-mode: bicubic;}
         a img {border:none;}
         .image_fix {display:block;}
         p {margin: 0px 0px !important;}
         table td {border-collapse: collapse;}
         table { border-collapse:collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; }
         a {color: #33b9ff;text-decoration: none;text-decoration:none!important;}
         /*STYLES*/
         table[class=full] { width: 100%; clear: both; }
         /*IPAD STYLES*/
         @media only screen and (max-width: 640px) {
         a[href^="tel"], a[href^="sms"] {
         text-decoration: none;
         color: #0a8cce; /* or whatever your want */
         pointer-events: none;
         cursor: default;
         }
         .mobile_link a[href^="tel"], .mobile_link a[href^="sms"] {
         text-decoration: default;
         color: #0a8cce !important;
         pointer-events: auto;
         cursor: default;
         }
         table[class=devicewidth] {width: 440px!important;text-align:center!important;}
         table[class=devicewidthmob] {width: 420px!important;text-align:center!important;}
         table[class=devicewidthinner] {width: 420px!important;text-align:center!important;}
         img[class=banner] {width: 440px!important;height:157px!important;}
         img[class=col2img] {width: 440px!important;height:330px!important;}
         table[class="cols3inner"] {width: 100px!important;}
         table[class="col3img"] {width: 131px!important;}
         img[class="col3img"] {width: 131px!important;height: 82px!important;}
         table[class="removeMobile"]{width:10px!important;}
         img[class="blog"] {width: 420px!important;height: 162px!important;}
         }

         /*IPHONE STYLES*/
         @media only screen and (max-width: 480px) {
         a[href^="tel"], a[href^="sms"] {
         text-decoration: none;
         color: #0a8cce; /* or whatever your want */
         pointer-events: none;
         cursor: default;
         }
         .mobile_link a[href^="tel"], .mobile_link a[href^="sms"] {
         text-decoration: default;
         color: #0a8cce !important; 
         pointer-events: auto;
         cursor: default;
         }
         table[class=devicewidth] {width: 280px!important;text-align:center!important;}
         table[class=devicewidthmob] {width: 260px!important;text-align:center!important;}
         table[class=devicewidthinner] {width: 260px!important;text-align:center!important;}
         img[class=banner] {width: 280px!important;height:100px!important;}
         img[class=col2img] {width: 280px!important;height:210px!important;}
         table[class="cols3inner"] {width: 260px!important;}
         img[class="col3img"] {width: 280px!important;height: 175px!important;}
         table[class="col3img"] {width: 280px!important;}
         img[class="blog"] {width: 260px!important;height: 100px!important;}
         td[class="padding-top-right15"]{padding:15px 15px 0 0 !important;}
         td[class="padding-right15"]{padding-right:15px !important;}
         }
      </style>
   </head>
   <body>
<!-- Start of preheader -->
<table width="100%" bgcolor="#dbdbdb" cellpadding="0" cellspacing="0" border="0" id="backgroundTable" st-sortable="preheader" >
   <tbody>
      <tr>
         <td>
            <table width="560" cellpadding="0" cellspacing="0" border="0" align="center" class="devicewidth">
               <tbody>
                  <tr>
                     <td width="100%">
                        <table width="560" cellpadding="0" cellspacing="0" border="0" align="center" class="devicewidth">
                           <tbody>
                              <!-- Spacing -->
                              <tr>
                                 <td width="100%" height="10"></td>
                              </tr>
                              <!-- Spacing -->
                              <tr>
                                 <td align="center" valign="middle" style="font-family: Helvetica, arial, sans-serif; font-size: 10px;color: #303030;text-align:center;" st-content="viewonline">
                                    If you can’t read this email.Please 
                                    <a href="#" style="text-decoration: none; color: #7a6e67">view online</a> 
                                 </td>
                                 <!-- Spacing -->
                              </tr>
                              <tr>
                                 <td width="100%" height="10"></td>
                              </tr>
                              <!-- Spacing -->
                           </tbody>
                        </table>
                     </td>
                  </tr>
               </tbody>
            </table>
         </td>
      </tr>
   </tbody>
</table>
<!-- End of preheader -->      
<!-- Start of header -->
<table width="100%" bgcolor="#d8d8d8" cellpadding="0" cellspacing="0" border="0" id="backgroundTable" st-sortable="header">
   <tbody>
      <tr>
         <td>
            <table width="560" cellpadding="0" cellspacing="0" border="0" align="center" class="devicewidth">
               <tbody>
                  <tr>
                     <td width="100%">
                        <table bgcolor="#FFF" width="560" cellpadding="0" cellspacing="0" border="0" align="center" style="border-top-left-radius:5px;border-top-right-radius:5px;" class="devicewidth">
                           <tbody>
                              <!-- Spacing -->
                              <tr>
                                 <td height="10" style="font-size:1px; line-height:1px; mso-line-height-rule: exactly;">&nbsp;</td>
                              </tr>
                              <!-- Spacing -->
                              <tr>
                                 <td>
                                    <!-- logo -->
                                    <table width="194" align="left" border="0" cellpadding="0" cellspacing="0">
                                       <tbody>
                                          <tr>
                                             <td width="20"></td>
                                             <td width="174" height="60" align="left">
                                                <div class="imgpop">
                                                   <a target="_blank" href="#">
                                                   Logo iMatter
                                                   </a>
                                                </div>
                                             </td>
                                          </tr>
                                       </tbody>
                                    </table>
                                    <!-- end of logo -->

                                 </td>
                              </tr>
                              <!-- Spacing -->
                              <tr>
                                 <td height="10" style="font-size:1px; line-height:1px; mso-line-height-rule: exactly;">&nbsp;</td>
                              </tr>
                              <!-- Spacing -->
                           </tbody>
                        </table>
                     </td>
                  </tr>
               </tbody>
            </table>
         </td>
      </tr>
   </tbody>
</table>
<!-- End of Header -->
<!-- Start of main-banner -->
<table width="100%" bgcolor="#d8d8d8" cellpadding="0" cellspacing="0" border="0" id="backgroundTable" st-sortable="banner">
   <tbody>
      <tr>
         <td>
            <table width="560" cellpadding="0" cellspacing="0" border="0" align="center" class="devicewidth">
               <tbody>
                  <tr>
                     <td width="100%">
                        <table width="560" align="center" cellspacing="0" cellpadding="0" border="0" class="devicewidth">
                           <tbody>
                              <tr>
                                 <!-- start of image -->
                                 <td align="center" st-image="banner-image" bgcolor="8ec449">
                                    <table class="full" align="center" width="540" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse; mso-table-lspace:0pt; mso-table-rspace:0pt;"> 
                                       <tbody>
                                          <tr> 
                                             <td width="100%" height="30">&nbsp; </td> 
                                          </tr> 
                                          <!-- START OF HEADING--> 
                                          <tr> 

                                             <td class="center" align="center" style="margin: 0; padding: 0 15px 15px 15px; margin:0; text-transform: uppercase; font-family: Helvetica, Arial; font-size: 23px; color: #ffffff; line-height: 34px; mso-line-height-rule: exactly;"> 
                                                <span> Thank you for registering with us.</span> 
                                             </td> 
                                          </tr> 
                                          <!-- END OF HEADING--> 
                                          <!-- START OF TEXT--> 
                                          <tr> 
                                             <td class="center" align="center" style="margin: 0; padding:0 30px 0 30px; margin:0; font-size:14px ; color:#ffffff; font-family: Helvetica, Arial, sans-serif; line-height: 20px;mso-line-height-rule: exactly;">
                                                <span>Thank you for registering with iMatter.care as a provider. Your information is referred to our credentialing provider relations department. We will promptly send you an email regarding the status of your registration</span> 
                                             </td> 
                                          </tr> 
                                          <!-- END OF TEXT--> 
                                          <!-- START OF BUTTON-->
                                          
                                       <!-- START OF BUTTON--> 
                                       <tr> 
                                          <td width="100%" height="30">&nbsp; </td> 
                                       </tr> 
                                    </tbody>
                                 </table>
                                   
                                 </td>
                              </tr>
                           </tbody>
                        </table>
                        <!-- end of image -->
                     </td>
                  </tr>
               </tbody>
            </table>
         </td>
      </tr>
   </tbody>
</table>
<!-- End of main-banner -->
<!-- Start of postfooter -->
<table width="100%" bgcolor="#dbdbdb" cellpadding="0" cellspacing="0" border="0" id="backgroundTable" st-sortable="preheader" >
   <tbody>
      <tr>
         <td>
            <table width="560" cellpadding="0" cellspacing="0" border="0" align="center" class="devicewidth">
               <tbody>
                  <tr>
                     <td width="100%">
                        <table bgcolor="#ffffff" width="560" cellpadding="0" cellspacing="0" border="0" align="center" class="devicewidth">
                           <tbody>
                              <!-- Spacing -->
                              <tr>
                                 <td width="100%" height="10"></td>
                              </tr>
                              <!-- Spacing -->
                              <tr>
                                 <td align="center" valign="middle" style="font-family: Helvetica, arial, sans-serif; font-size: 13px;color: #7a6e67;text-align:center;" st-content="viewonline">
                                    iMatter Registration System 
                                 </td>
                              </tr>
                              <tr>
                                 <td align="center" valign="middle" style="font-family: Helvetica, arial, sans-serif; font-size: 13px;color: #7a6e67;text-align:center;" st-content="viewonline">
                                    If you wish not to receive further updates.Please 
                                    <a href="#" style="text-decoration: none; color: #303030">Unsubscribe</a> 
                                 </td>
                              </tr>
                                 <!-- Spacing -->
                              <tr>
                                 <td width="100%" height="10"></td>
                              </tr>
                              <!-- Spacing -->
                           </tbody>
                        </table>
                     </td>
                  </tr>
               </tbody>
            </table>
         </td>
      </tr>
   </tbody>
</table>
<!-- End of postfooter -->

   </body>
   </html>';
	  
						$subject_to_opener =  "iMatter registration of account";
						$to_to_opener      = $this->request->getPost('imat_prv_emailaddress'); 
						$headers = "From:iMatter Registration Deptm. <registration@imatter.co>";
						$headers  .= 'MIME-Version: 1.0' . "\r\n";
						$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";								
						
						@mail($to_to_opener, $subject_to_opener, $message_to_opener, $headers);
						$this->view->completed = true;
					}
				}
			}
			else {
				$this->view->errors_form = true;
				//$this->view->error_message = $reg_form->getMessages();
				print_r($reg_form->getErrors());
				print_r($reg_form->getErrorMessages());
				$this->view->notification = 'Errors in the form. Please fill or correct the fields highlithed in red.';
			}
		}
		$this->view->signupform = $reg_form;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('psignup_view.php');	
	}	
	
	public function logoutAction()
    {		
	
		$cs_session_global = new Zend_Session_Namespace('member_is_logged_in');	
		unset($cs_session_global->svd_username);
		unset($cs_session_global->svd_password);		
		
		return $this->_redirect('providers');
	}	
	
}
