<?php

class Patients_Form_Cases extends Zend_Form
{
	public $subContent = "";
    public function init()
    {
	
	}

	public function categoriesNewCase($catgoriesList)
	{
        $this->setMethod('post'); 
		
		$this->addElement('select', 'sog_categories_fld', array('label' => 'Specialization', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array(array('InArray', true, array('haystack' => array_keys($catgoriesList['keys']),'messages' => array(Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found") ))), 'attribs'=>array('class' => 'form-control form-control-lg ', 'placeholder' => ''),'multiOptions' => $catgoriesList['keys']));
		
		$this->addElement('select', 'sog_pricing_fld', array('label' => 'Pricing Options', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array(array('InArray', true, array('haystack' => array('a','b','c'),'messages' => array(Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found") ))), 'attribs'=>array('class' => 'form-control form-control-lg ', 'placeholder' => ''),'multiOptions' => array('a'=>'Detailed Written Consultation $239', 'b'=> 'Extended Written Consultation $ 439', 'c'=> 'Center of Excellence Consultation $ 599')));

		$this->addElement('textarea', 'sog_problemdescription_fld', array('label'=> 'Please provide us a brief description (500 words maximum): ', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control form-control-lg', 'placeholder' => '', 'rows' => 3)));
			
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('data' => 'HtmlTag'))));
		
		$submit = new Zend_Form_Element_Button('Save');
		$submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');
		$this->addElements(array($submit));
		$this->addElement('hash', 'sog_csrf_fld', array('ignore' => false,));	
		$submit->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-12'))));  
		
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input-error-m">')->setElementEnd('</span>'); 
	}

	

	public function questionsForCase()
	{
        $this->setMethod('post'); 
		
		$this->addElement('text', 'sog_question1_fld', array('label'=> '', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control form-control-lg ', 'placeholder' => '', 'autocomplete' => 'off')));
		
		$this->addElement('text', 'sog_question2_fld', array('label'=> 'Question 2 (*):', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control form-control-lg ', 'placeholder' => '', 'autocomplete' => 'off')));
		
		$this->addElement('text', 'sog_question3_fld', array('label'=> 'Question 3 (*):', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control form-control-lg ', 'placeholder' => '', 'autocomplete' => 'off')));
		
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('data' => 'HtmlTag'))));
		
		$submit = new Zend_Form_Element_Button('Save');
		$submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');
		$this->addElements(array($submit));
		$this->addElement('hash', 'sog_csrf_fld', array('ignore' => false,));	
		$submit->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-12'))));  
		
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input-error-m">')->setElementEnd('</span>'); 
	}


	public function attachmentsForCase()
	{
        $this->setMethod('post'); 
		
		$this->addElement('hidden', 'sog_optionAttachment_fld', array('label'=> '', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control form-control-lg ', 'placeholder' => '', 'autocomplete' => 'off')));
		
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('data' => 'HtmlTag'))));
		
		$submit = new Zend_Form_Element_Button('Save');
		$submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');
		$this->addElements(array($submit));
		$this->addElement('hash', 'sog_csrf_fld', array('ignore' => false,));	
		$submit->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-12'))));  
		
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input-error-m">')->setElementEnd('</span>'); 
	}
	
	

	public function medicalPastForCase($listOfQuestions)
	{
        $this->setMethod('post'); 
		
		if (isset($listOfQuestions[1]))
		{
			$this->addElement('multiCheckbox', 'sog_questionidx_fld_1',array('required' => false, 'filters' => array('StringTrim'),'multiOptions' => $listOfQuestions[1]));
		}
		if (isset($listOfQuestions[2]))
		{
			$this->addElement('multiCheckbox', 'sog_questionidx_fld_2',array('required' => false, 'filters' => array('StringTrim'),'multiOptions' => $listOfQuestions[2]));
		}
		if (isset($listOfQuestions[3]))
		{
			$this->addElement('multiCheckbox', 'sog_questionidx_fld_3',array('required' => false, 'filters' => array('StringTrim'),'multiOptions' => $listOfQuestions[3]));
		}
	

		
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('data' => 'HtmlTag')), array('Label', array('class'=> 'label','placement' => 'append'))));
		
		$this->addElement('textarea', 'sog_description_fld', array('label'=> 'Describe in detail above conditions:', 'required' => false, 'filters' => array('StringTrim', 'StringToLower'), 'attribs'=>array('placeholder' => '', 'rows' => 4, 'class' => 'form-control form-control-lg')));
		
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label'))), array('sog_description_fld'));
		
		
		$submit = new Zend_Form_Element_Button('Save');
		$submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');
		$this->addElements(array($submit));
		$this->addElement('hash', 'sog_csrf_fld', array('ignore' => false,));	
		$submit->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-12'))));  
		
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input-error-m">')->setElementEnd('</span>'); 
	}
	
	
	public function uploadfilesForCase()
	{
        $this->setMethod('post'); 
		
		$this->addElement('file', 'sog_docnotes_fld', array('label'=> 'Doctor Notes & Reports:', 'required' => false,'destination'=> CCPATH_APPLICATION."/data/datacases/store", 'validators' => array(array('Count', false, 1),array('Size', false, 1024000),array('Extension', false, 'jpg, png, pdf')),'attribs'=>array() ));
		
		$this->addElement('file', 'sog_labreports_fld', array('label'=> 'Lab Reports:', 'required' => false,'destination'=> CCPATH_APPLICATION."/data/datacases/store", 'validators' => array(array('Count', false, 1),array('Size', false, 1024000),array('Extension', false, 'jpg, png, pdf')),'attribs'=>array() ));
		
		$this->addElement('file', 'sog_imagesscans_fld', array('label'=> 'Images/Scans Study:', 'required' => false,'destination'=> CCPATH_APPLICATION."/data/datacases/store", 'validators' => array(array('Count', false, 1),array('Size', false, 1024000),array('Extension', false, 'jpg, png, pdf')),'attribs'=>array() ));
		
		$this->addElement('file', 'sog_otherdocuments_fld', array('label'=> 'Other Documents:', 'required' => false,'destination'=> CCPATH_APPLICATION."/data/datacases/store", 'validators' => array(array('Count', false, 1),array('Size', false, 1024000),array('Extension', false, 'jpg, png, pdf')),'attribs'=>array() ));

		$this->addDisplayGroup(array('sog_docnotes_fld', ), 'topf');
		$submit = new Zend_Form_Element_Button('Save');
		$submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');
		$cancel = new Zend_Form_Element_Button('Cancel');
		$cancel->setAttrib('id','cancel')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-danger pull-left');		
		$this->addElements(array($cancel, $submit));
        $this->addElement('hash', 'sog_csrf_fld', array('ignore' => false,));	
	//	$this->addDisplayGroup(array($cancel, $submit, 'csrf'), 'topb');
		
		
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input-error-m">')->setElementEnd('</span>'); 
	}	
}