<?php

class Patients_SogrequestsController extends Zend_Controller_Action
{

    public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$this->view->userislogged = $this->_helper->AccessControlTower->checkAccess();
		$this->view->defaultInfo = $this->_helper->LoadDefaultInfo->getAllInfo($this->view->userislogged[0][0]);

		$this->request = $this->getRequest();
		$this->aptmSession = new Zend_Session_Namespace('aptm_new_booking');
    }
	
	public function indexAction()
	{
		$sogRequestsObj = new Common_Model_Sogcases();	
		$this->view->openedCases = $sogRequestsObj->getAllRequestsByUser($this->view->userislogged[0][0]);

		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('requests/home_view.php');	
	}
	
	public function searchAction()
	{
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('requests/search_view.php');	
	}
	

    public function viewlistingAction()
    {
    	$sogRequestsObj = new Common_Model_Sogcases();	
		$this->view->openedCases = $sogRequestsObj->getAllRequestsByUser($this->view->userislogged[0][0]);

		$this->view->caseReferenceId = $this->request->getParam('ckey', 'Missing !!');
		if ($this->view->caseReferenceId == 'Missing !!')
		{
			$this->view->errorProcess = true;
			$this->view->errorDetail = 'CASE_NOT_FOUND';
		}
		else 
		{
			$sogRequestsObj = new Common_Model_Sogcases();	
			$this->view->caseDetail = $sogRequestsObj->getRequestById($this->view->caseReferenceId);
			if ($this->view->caseDetail == false)
			{
				$this->view->errorProcess = true;
				$this->view->errorDetail = 'CASE_NOT_FOUND';
			}
			else 
			{
				$rosSession = new Zend_Session_Namespace('case_request_ros');
				$keyConer = sha1($this->view->caseReferenceId);
				$rosSession->link[$keyConer] = $this->view->caseReferenceId;
				$this->view->keyCase = $keyConer;

				$soghealthObj = new Common_Model_Soghealth();
				$checkIfPHHFilled = $soghealthObj->isPHHFilledForCases($this->view->caseDetail);
				if ($checkIfPHHFilled == 1)
				{
					$this->view->noPHHProvided = true;
				}
				else
				{
					if (strlen(trim($this->view->caseDetail['medicPstInfo'])) != 0)
					{
						$this->view->noHealthInfo = false;
						$pffs = $sogRequestsObj->getHealthByCase($this->view->caseDetail['medicPstInfo']);
						if ($pffs)
						{
							$this->view->viewPHHH = true;
							$this->view->allPstQuestions = $pffs;
						}
					}

					if (strlen(trim($this->view->caseDetail['medicFamlInfo'])) != 0)
					{
						$this->view->noHealthInfo = false;
						$pffs = $sogRequestsObj->getHealthByCase($this->view->caseDetail['medicFamlInfo']);
						if ($pffs)
						{
							$this->view->viewFHHH = true;
							$this->view->allFamQuestions = $pffs;
						}
					}	

					if (strlen(trim($this->view->caseDetail['medicPrsInfo'])) != 0)
					{
						$this->view->noHealthInfo = false;
						$pffs = $sogRequestsObj->getHealthByCase2($this->view->caseDetail['medicPrsInfo']);
						if ($pffs)
						{
							$this->view->viewPreHHH = true;
							$this->view->allPreQuestions = $pffs;
						}
					}	
				}

				$sogfilesObj = new Common_Model_Sogfiles();
    			$this->view->listUploadedFiles = $sogfilesObj->getAttachmentsForCase($this->view->caseReferenceId);
    			$targetDir = CCPATH_APPLICATION."/data/datacases/store/".$this->view->caseReferenceId;

				if (is_object($this->view->listUploadedFiles))
				{
					$caseFilesSession = new Zend_Session_Namespace('new_file_request_for_case');
					
					foreach ($this->view->listUploadedFiles as $key => $val)
					{
						$encryptedFileName = sha1($val['fileRef']);
						$caseFilesSession->objects[$encryptedFileName] = $targetDir.'/'.$val['fileRef'];

						$filesAttach[$val['fileRef']] = $encryptedFileName;
					}
					$this->view->filesAttach = $filesAttach;
				}
				
				$detailsPlan = $this->getPaymentPlan($this->view->caseDetail['planSelected']);
				$this->view->selected_plan = $detailsPlan['namea'];
				$this->view->cost_plan = $detailsPlan['plana'];
				$this->view->total_cost_plan = $detailsPlan['plana'];
				
				$this->view->allQuestions = $sogRequestsObj->getQuestionsByCase($this->view->caseDetail['id'], $this->view->caseDetail['Patient Id']);
				//}

				/*
				$this->view->caseViewSelected = $this->request->getParam('spf', 'Missing !!');
				
				if ($this->view->caseViewSelected == 'medical')
				{
					$this->view->noHealthInfo = true;
					
									

								
					
					$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
					echo $this->view->render('requests/viewmedical_view.php');
					return;	
				}
				else
				{*/
					//$caseFilesSession = new Zend_Session_Namespace('new_file_request_for_case');
				
			}
		}
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('requests/viewlisting_view.php');	
    }
	
	
	public function getfilesAction()
	{
		$keyDownloadFile = $this->request->getParam('ckey', 'Missing !!');
		if ($keyDownloadFile == 'Missing !!')
		{
			die('Cannot fetch file !!');	
		}
		
		$caseFilesSession = new Zend_Session_Namespace('new_file_request_for_case');
		if (!isset($caseFilesSession->objects[$keyDownloadFile]))
		{
			die('Cannot fetch file !!');	
		}


		$up_fileinfo = pathinfo($caseFilesSession->objects[$keyDownloadFile]);
        $sendFile = $this->_helper->getHelper('SendFile');
        $sendFile->sendFile($caseFilesSession->objects[$keyDownloadFile], $up_fileinfo['extension']);
		
		unset($caseFilesSession->objects[$keyDownloadFile]);
		return;
	}
	
	private function getPaymentPlan($selectedPlan)
	{
		$config = Zend_Controller_Front::getInstance()->getParam('bootstrap');
		$btKeys = $config->getOption('bt');

		if ($selectedPlan == 'a'){
			return array('namea' => $btKeys['namea'],'plana' => $btKeys['plana']);
		}
		elseif ($selectedPlan == 'b'){
			return array('namea' => $btKeys['nameb'],'plana' => $btKeys['planb']);
		}
		elseif ($selectedPlan == 'c'){
			return array('namea' => $btKeys['namec'],'plana' => $btKeys['planc']);
		}		
	}
	
	private function generateKeyFile($fileType)
	{
		return sha1($fileType);
	}
	
	public function viewcaseclosureAction()
	{
		$this->view->caseReferenceId = $this->request->getParam('ckey', 'Missing !!');
		
		$sogRequestsObj = new Common_Model_Sogcases();	
		$this->view->caseDetail = $sogRequestsObj->getCaseDetails($this->view->caseReferenceId);
			if ($this->view->caseDetail == false)
			{
				//
				die('Error');
			}
			else 
			{
				$rosSession = new Zend_Session_Namespace('case_request_ros');
				$keyConer = sha1($this->view->caseReferenceId);
				$rosSession->link[$keyConer] = $this->view->caseReferenceId;
				$this->view->keyCase = $keyConer;

				$soghealthObj = new Common_Model_Soghealth();
				$checkIfPHHFilled = $soghealthObj->isPHHFilledForCases($this->view->caseDetail);
				if ($checkIfPHHFilled == 1)
				{
					$this->view->noPHHProvided = true;
				}
				
				$sogfilesObj = new Common_Model_Sogfiles();
    			$this->view->listUploadedFiles = $sogfilesObj->getAttachmentsForCase($this->view->caseReferenceId);
    			$targetDir = CCPATH_APPLICATION."/data/datacases/store/".$this->view->caseReferenceId;


				$detailsPlan = $this->getPaymentPlan($this->view->caseDetail['planSelected']);
				$this->view->selected_plan = $detailsPlan['namea'];
				$this->view->cost_plan = $detailsPlan['plana'];
				$this->view->total_cost_plan = $detailsPlan['plana'];
				
				$this->view->allQuestions = $sogRequestsObj->getQuestionsByCase($this->view->caseDetail['id'], $this->view->caseDetail['Patient Id']);
				
				$caseResultObj = new Common_Model_Caseresults();
				$this->view->caseResults = $caseResultObj->getCaseResults($this->view->caseReferenceId);
				
				$providerObj = new Common_Model_Providers();
				$this->view->providerInfo = $providerObj->getProviderDetail($this->view->caseDetail['Provider id']);
				
				
			}
		
		
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('requests/caseclosure_view.php');	
	}
	
}