<?php

class Patients_RosController extends Zend_Controller_Action
{

    public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$this->view->userislogged = $this->_helper->AccessControlTower->checkAccess();
		$this->view->defaultInfo = $this->_helper->LoadDefaultInfo->getAllInfo($this->view->userislogged[0][0]);
		$this->request = $this->getRequest();	
    }


    public function indexAction()
    {
    	return $this->_redirect('patients/requests/new');	
    }


    public function fillAction()
    {
    	$step = $this->request->getParam('spe', NULL);
    	if (is_null($step))
		{
			return $this->_redirect('patients/portal');	
		}
		$this->view->keyCode = $step;
		

    	$rosSession = new Zend_Session_Namespace('case_request_ros');
    	if (!isset($rosSession->link[$step]))
    	{
    		return $this->_redirect('patients/portal');	
    	}
    	$this->view->caseReference = $rosSession->link[$step];

    	$sogRequestsObj = new Common_Model_Sogcases();	
		$this->view->caseDetail = $sogRequestsObj->getRequestById($this->view->caseReference);
		if ($this->view->caseDetail == false)
		{
			return $this->_redirect('patients/portal');
		}

    	$soghealthObj = new Common_Model_Soghealth();
		$this->view->noPHHProvided = $soghealthObj->isPHHFilledForCases($this->view->caseDetail);
		

		$action = $this->request->getParam('phase', 'default');
    	if ($action == 'default' or $action == 'fhistory')
		{
			return $this->_forward('family', null, null);
			//break;
		}
		elseif ($action == 'phistory')
		{
			return $this->_forward('past', null, null);
			//break;
		}
		elseif ($action == 'chistory')
		{
			return $this->_forward('current', null, null);
			//break;
		}
		elseif ($action == 'done')
		{
			return $this->_forward('done', null, null);
			//break;
		}
		else
		{
			echo "Reached the unreachable";
		}
    }


    public function familyAction()
    {
		$newCaseFormObj = new Patients_Form_Cases();
    	$ros_objs = new Common_Model_HH();	
		$hh1list = $ros_objs->getHHCodes(2);

		if (isset($this->view->caseDetail['medicFamlInfo']) and strlen(trim($this->view->caseDetail['medicFamlInfo'])) != 0)
		{
			$preloadedData = array_flip(split(',',$this->view->caseDetail['medicFamlInfo']));	
		}
		else 
		{
			$preloadedData = array();	
		}
		
		$totalqts = sizeof($hh1list['catb']);
		$columns1 = ceil($totalqts/3);
		$counter = 1; $i = 1;
		foreach ($hh1list['catb'] as $cKey => $cValue)
		{
			if ($counter < $columns1)
			{
				if (isset($preloadedData[$cValue['idqx']]))
				{
					$preloadedDataFB[$i][$cValue['idqx']] = $cValue['idqx'];
				}
				$listOfQuestions[$i][$cValue['idqx']] = $cValue['question'];
				$counter++;
			}
			else 
			{
				$counter = 1;	
				$i++;
			}
		}


		$newCaseFormObj->medicalPastForCase($listOfQuestions);
		if ($this->request->isPost()) 
		{
			if (!$newCaseFormObj->isValid($this->request->getPost())) 
			{
				//echo 'error';
				//print_r($newCaseFormObj->getMessages());
				$this->view->errors_form = true;
				$this->view->errors_notification = 'Error. Your data cannot be submited, please correct the errors highlithed below.';
			}
			else 
			{
				//print_r($this->request->getPost('sog_questionidx_fld_1', NULL));
				
				$dataToSave = array();
				$col1 = $this->request->getPost('sog_questionidx_fld_1', NULL);
				if (!is_null($col1))
				{
					$dataToSave = array_merge($dataToSave, $col1);
				}
				
				$col2 = $this->request->getPost('sog_questionidx_fld_2', NULL);
				if (!is_null($col2))
				{
					$dataToSave = array_merge($dataToSave, $col2);
				}
				
				$col3 = $this->request->getPost('sog_questionidx_fld_3', NULL);
				if (!is_null($col3))
				{
					$dataToSave = array_merge($dataToSave, $col3);
				}
				
				$caseObj = new Common_Model_Soghealth();
				$caseObj->updateMedicFamilyForCase($this->view->caseReference, implode(',', array_values($dataToSave)), $this->request->getPost('sog_description_fld'));

				return $this->_redirect('patients/ros/fill/spe/'.$this->view->keyCode.'/phase/phistory');	
				

			}
		}
		else {
			
			if (isset($this->view->caseDetail['medicFamlInfo']) and strlen(trim($this->view->caseDetail['medicFamlInfo'])) != 0)
			{
				if (isset($preloadedDataFB[1]))
				{
					$newCaseFormObj->sog_questionidx_fld_1->setValue($preloadedDataFB[1]);
				}
				if (isset($preloadedDataFB[2]))
				{
					$newCaseFormObj->sog_questionidx_fld_2->setValue($preloadedDataFB[2]);
				}
				if (isset($preloadedDataFB[3]))
				{
					$newCaseFormObj->sog_questionidx_fld_3->setValue($preloadedDataFB[3]);
				}

				$dataToPost = array(
					'sog_description_fld' => $this->view->caseDetail['descriptionFamlInfo'],
				);
				$newCaseFormObj->populate($dataToPost);
			}
		}
		
		$this->view->questionsForm = $newCaseFormObj;
		$this->view->hh1 = $hh1list['catb'];

    	$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('ros/fhistory.php');
    }


    public function pastAction()
    {
		$newCaseFormObj = new Patients_Form_Cases();
    	$ros_objs = new Common_Model_HH();	
		$hh1list = $ros_objs->getHHCodes(1);

		if (isset($this->view->caseDetail['medicFamlInfo']) and strlen(trim($this->view->caseDetail['medicPstInfo'])) != 0)
		{
			$preloadedData = array_flip(split(',',$this->view->caseDetail['medicPstInfo']));	
		}
		else 
		{
			$preloadedData = array();	
		}
		
		$totalqts = sizeof($hh1list['cata']);
		$columns1 = ceil($totalqts/3);
		$counter = 1; $i = 1;
		foreach ($hh1list['cata'] as $cKey => $cValue)
		{
			if ($counter < $columns1)
			{
				if (isset($preloadedData[$cValue['idqx']]))
				{
					$preloadedDataFB[$i][$cValue['idqx']] = $cValue['idqx'];
				}
				$listOfQuestions[$i][$cValue['idqx']] = $cValue['question'];
				$counter++;
			}
			else 
			{
				$counter = 1;	
				$i++;
			}
		}


		$newCaseFormObj->medicalPastForCase($listOfQuestions);
		if ($this->request->isPost()) 
		{
			if (!$newCaseFormObj->isValid($this->request->getPost())) 
			{
				//echo 'error';
				//print_r($newCaseFormObj->getMessages());
				$this->view->errors_form = true;
				$this->view->errors_notification = 'Error. Your data cannot be submited, please correct the errors highlithed below.';
			}
			else 
			{
				$dataToSave = array();
				$col1 = $this->request->getPost('sog_questionidx_fld_1', NULL);
				if (!is_null($col1))
				{
					$dataToSave = array_merge($dataToSave, $col1);
				}
				
				$col2 = $this->request->getPost('sog_questionidx_fld_2', NULL);
				if (!is_null($col2))
				{
					$dataToSave = array_merge($dataToSave, $col2);
				}
				
				$col3 = $this->request->getPost('sog_questionidx_fld_3', NULL);
				if (!is_null($col3))
				{
					$dataToSave = array_merge($dataToSave, $col3);
				}
				
				$caseObj = new Common_Model_Soghealth();
				$caseObj->updateMedicPastForCase($this->view->caseReference, implode(',', array_values($dataToSave)), $this->request->getPost('sog_description_fld'));

				return $this->_redirect('patients/ros/fill/spe/'.$this->view->keyCode.'/phase/chistory');	
				
			}
		}
		else {
			
			if (isset($this->view->caseDetail['medicPstInfo']) and strlen(trim($this->view->caseDetail['medicPstInfo'])) != 0)
			{
				if (isset($preloadedDataFB[1]))
				{
					$newCaseFormObj->sog_questionidx_fld_1->setValue($preloadedDataFB[1]);
				}
				if (isset($preloadedDataFB[2]))
				{
					$newCaseFormObj->sog_questionidx_fld_2->setValue($preloadedDataFB[2]);
				}
				if (isset($preloadedDataFB[3]))
				{
					$newCaseFormObj->sog_questionidx_fld_3->setValue($preloadedDataFB[3]);
				}

				$dataToPost = array(
					'sog_description_fld' => $this->view->caseDetail['descriptionPstInfo'],
				);
				$newCaseFormObj->populate($dataToPost);
			}
		}
		
		$this->view->questionsForm = $newCaseFormObj;
		$this->view->hh1 = $hh1list['cata'];
		
    	$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('ros/phistory.php');
    }


    public function currentAction()
    {

    	$ros_obj = new Common_Model_Ros();	
		$questionslist = $ros_obj->getrosCodes();
		$this->view->postqros = array();

		if ($this->request->isPost()) 
		{
			$this->view->postqros = $this->request->getPost('checkboxes', array());

			$this->view->heightFld = $this->request->getPost('heightFld', 0);
			$this->view->weightFld = $this->request->getPost('weightFld', 0);

			$caseObj = new Common_Model_Soghealth();
			$caseObj->updateMedicPresentForCase($this->view->caseReference, implode(',', array_values($this->view->postqros)), $this->request->getPost('heightFld'), $this->request->getPost('weightFld'));

			return $this->_redirect('patients/ros/fill/spe/'.$this->view->keyCode.'/phase/done');	

		}
		else
		{
			if (isset($this->view->caseDetail['medicPrsInfo']) and strlen(trim($this->view->caseDetail['medicPrsInfo'])) != 0)
			{
				$this->view->postqros = explode(',', $this->view->caseDetail['medicPrsInfo']);
				$this->view->heightFld = $this->view->caseDetail['height'];
				$this->view->weightFld = $this->view->caseDetail['weight'];
			}

		}


		$this->view->qros = $questionslist;
    	$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('ros/chistory.php');
    }

	public function doneAction()
    {
		//$rosSession = new Zend_Session_Namespace('case_request_ros');
		//unset($rosSession->link);

    	$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('ros/done.php');
    }

}