<?php

class Patients_RequestsController extends Zend_Controller_Action
{

    public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$this->view->userislogged = $this->_helper->AccessControlTower->checkAccess();
		$this->view->defaultInfo = $this->_helper->LoadDefaultInfo->getAllInfo($this->view->userislogged[0][0]);
		$this->request = $this->getRequest();
		$this->caseSession = new Zend_Session_Namespace('new_case_request');

		if (isset($this->caseSession->caseObjects['selectedPlan']) and isset($this->view->defaultInfo['allBasket'][0]['Ref #']))
		{
			$detailsPlan = $this->getPaymentPlan($this->caseSession->caseObjects['selectedPlan']);
			$this->view->selected_plan = $detailsPlan['namea'];
			$this->view->cost_plan = $detailsPlan['plana'];
			$this->view->total_cost_plan = $detailsPlan['plana'];
			$this->view->specialisation_job = $this->view->defaultInfo['allBasket'][0]['Categorie Name'];
			$this->view->reference_job = $this->view->defaultInfo['allBasket'][0]['Ref #'];
			$this->view->other_charges = 0;
			if ($this->view->defaultInfo['allBasket'][0]['optionAttachment'] == 'mailing')
			{
				$this->view->total_cost_plan = $detailsPlan['plana'] + 25;
				$this->view->other_charges = 25;
			}
		}
		
    }

    public function indexAction()
    {
    	return $this->_redirect('patients/requests/new');	
    }

	private function cleanCacheCase()
	{
		$caseObj = new Common_Model_Sogcases();

		if (isset($this->view->defaultInfo['allBasket'][0]['Ref #']))
		{
			$caseObj->deleteBasketCaseByRef2($this->view->defaultInfo['allBasket'][0]['Ref #']);	
		}	
		unset($this->caseSession->tokenNewCase);
	} 


    public function newAction()
    {
    	$step = $this->request->getParam('sp', NULL);

		if (is_null($step))
		{
			return $this->_redirect('patients/requests/new/sp/1');	
		}
		else
		{
			$reinit = $this->request->getParam('reinit', NULL);
			if (!is_null($reinit))
			{
				//clean cache cases
				$this->cleanCacheCase();
				return $this->_redirect('patients/requests/new/sp/1');	
			}

			$start = $this->request->getParam('start', NULL);
			if (!is_null($start) and $start == 'yes' and !is_int($this->view->defaultInfo['allBasket']))
			{
				$this->view->signalProgress = true;
			}

			switch ($step) 
			{
				case 1:
					return $this->_forward('step1', null, null);		
					break;
				case 2:
					return $this->_forward('step2', null, null);		
					break;
				case 3:
					return $this->_forward('step3', null, null);		
					break;
				case 4:
					return $this->_forward('step4', null, null);		
					break;
				case 5:
					return $this->_forward('step5', null, null);		
					break;
				
				
				
				default:
					return $this->_redirect('patients/requests/new/sp/1');	
					break;
			}

		}
    }

    public function step1Action()
    {
		$newCaseFormObj = new Patients_Form_Cases();

		$catgoriesListObj = new Common_Model_Specialities() ;
		$categoriesList = $catgoriesListObj->getAllCategories();
		$newCaseFormObj->categoriesNewCase($categoriesList);
		
		if (!is_int($this->view->defaultInfo['allBasket'])){
			$isNewCase = false;
			$caseToken = $this->view->defaultInfo['allBasket'][0]['Ref #'];
			$this->caseSession->tokenNewCase = $caseToken;
			// there shoulb be only one element in the basked. take [0]
			$this->caseSession->caseObjects['selectedPlan'] = $this->view->defaultInfo['allBasket'][0]['Selected Plan'];
			$this->view->selectedPlanContinue = $this->view->defaultInfo['allBasket'][0]['Selected Plan'];
		}
		else {
			$isNewCase = true;
			unset($this->caseSession->tokenNewCase);
		}
		
		if ($this->request->isPost()) 
		{
			if ($newCaseFormObj->isValid($this->request->getPost())) 
			{
				$this->caseSession->caseObjects['selectedPlan'] = $this->request->getPost('sog_pricing_fld');
				$this->caseSession->caseObjects['categorie'] = $this->request->getPost('sog_categories_fld');
				$this->caseSession->caseObjects['description'] = $this->request->getPost('sog_problemdescription_fld');
				
				if ($isNewCase)
				{

					// set up the initial record in the database
					$caseObj = new Common_Model_Sogcases();
					$returnCaseCreated = $caseObj->createNewCase(1,$this->view->userislogged[0][0],new Zend_Db_Expr('NOW()'),$this->request->getPost('sog_pricing_fld'), 1, $this->request->getPost('sog_categories_fld'));

					if ($returnCaseCreated != false)
					{
						$countryCode = (!is_null($this->view->userislogged[1]['Country Code']))?$this->view->userislogged[1]['Country Code']:'USA';
						$lenghtValue = strlen($returnCaseCreated);
						$caseToken = $countryCode.str_repeat('0', 5 - $lenghtValue).$returnCaseCreated;

						$caseObj->updateRefNumber($returnCaseCreated, $caseToken);
						$caseObj->updateDescriptionForCase($caseToken, $this->request->getPost('sog_problemdescription_fld'));
					
					}

					$this->caseSession->tokenNewCase = $caseToken;
				}
				else 
				{
					// check if the selected plan has changed. if yes, update the DB
					$caseObj = new Common_Model_Sogcases();
					$caseObj->updatePlanAndCategorieForCase($caseToken, $this->caseSession->caseObjects['selectedPlan'], $this->caseSession->caseObjects['categorie']);	
					$caseObj->updateDescriptionForCase($caseToken, $this->request->getPost('sog_problemdescription_fld'));
				}
				return $this->_redirect('/patients/requests/new/sp/2');
			}
		}
		else {
			if (!$isNewCase){
				$newCaseFormObj->populate(array('sog_categories_fld' => $this->view->defaultInfo['allBasket'][0]['Categorie'], 'sog_pricing_fld'=>$this->view->defaultInfo['allBasket'][0]['Selected Plan'], 'sog_problemdescription_fld'=>$this->view->defaultInfo['allBasket'][0]['description']));
			}	
		}
		
		$this->view->categoriesForm = $newCaseFormObj;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newrequest/step1.php');	
	}

	public function step2Action()
    {
    	if (isset($this->caseSession->tokenNewCase))
		{
			$caseToken = $this->caseSession->tokenNewCase;
		}
		elseif (!is_int($this->view->defaultInfo['allBasket']))
		{
			$caseToken = $this->view->defaultInfo['allBasket'][0]['Ref #'];
			$this->caseSession->tokenNewCase = $caseToken;
			$this->caseSession->caseObjects['selectedPlan'] = $this->view->defaultInfo['allBasket'][0]['Selected Plan'];
			$this->caseSession->caseObjects['categorie'] = $this->view->defaultInfo['allBasket'][0]['Categorie'];
		}
		else
		{
			unset($this->caseSession->progressNewCase);
			return $this->_redirect('/patients/requests/new/sp/1');
		}

		$newCaseFormObj = new Patients_Form_Cases();
    	$newCaseFormObj->questionsForCase();
    	$this->view->errors_form = false;
		$this->view->errors_notification = '';



		if ($this->request->isPost()) 
		{
			if ($newCaseFormObj->isValid($this->request->getPost())) 
			{
				$this->caseSession->caseObjects['question 1'] = $this->request->getPost('sog_question1_fld');
				$this->caseSession->caseObjects['question 2'] = $this->request->getPost('sog_question2_fld');
				$this->caseSession->caseObjects['question 3'] = $this->request->getPost('sog_question3_fld');
				
				$caseObj = new Common_Model_Sogcases();
				$caseObj->updateQuestionsForCase($caseToken, $this->request->getPost('sog_question1_fld'), $this->request->getPost('sog_question2_fld'), $this->request->getPost('sog_question3_fld'));	
					
				return $this->_redirect('/patients/requests/new/sp/3');
			}
			else
			{

			}

			//return $this->_redirect('/patients/requests/new/sp/3');
		}
		else {
			$newCaseFormObj->populate(array('sog_question1_fld' => $this->view->defaultInfo['allBasket'][0]['question1'], 'sog_question2_fld'=>$this->view->defaultInfo['allBasket'][0]['question2'], 'sog_question3_fld'=>$this->view->defaultInfo['allBasket'][0]['question3']));
				
		}

		$this->view->newCaseForm = $newCaseFormObj;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newrequest/step2.php');	
    }

    public function step3Action()
    {
    	if (isset($this->caseSession->tokenNewCase))
		{
			$caseToken = $this->caseSession->tokenNewCase;
		}
		elseif (!is_int($this->view->defaultInfo['allBasket']))
		{
			$caseToken = $this->view->defaultInfo['allBasket'][0]['Ref #'];
			$this->caseSession->tokenNewCase = $caseToken;
			$this->caseSession->caseObjects['selectedPlan'] = $this->view->defaultInfo['allBasket'][0]['Selected Plan'];
			$this->caseSession->caseObjects['categorie'] = $this->view->defaultInfo['allBasket'][0]['Categorie'];
		}
		else
		{
			unset($this->caseSession->progressNewCase);
			return $this->_redirect('/patients/requests/new/sp/1');
		}
		
		
		$newCaseFormObj = new Patients_Form_Cases();
    	$newCaseFormObj->attachmentsForCase();
    	$this->view->errors_form = false;
		$this->view->errors_notification = '';

		if ($this->request->isPost()) 
		{
			if ($newCaseFormObj->isValid($this->request->getPost())) 
			{
				//echo $this->request->getPost('sog_optionAttachment_fld');
				//die();
				$this->caseSession->caseObjects['option attachment'] = $this->request->getPost('sog_optionAttachment_fld');
				
				$caseObj = new Common_Model_Sogcases();
				$caseObj->updateAttachmentsForCase($caseToken, $this->request->getPost('sog_optionAttachment_fld'));	
					
				return $this->_redirect('/patients/requests/new/sp/4');
			}
			else
			{
				print_r($newCaseFormObj->getErrors());
				die('here');

			}
		}
		else {
			$newCaseFormObj->populate(array('sog_optionAttachment_fld' => $this->view->defaultInfo['allBasket'][0]['optionAttachment']));
		}

		$sogfilesObj = new Common_Model_Sogfiles();
        $this->view->listUploadedFiles = $sogfilesObj->getAttachmentsForCase($caseToken);
		$this->view->newCaseForm = $newCaseFormObj;

		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newrequest/step3.php');	
    }

	public function step4Action()
    {
    	if (isset($this->caseSession->tokenNewCase))
		{
			$caseToken = $this->caseSession->tokenNewCase;
		}
		elseif (!is_int($this->view->defaultInfo['allBasket']))
		{
			$caseToken = $this->view->defaultInfo['allBasket'][0]['Ref #'];
			$this->caseSession->tokenNewCase = $caseToken;
			$this->caseSession->caseObjects['selectedPlan'] = $this->view->defaultInfo['allBasket'][0]['Selected Plan'];
			$this->caseSession->caseObjects['categorie'] = $this->view->defaultInfo['allBasket'][0]['Categorie'];
		}
		else
		{
			unset($this->caseSession->progressNewCase);
			return $this->_redirect('/patients/requests/new/sp/1');
		}

		$this->view->description = $this->view->defaultInfo['allBasket'][0]['description'];
		$this->view->question1 = $this->view->defaultInfo['allBasket'][0]['question1'];
		$this->view->question2 = $this->view->defaultInfo['allBasket'][0]['question2'];
		$this->view->question3 = $this->view->defaultInfo['allBasket'][0]['question3'];
		$this->view->attachment = $this->view->defaultInfo['allBasket'][0]['optionAttachment'];

		if ($this->request->isPost()) 
		{



			return $this->_redirect('/patients/requests/new/sp/5');
		}

		$sogfilesObj = new Common_Model_Sogfiles();
        $this->view->listUploadedFiles = $sogfilesObj->getAttachmentsForCase($caseToken);

    	//$this->view->categoriesForm = $newCaseFormObj;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newrequest/step4.php');	
    }

	public function step5Action()
    {
    	if (isset($this->caseSession->tokenNewCase))
		{
			$caseToken = $this->caseSession->tokenNewCase;
		}
		elseif (!is_int($this->view->defaultInfo['allBasket']))
		{
			$caseToken = $this->view->defaultInfo['allBasket'][0]['Ref #'];
			$this->caseSession->tokenNewCase = $caseToken;
			$this->caseSession->caseObjects['selectedPlan'] = $this->view->defaultInfo['allBasket'][0]['Selected Plan'];
			$this->caseSession->caseObjects['categorie'] = $this->view->defaultInfo['allBasket'][0]['Categorie'];
		}
		else
		{
			unset($this->caseSession->progressNewCase);
			return $this->_redirect('/patients/requests/new/sp/1');;
		}
		


		$paymentFormObj = new Patients_Form_Payments();
		$this->view->errors_form = false;
		$paymentFormObj->proceedPayment();
		
		
		if ($this->request->isPost()) 
		{
			if ($paymentFormObj->isValid($this->request->getPost())) 
			{

				$cardNumber=str_replace("+","",$this->request->getPost('sog_cardnumber_fld')); 
				$cardName = $this->request->getPost('sog_cardname_fld');
				$expiryMonth = $this->request->getPost('sog_expirationmonth_fld');
				$expiryYear = $this->request->getPost('sog_expirationyear_fld');
				$cvv = $this->request->getPost('sog_cvvnumber_fld');
				
				$expirationDate = $expiryMonth.'/'.$expiryYear;
				$payment = $this->proceedPayment($this->caseSession->caseObjects['selectedPlan'], $cardNumber, $cardName, $expirationDate, $cvv );

				if ($payment === true)
				{
					$caseObj = new Common_Model_Sogcases();
					$caseObj->updateBasketForCase($caseToken);
					$this->caseSession->caseObjects['paymentDone'] = true;

					$rosSession = new Zend_Session_Namespace('case_request_ros');
					$keyConer = sha1($caseToken);
					$rosSession->link[$keyConer] = $caseToken;
					$this->view->keyCase = $keyConer;

					include_once(CCPATH_APPLICATION.'/data/mails/at_case_created.php');
					
					$mail_obj = new Common_Model_Mail();
					$mail_obj->sendmail($this->view->userislogged[1]['Email'], '','cases@secondopinionglobal.com', 'Your new SOG case have been received.',$message_to_opener,'Your new SOG case have been received.');

					return $this->_forward('step6', null, null);	

					//return $this->_redirect('/patients/requests/new/sp/6');
					//return $this->_redirect('patients/portal');
				}
				else 
				{
					$this->view->errors_form = true;
					$this->view->error_message = '';
					$this->view->notification = 'Error with the payment.'.$payment;
				}
			}
			else 
			{
				$this->view->errors_form = true;
				$this->view->error_message = $paymentFormObj->getMessages();
				$this->view->notification = 'Errors in the form. Please fill or correct the fields highlithed in red.';
			}
		}

		$this->view->paymentForm = $paymentFormObj;

    	//$this->view->categoriesForm = $newCaseFormObj;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newrequest/step5.php');	
    }

    public function step6Action()
    {
    	

    	$this->cleanCacheCase();

    	//$this->view->categoriesForm = $newCaseFormObj;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('newrequest/step6.php');	
    }

	private function proceedPayment($planSelected , $cardNumber, $cardName, $expirationDate, $cvv ) 
	{
		require 'Braintree/Braintree.php';
		//print_r($detailsPlan);
		//die();

		$config = Zend_Controller_Front::getInstance()->getParam('bootstrap');
		$btKeys = $config->getOption('bt');
		

		Braintree_Configuration::environment('sandbox');
		Braintree_Configuration::merchantId($btKeys["merchantid"]);
		Braintree_Configuration::publicKey($btKeys["publickey"]);
		Braintree_Configuration::privateKey($btKeys["privatekey"]);
		
		
		$detailsPlan = $this->getPaymentPlan($planSelected);
		$amount = $detailsPlan['plana']; 




		if (isset($this->caseSession->caseObjects['selectedPlan']) and isset($this->view->defaultInfo['allBasket'][0]['Ref #']))
		{
			
			if ($this->view->defaultInfo['allBasket'][0]['optionAttachment'] == 'mailing')
			{
				$amount+=25;
			}
		}
		
		$sale = array(
				'amount' => $amount,
				'creditCard'   => array(
					'number'  => $cardNumber,
					'cardholderName' => $cardName,
					'expirationDate' => $expirationDate,
					'cvv' => $cvv));
		try 
		{		
			$result = Braintree_Transaction::sale($sale);
			//echo '<pre>'; print_r($result);
			if ($result->success)
			{
				return true;
			}
			else
			{
				return $result->_attributes['message'];
			}
		}
		catch(Exception $e) 
		{
			//echo '<pre>'; print_r($e);
			return 'Error in the transaction. Try again later.';
		}
	}
	
	private function getPaymentPlan($selectedPlan)
	{
		$config = Zend_Controller_Front::getInstance()->getParam('bootstrap');
		$btKeys = $config->getOption('bt');

		if ($selectedPlan == 'a'){
			return array('namea' => $btKeys['namea'],'plana' => $btKeys['plana']);
		}
		elseif ($selectedPlan == 'b'){
			return array('namea' => $btKeys['nameb'],'plana' => $btKeys['planb']);
		}
		elseif ($selectedPlan == 'c'){
			return array('namea' => $btKeys['namec'],'plana' => $btKeys['planc']);
		}		
	}

	public function abortAction()
	{
		$caseObj = new Common_Model_Sogcases();

		if (isset($this->view->defaultInfo['allBasket'][0]['Ref #']))
		{
			$caseObj->deleteBasketCaseByRef2($this->view->defaultInfo['allBasket'][0]['Ref #']);	
		}	
		unset($this->caseSession->tokenNewCase);	
		return $this->_redirect('patients/portal');
	}




	public function editAction()
    {
    	


		$this->view->caseReferenceId = $this->request->getParam('caseRef', 'Missing !!');
		if ($this->view->caseReferenceId == 'Missing !!')
		{
			return $this->_redirect('patients/portal');
		}
		
		$sogRequestsObj = new Common_Model_Sogcases();	
		$this->view->caseDetail = $sogRequestsObj->getRequestById($this->view->caseReferenceId);
		if ($this->view->caseDetail == false or $this->view->caseDetail['isToBeEdited'] != 1)
		{
			return $this->_redirect('patients/portal');
		}


		$this->caseSession->tokenNewCase = $this->view->caseReferenceId;

		$newCaseFormObj = new Patients_Form_Cases();
    	$newCaseFormObj->attachmentsForCase();
    	$this->view->errors_form = false;
		$this->view->errors_notification = '';

		if ($this->request->isPost()) 
		{
			$caseObj = new Common_Model_Sogcases();
			$caseObj->lockCaseForCustomer($this->view->caseReferenceId);
			return $this->_redirect('/patients/sogrequests/viewlisting/ckey/'.$this->view->caseReferenceId);	
		}

		$sogfilesObj = new Common_Model_Sogfiles();
        $this->view->listUploadedFiles = $sogfilesObj->getAttachmentsForCase($this->view->caseReferenceId);
		$this->view->newCaseForm = $newCaseFormObj;

		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('editrequest/step3.php');	

    }
}