<?php

class Patients_PortalController extends Zend_Controller_Action
{

    public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$this->view->userislogged = $this->_helper->AccessControlTower->checkAccess();
		$this->view->defaultInfo = $this->_helper->LoadDefaultInfo->getAllInfo($this->view->userislogged[0][0]);

		$this->caseSession = new Zend_Session_Namespace('new_case_request');

		if (isset($this->caseSession->caseObjects['selectedPlan']) and isset($this->view->defaultInfo['allBasket'][0]['Ref #']))
		{
			$detailsPlan = $this->getPaymentPlan($this->caseSession->caseObjects['selectedPlan']);
			$this->view->selected_plan = $detailsPlan['namea'];
			$this->view->cost_plan = $detailsPlan['plana'];
			$this->view->total_cost_plan = $detailsPlan['plana'];
			$this->view->specialisation_job = $this->view->defaultInfo['allBasket'][0]['Categorie Name'];
			$this->view->reference_job = $this->view->defaultInfo['allBasket'][0]['Ref #'];
		}
    }

    public function indexAction()
    {
//echo $this->view->userislogged[0][0];
    	//echo $this->view->userislogged[0][4][4];
    	//die('ici');
    	$sogRequestsObj = new Common_Model_Sogcases();	
		$this->view->listOfCurrentCases = $sogRequestsObj->getCurrentCasesByUser($this->view->userislogged[0][0]);

    	//$sogRequestsObj = new Common_Model_Sogcases();	
		$this->view->listOfClosedCases = $sogRequestsObj->getClosedCasesByUser($this->view->userislogged[0][0]);


		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('portal_view.php');	
    }
	
    public function profileAction()
    {		
		$request = $this->getRequest();
		$prof_sesion = new Zend_Session_Namespace('profile_editing_session');
		if ((null ==  $request->getParam('done')) and isset($prof_sesion->update_completed))
		{
			$done = $request->getParam('done');
			$this->view->orign = $prof_sesion->origin; // = 'password';
			//should be one time operation. So we delete the session space to avoid confusion
			Zend_Session::namespaceUnset('profile_editing_session');
		}
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('profile_view.php');	
	}


    public function settingsAction()
    {		
		$request = $this->getRequest();
		$prof_sesion = new Zend_Session_Namespace('profile_editing_session');
		if ((null ==  $request->getParam('done')) and isset($prof_sesion->update_completed))
		{
			$done = $request->getParam('done');
			$this->view->orign = $prof_sesion->origin; 
			//should be one time operation. So we delete the session space to avoid confusion
			Zend_Session::namespaceUnset('profile_editing_session');
		}
		
		$settings_obj = new Common_Model_Settings();	
		$settinglist = $settings_obj->getGeneralSettingsByCustomer($this->view->userislogged[0][0]);
		
		$this->view->settings = $settinglist;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('settings_view.php');	
	}

	private function getPaymentPlan($selectedPlan)
	{
		$config = Zend_Controller_Front::getInstance()->getParam('bootstrap');
		$btKeys = $config->getOption('bt');

		if ($selectedPlan == 'a'){
			return array('namea' => $btKeys['namea'],'plana' => $btKeys['plana']);
		}
		elseif ($selectedPlan == 'b'){
			return array('namea' => $btKeys['nameb'],'plana' => $btKeys['planb']);
		}
		elseif ($selectedPlan == 'c'){
			return array('namea' => $btKeys['namec'],'plana' => $btKeys['planc']);
		}		
	}

    
	
	
}