<?php

class MyordersController extends Zend_Controller_Action
{

    public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$this->view->userislogged = $this->_helper->AccessControlTower->checkAccess();
		$this->view->defaultInfo = $this->_helper->LoadDefaultInfo->getAllInfo($this->view->userislogged[0][0]);
    }
	
	
	public function indexAction()
	{
		$config = Zend_Controller_Front::getInstance()->getParam('bootstrap');
		$this->view->btKeys = $config->getOption('bt');
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('myorders/home_view.php');	
	}
	
	public function cancelAction()
	{
		$ckey = $this->getRequest()->getParam('ckey', 'none');
		if ($ckey != 'none')
		{
			$caseObj = new Common_Model_Sogcases();
			$caseDetails = $caseObj->searchForBasketCaseByRef($ckey);
			if (!($caseDetails)){
				$this->view->messageOrderCancellation = 'Error(1), We are unable to proceed. Either the data is already deleted, either it is an invalid data. Please try it again later.';
			}
			else {
				if ($caseObj->deleteBasketCaseByRef($caseDetails['id']))
				{
					$this->view->messageOrderCancellation = 'Your order have been successfully cancelled.';
				}
				else {
					$this->view->messageOrderCancellation = 'ErrorError(2), We are unable to proceed. Either the data is already deleted, either it is an invalid data. Please try it again later.';
				}
			}
		}
		else {
			$this->view->messageOrderCancellation = 'Error, We are unable to proceed. Either the data is already deleted, either it is an invalid data. Please try it again later.';
		}

		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('myorders/cancel_view.php');	
	}
}