<?php

class General_Form_ProvidersRegister extends Zend_Form
{
	public $subContent = "";
    public function init()
    {
	
	}
	

	public function signup()
	{
        $this->setMethod('post'); 
		$this->setAttrib('class', 'sky-form');
		$this->setAttrib('id', 'form_signup_provider');
		$this->setAttrib('enctype', 'multipart/form-data'); 
		
		$subContent = new Common_Model_Specialisations();
		$pSpecialities = $subContent->getAllZeroSpecialisations(true);
		$sSpecialities = $subContent->getAllSubSpecialisations(true);
		$design_obj = new Common_Model_Designations();
		$designations = $design_obj->getAllDesignations(true);
		$states_obj = new Common_Model_States();
		$states = $states_obj->getAllStates(true);
		
		$this->addElement('text', 'sog_npinumber_fld', array('label'=> 'NPI Number (*):', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('placeholder' => '')));
		$this->addElement('text', 'sog_lastname_fld', array('label'=> 'Last Name:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('placeholder' => '')));
		$this->addElement('text', 'sog_firstname_fld', array('label'=> 'First Name:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('text', 'sog_emailaddress_fld', array('label'=> 'Email Address:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty', 'EmailAddress'), 'attribs'=>array('placeholder' => '')));
		$this->addElement('text', 'sog_phonenumber1_fld', array('label'=> 'Phone Number 1:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('text', 'sog_phonenumber2_fld', array('label'=> 'Phone Number 2:', 'required' => false, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array(), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('text', 'sog_faxnumber_fld', array('label'=> 'Fax:', 'required' => false, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array(), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('select', 'sog_designation_fld', array('label'=> 'Professional Designation:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array(array('InArray', true, array('haystack' => array_keys($designations['keys']),'messages' => array(Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found")))), 'attribs'=>array('class' => 'form-control', 'placeholder' => ''),'multiOptions' => $designations['keys']));
		$this->addElement('text', 'sog_otherdesignation_fld', array('label'=> 'If other, please specify:', 'required' => false, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array(), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		
		$this->addElement('select', 'sog_boardcertified_fld', array('label'=> 'Board Certified:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array(array( 'InArray', true, array('haystack' => array('0','1'),'messages' => array(Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found")))), 'attribs'=>array('class' => 'form-control', 'placeholder' => ''),'multiOptions' => array('0'=>'No','1'=>'Yes')));
		$this->addElement('text', 'sog_boardname_fld', array('label'=> 'Board name:', 'required' => false, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('text', 'sog_boardyearsdone_fld', array('label'=> 'Years In Practice:', 'required' => false, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));	
		
		$this->addElement('select', 'sog_areaspeciality1_fld', array('label'=> 'Speciality 1:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array(array('InArray', true, array('haystack' => array_keys($pSpecialities['keys']), 'messages' => array(Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found" )) )), 'attribs'=>array('class' => 'form-control', 'placeholder' => '1st Choice'),'multiOptions' => $pSpecialities['keys']));
		$this->addElement('select', 'sog_areaspeciality2_fld', array('label'=> 'Speciality 2:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array(array('InArray', true, array('haystack' => array_keys($pSpecialities['keys']), 'messages' => array(Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found" )) )), 'attribs'=>array('class' => 'form-control', 'placeholder' => '2nd Choice'),'multiOptions' => $pSpecialities['keys']));
		
		$this->addElement('select', 'sog_subspeciality1_fld', array('label'=> 'Subspeciality 1:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array(array('InArray', true, array('haystack' => array_keys($sSpecialities['keys']), 'messages' => array(Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found" )) )), 'attribs'=>array('class' => 'form-control', 'placeholder' => '1st Choice'),'multiOptions' => $sSpecialities['keys']));
		$this->addElement('select', 'sog_subspeciality2_fld', array('label'=> 'Subspeciality 2:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array(array('InArray', true, array('haystack' => array_keys($sSpecialities['keys']), 'messages' => array(Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found" )) )), 'attribs'=>array('class' => 'form-control', 'placeholder' => '2nd Choice'),'multiOptions' => $sSpecialities['keys']));

		$this->addElement('select', 'sog_primarystatelic_fld', array('label'=> 'Primary State License:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array(array('InArray', true, array('haystack' => array_keys($states['keys']), 'messages' => array(Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found" )) )), 'attribs'=>array('class' => 'form-control'),'multiOptions' => $states['keys']));
		
		$this->addElement('select', 'sog_othersstatelic_fld', array('label'=> 'Others State License: (Hold Cmd and Select more than one state)', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array(array('InArray', true, array('haystack' => array_keys($states['keys']), 'messages' => array(Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found" )) )), 'attribs'=>array('class' => 'form-control', 'multiple'=> 'multiple'),'multiOptions' => $states['keys']));

		$this->addElement('text', 'sog_medicalname_fld', array('label'=> 'Medical School (name):', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));		
		$this->addElement('text', 'sog_residency1_fld', array('label'=> 'Residency 1 (Location):', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));		
		$this->addElement('text', 'sog_residency2_fld', array('label'=> 'Residency 2 (Location):', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));		
		$this->addElement('text', 'sog_fellowship_fld', array('label'=> 'Fellowship (Type):', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));		
		$this->addElement('textarea', 'sog_awards_fld', array('label'=> 'Awards and accomplishments:', 'required' => false, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));		


		$this->addElement('textarea', 'sog_comments_fld', array('label'=> 'Comments:', 'required' => false, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));		

		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group'))));
		
		$submit = new Zend_Form_Element_Button('Save');
		$submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');
		$this->addElements(array($submit));
		$this->addElement('hash', 'sog_csrf_fld', array('ignore' => false,));	
		$submit->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-12'))));  
		
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input-error-m">')->setElementEnd('</span>'); 
	}
	
}