<?php
class General_Form_PatientsRegister extends Zend_Form
{
	public $subContent = "";
    public function init()
    {
	
	}
	
	public function signup()
	{	
        $this->setMethod('post'); 
		$this->setAttrib('class', 'sky-form');
		$this->setAttrib('id', 'form_signup_patients');
		
		$countries_obj = new Common_Model_Countries();
		$countries = $countries_obj->getAllCountries(true);
		$cities_obj = new Common_Model_Cities();
		$cities = $cities_obj->getAllCitiesByCountry(true, 'PAK');
		
			
		$this->addElement('text', 'sog_username_fld', array('label'=> 'Username:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('placeholder' => '')));
		$this->addElement('password', 'sog_password_fld', array('label'=> 'Password:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => 'Password')));
		$this->addElement('password', 'sog_cpassword_fld', array('label'=> 'Confirm Password:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => 'Repeat the Password'),'validators' => array(array('identical', false, array('token' => 'sog_password_fld')))));
		$this->addElement('text', 'sog_lastname_fld', array('label'=> 'Last Name:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('placeholder' => '')));
		$this->addElement('text', 'sog_firstname_fld', array('label'=> 'First Name:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('text', 'sog_emailaddress_fld', array('label'=> 'Email Address:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty', 'EmailAddress'), 'attribs'=>array('placeholder' => '')));
		$this->addElement('text', 'sog_phonenumber_fld', array('label'=> 'Phone Number:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));

		$this->addElement('select', 'sog_countryresidence_fld', array('label'=> 'Country Of Residence:', 'required' => true, 'filters' => array('StringTrim'), 'value' => 'PAK', 'validators' => array(array('InArray', true, array('haystack' => array_keys($countries['keys']), 'messages' => array(Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found" )) )), 'attribs'=>array('class' => 'form-control'),'multiOptions' => $countries['keys']));
		
		$this->addElement('select', 'sog_cityresidence_fld', array('label'=> 'City Of Residence:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array(array('InArray', true, array('haystack' => array_keys($cities['keys']), 'messages' => array(Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found" )) )), 'attribs'=>array('class' => 'form-control'),'multiOptions' => $cities['keys']));

		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group'))));
		
		$submit = new Zend_Form_Element_Button('Save');
		$submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');
		$this->addElements(array($submit));
		$this->addElement('hash', 'sog_csrf_fld', array('ignore' => false,));	
		$submit->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-12'))));  
		
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input-error-m">')->setElementEnd('</span>'); 
	}
}