<?php

class Cpadmin_Model_Patients extends Common_Model_Patients
{

	public function getAllPatients($sortby = 'firstname', $order = 'ASC')
	{
		$resultSet = $this->fetchAll($this->select()->from(array('a' => 'accounts'), array('mainId' => 'id','username','password','activationkey','accountactivated','activationdate','dateofbirth','emailaddress','object'))
			->joinLeft(array('p' => 'customers'), 'sha1(a.activationkey) = p.ckeystomer')
			->joinLeft(array('ep' => 'ipps'), 'p.ippid = ep.ippid')
			->joinLeft(array('c' => 'countries'), 'c.id = ep.country', array('Country' => 'name'))
			->where('a.object = ?', 'c')
			//->where('a.accountactivated = ?', 0)
			->order($sortby.' '.$order)
			->setIntegrityCheck(false));

		if (!$resultSet or 0 == count($resultSet)) return false;
		//echo '<pre>'; print_r($resultSet);
		return $resultSet;
	

	} 


	public function getPatientDetail($patientCode)
	{
		$resultSet = $this->fetchRow($this->select()->from(array('a' => 'accounts'), array('mainId' => 'id','username','password','activationkey','accountactivated','activationdate','dateofbirth','emailaddress','object'))
			->joinLeft(array('p' => 'customers'), 'sha1(a.activationkey) = p.ckeystomer')
			->joinLeft(array('ep' => 'ipps'), 'p.ippid = ep.ippid')
			->joinLeft(array('c' => 'countries'), 'c.id = ep.country', array('Country' => 'name'))
			->where('a.object = ?', 'c')
			->where('sha1(a.id) = ?', $patientCode)
			->setIntegrityCheck(false));

		if (!$resultSet or 0 == count($resultSet)) return false;
			//echo '<pre>';print_r($resultSet);
		return $resultSet;


	} 
	
}
