<?php

class Cpadmin_Model_Cases extends Common_Model_Sogcases
{
    protected $_name = 'cases';
	protected $_primary = 'id';
	


	public function getAllUnassignedCases($sortby = 'firstname', $order = 'ASC')
	{
		$resultSet = $this->fetchAll($this->select()
			->from(array('c' => 'cases'))
			->join(array('cmc' => 'customers'), 'cmc.id = c.patientId')
			->join(array('ip' => 'ipps'), 'ip.ippid = cmc.ippid')
			->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
			->where('inBasket = ?', 0)
			->where('caseStatus = ?', 'new')
			->setIntegrityCheck(false));
			
		if (0 == count($resultSet)) return -1;
		else return $resultSet;

	} 


	public function getAllUnresolvedCases($sortby = 'firstname', $order = 'ASC')
	{
		$resultSet = $this->fetchAll($this->select()
			->from(array('c' => 'cases'))
			->join(array('cmc' => 'customers'), 'cmc.id = c.patientId')
			->join(array('ip' => 'ipps'), 'ip.ippid = cmc.ippid')
			->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
			->where('inBasket = ?', 0)
			->where('caseStatusPro = ?', 'unresolved')
			->setIntegrityCheck(false));
			
		if (0 == count($resultSet)) return false;
		else return $resultSet;

	} 

	public function getAllCases($sortby = 'firstname', $order = 'ASC')
	{
		$resultSet = $this->fetchAll($this->select()
			->from(array('c' => 'cases'))
			->join(array('cmc' => 'customers'), 'cmc.id = c.patientId')
			->join(array('ip' => 'ipps'), 'ip.ippid = cmc.ippid')
			->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
			->where('inBasket = ?', 0)
			//->where('caseStatus = ?', 'new')
			->setIntegrityCheck(false));
			
		if (0 == count($resultSet)) return -1;
		else return $resultSet;

	} 

	public function updateStatusProAndProviderForCase($referenceId, $caseStatus, $providerCode){
		$data = array('caseStatusPro' => $caseStatus, 'providerId' => $providerCode);
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}

	public function setStatusPendingForCase($referenceId, $caseStatus){
		$data = array('caseStatusPro' => 'pending','isToBeEdited' => 1);
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}

	public function updateStatusAndProviderForCase($referenceId, $caseStatus, $providerCode){
		$data = array('caseStatus' => $caseStatus, 'providerId' => $providerCode);
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}
	
}
