<?php

class Cpadmin_Model_Providers extends Common_Model_Providers
{
	public function getAllProviders($sortby = 'firstname', $order = 'ASC')
	{
		$resultSet = $this->fetchAll($this->select()->from(array('a' => 'accounts'))
			->joinLeft(array('p' => 'providers'), 'sha1(a.activationkey) = p.ckeyprovider')
			->joinLeft(array('ep' => 'epps'), 'p.eppid = ep.eppid')
			->joinLeft(array('c' => 'countries'), 'c.id = ep.country', array('Country' => 'name'))
			->joinLeft(array('sp' => 'specialities'), 'sp.id = ep.speciality1', array('Categorie Name' => 'name'))

			->where('a.object = ?', 'p')
			->order($sortby.' '.$order)
			->setIntegrityCheck(false));

		if (!$resultSet or 0 == count($resultSet)) return false;
			//print_r($resultSet);
		return $resultSet;

	}	

	public function getAllActiveProviders($sortby = 'firstname', $order = 'ASC')
	{
		$resultSet = $this->fetchAll($this->select()->from(array('a' => 'accounts'))
			->joinLeft(array('p' => 'providers'), 'sha1(a.activationkey) = p.ckeyprovider')
			->joinLeft(array('ep' => 'epps'), 'p.eppid = ep.eppid')
			->joinLeft(array('c' => 'countries'), 'c.id = ep.country', array('Country' => 'name'))
			->joinLeft(array('sp' => 'specialities'), 'sp.id = ep.speciality1', array('Categorie Name' => 'name'))

			->where('a.object = ?', 'p')
			->where('a.accountactivated = ?', 1)
			->order($sortby.' '.$order)
			->setIntegrityCheck(false));

		if (!$resultSet or 0 == count($resultSet)) return false;
			//print_r($resultSet);
		return $resultSet;

	}	


	public function getAllProvidersBySpec($specialisation, $as_array = false)
	{
		$resultSet = $this->fetchAll($this->select()->from(array('a' => 'accounts'))
			->joinLeft(array('p' => 'providers'), 'sha1(a.activationkey) = p.ckeyprovider')
			->joinLeft(array('ep' => 'epps'), 'p.eppid = ep.eppid')
			->joinLeft(array('c' => 'countries'), 'c.id = ep.country', array('Country' => 'name'))
			->joinLeft(array('sp' => 'specialities'), 'sp.id = ep.speciality1', array('Categorie Name' => 'name'))
			->where('a.object = ?', 'p')
			->where('ep.speciality1 = ?', $specialisation)
			->orWhere('ep.speciality2 = ?', $specialisation)
			->setIntegrityCheck(false));

		if (!$resultSet or 0 == count($resultSet)) return false;
		if ($as_array)
		{
			foreach ($resultSet as $k => $v)
			{
				$rs['keys'][$v['providercode']] = ucfirst($v['firstname']).', '.ucfirst($v['lastname']).' ('. $v['designation'].')';
				$rs['full'][] = array('id' => $v['providercode'], 'name' => ucfirst($v['firstname']).', '.ucfirst($v['lastname']).' ('. $v['designation'].')', 'description' => $v['comments']);
			}
			return $rs; 
		}
		else
		{

			//print_r($resultSet);
			return $resultSet;
		}
	} 

	
	public function getAllJoinsProviders($sortby = 'firstname', $order = 'ASC')
	{

		$resultSet = $this->fetchAll($this->select()->from(array('a' => 'accounts'))
			->joinLeft(array('p' => 'providers'), 'sha1(a.activationkey) = p.ckeyprovider')
			->joinLeft(array('ep' => 'epps'), 'p.eppid = ep.eppid')
			->joinLeft(array('c' => 'countries'), 'c.id = ep.country', array('Country' => 'name'))
			->where('a.object = ?', 'p')
			->where('a.accountactivated = ?', 0)
			->order($sortby.' '.$order)
			->setIntegrityCheck(false));

		if (!$resultSet or 0 == count($resultSet)) return false;
			//print_r($resultSet);
		return $resultSet;
		
	}	

	public function getProviderDetail($providerCode)
	{
		$resultSet = $this->fetchRow($this->select()->from(array('a' => 'accounts'), array('mainId' => 'id','username','password','activationkey','accountactivated','activationdate','dateofbirth','emailaddress','object'))
			->joinLeft(array('p' => 'providers'), 'sha1(a.activationkey) = p.ckeyprovider')
			->joinLeft(array('ep' => 'epps'), 'p.eppid = ep.eppid')
			->joinLeft(array('c' => 'countries'), 'c.id = ep.country', array('Country' => 'name'))
			->where('a.object = ?', 'p')
			->where('p.providercode = ?', $providerCode)
			->setIntegrityCheck(false));

		if (!$resultSet or 0 == count($resultSet)) return false;
			//echo '<pre>';print_r($resultSet);
		return $resultSet;


	} 


	public function approveComponent($cobject)
	{

		return array('result' => true, 'message' => 'message');
	}
	
}
