<?php

class Cpadmin_Form_Patients extends Zend_Form
{
	//public $subContent = "";
    public function init()
    {
	
	}


	public function editprofile()
	{
        $this->setMethod('post'); 
		$this->setAttrib('class', 'sky-form');

		$subContent = new Common_Model_Countries();
		$result = $subContent->getAllCountries(true);
		
		$this->addElement('text', 'IMT_prof_firstname', array('label'=> 'First Name:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control form-control-lg', 'placeholder' => '')));
		$this->addElement('text', 'IMT_prof_middlename', array('label'=> 'Middle Name:', 'required' => false, 'filters' => array('StringTrim', 'StringToLower'), 'attribs'=>array('class' => 'form-control form-control-lg',  'placeholder' => '')));
		$this->addElement('text', 'IMT_prof_lastname', array('label'=> 'Last Name:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control form-control-lg',  'placeholder' => '')));
		$this->addElement('select', 'IMT_prof_gender', array('label'=> 'Gender:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control form-control-lg', 'placeholder' => ''),'multiOptions' => array('' => 'Click to select', 'male' => 'Male', 'female' => 'Female')));
		$this->addElement('select', 'IMT_prof_maritalstatus', array('label'=> 'Marital Status:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control form-control-lg',  'placeholder' => ''),'multiOptions' => array('' => 'Click to select', 'single' => 'Single', 'married' => 'Married','divorced' => 'Divorced','widowed' => 'Widowed','separated' => 'Separated')));
		$this->addElement('text', 'IMT_prof_dob', array('label'=> 'Birth date:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control form-control-lg',  'placeholder' => '')));
		$this->addElement('text', 'IMT_prof_profession', array('label'=> 'Occupation:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control form-control-lg','placeholder' => '')));

		$this->addDisplayGroup(array('IMT_prof_firstname', 'IMT_prof_middlename', 'IMT_prof_lastname','IMT_prof_gender', 'IMT_prof_maritalstatus', 'IMT_prof_dob', 'IMT_prof_profession'), 'topf');


		$this->addElement('text', 'IMT_prof_email', array('label'=> 'Email:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control form-control-lg', 'placeholder' => '')));
		$this->addElement('text', 'IMT_prof_address', array('label'=> 'Address:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control form-control-lg', 'placeholder' => '')));
		$this->addElement('text', 'IMT_prof_apartnum', array('label'=> 'Apartment number:', 'required' => false, 'filters' => array('StringTrim', 'StringToLower'), 'attribs'=>array('class' => 'form-control form-control-lg', 'placeholder' => '')));
		$this->addElement('text', 'IMT_prof_streetnum', array('label'=> 'Street Name:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control','placeholder' => '')));
		$this->addElement('text', 'IMT_prof_zip', array('label'=> 'Zip Code:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control form-control-lg', 'placeholder' => '')));
		$this->addElement('select', 'IMT_prof_country', array('label'=> 'Country:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array(array(
                    'InArray', true, array(
                        'haystack' => array_keys($result['keys']),
                        'messages' => array(
                            Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found"
                        )
                    )
                )), 'attribs'=>array('class' => 'form-control form-control-lg', 'placeholder' => ''),'multiOptions' => $result['keys']));
		
		$this->addElement('text', 'IMT_prof_city', array('label'=> 'City:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('placeholder' => '')));
		$this->addElement('text', 'IMT_prof_state', array('label'=> 'State:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control form-control-lg', 'placeholder' => '')));
		$this->addElement('text', 'IMT_prof_cellphone', array('label'=> 'Cell Phone:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control form-control-lg', 'placeholder' => '')));
		$this->addElement('text', 'IMT_prof_homephone', array('label'=> 'Home Phone:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control','placeholder' => '')));
		$this->addElement('text', 'IMT_prof_workphone', array('label'=> 'Work Phone:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control form-control-lg', 'placeholder' => '')));
		
		$this->addDisplayGroup(array('IMT_prof_email', 'IMT_prof_address', 'IMT_prof_apartnum','IMT_prof_streetnum', 'IMT_prof_zip', 'IMT_prof_country','IMT_prof_city', 'IMT_prof_state', 'IMT_prof_cellphone','IMT_prof_homephone', 'IMT_prof_workphone'), 'tops');


		$submit = new Zend_Form_Element_Button('Save');
		$submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');
		$cancel = new Zend_Form_Element_Button('Cancel');
		$cancel->setAttrib('id','cancel')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-danger pull-left');		
		$this->addElements(array($cancel, $submit));
        $this->addElement('hash', 'csrf', array('ignore' => false,));	
		$this->addDisplayGroup(array($cancel, $submit, 'csrf'), 'topb');
		
		//Setting decorators//
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('divWrapper' => 'HtmlTag'), array('tag' => 'i', 'placement' => 'prepend', 'class' => 'icon-append')), array('Errors'),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('IMT_prof_firstname', 'IMT_prof_middlename', 'IMT_prof_lastname','IMT_prof_gender', 'IMT_prof_maritalstatus', 'IMT_prof_dob', 'IMT_prof_profession','IMT_prof_email', 'IMT_prof_address', 'IMT_prof_apartnum','IMT_prof_streetnum', 'IMT_prof_zip', 'IMT_prof_country','IMT_prof_city', 'IMT_prof_state', 'IMT_prof_cellphone','IMT_prof_homephone', 'IMT_prof_workphone'));
		
		$submit->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6')))); 
		$cancel->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6'))));
		//$this->getElement('csrf')->removeDecorator('errors')  ;   
        $this->getDisplayGroup('topf')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset')))); 
        $this->getDisplayGroup('tops')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset'))));  
		$this->getDisplayGroup('topb')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset'))));  
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input-error-m">')->setElementEnd('</span>');

	}
}