<?php

class Cpadmin_ProvidersController extends Zend_Controller_Action
{
    public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$this->view->userislogged = $this->_helper->AccessControlTower->checkAccess();
		$this->view->defaultInfo = $this->_helper->LoadDefaultInfo->getNavigs($this->view->userislogged[1]['groupusers']);

		$this->providersObj = new Cpadmin_Model_Providers();
		$this->request = $this->getRequest();
        $this->view->activeId = 3;
    }

    public function indexAction()
    {
        //echo sha1("NMCaapi123");
		
        $this->view->sortby = $this->request->getParam('sortby', 'firstname');
        if ($this->view->sortby == 'name')
        {
            $this->view->sortby = 'firstname';
        }
        elseif ($this->view->sortby == 'createdon')
        {
            $this->view->sortby = 'activationdate';
        }
        else
        {
            $this->view->sortby = 'firstname';
        }

        $this->view->listProviders = $this->providersObj->getAllProviders($this->view->sortby);


		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('providers/index_view.php');	
    }


    public function latestAction()
    {
    	$this->view->sortby = $this->request->getParam('sortby', 'firstname');
    	if ($this->view->sortby == 'name')
    	{
    		$this->view->sortby = 'firstname';
    	}
    	elseif ($this->view->sortby == 'createdon')
    	{
    		$this->view->sortby = 'activationdate';
    	}
    	else
    	{
    		$this->view->sortby = 'firstname';
    	}




    	$this->view->listProviders = $this->providersObj->getAllJoinsProviders($this->view->sortby);

		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('providers/latest_view.php');	
    }


    public function getfileAction()
    {
        $this->view->providerKey = $this->request->getParam('ckey', 'none');
        if ($this->view->providerKey != 'none')
        {
            $this->view->providerDetail = $this->providersObj->getProviderDetail($this->view->providerKey);
        }


        if ($this->view->providerKey == 'none' or $this->view->providerDetail == false)
        {
            echo  false;
           // $this->view->exitMade = 'provider_not_found';

        }
        else
        {
            $this->view->fileName = $this->request->getParam('_fA', 'none');
            if ($this->view->providerKey != 'none')
            {
                $up_fileinfo = pathinfo(CCPATH_APPLICATION."/data/providers/".$this->view->providerKey.'/'.$this->view->fileName);



                $sendFile = $this->_helper->getHelper('SendFile');
                $sendFile->sendFile(CCPATH_APPLICATION."/data/providers/".$this->view->providerKey.'/'.$this->view->fileName, $up_fileinfo['extension']);
            }
        }

    }

    public function viewnAction()
    {
        $this->view->providerKey = $this->request->getParam('ckey', 'none');
        if ($this->view->providerKey != 'none')
        {
            $this->view->providerDetail = $this->providersObj->getProviderDetail($this->view->providerKey);
        }


        if ($this->view->providerKey == 'none' or $this->view->providerDetail == false)
        {
            $this->view->exitMade = 'provider_not_found';

        }
        else
        {

        }//Zend_Controller_Action_Helper_SendFile




        $documentFilesObj = new Cpadmin_Form_Providers();
        $documentFilesObj->documentsProviderProfile();

        if ($this->request->isPost()) 
        {
            if (sizeof($documentFilesObj->documentFilenameFld->getFileName()) != 0) 
            {
                $locationFile = $documentFilesObj->documentFilenameFld->getFileName(); 
                $up_fileinfo = pathinfo($locationFile);
                $location = $documentFilesObj->documentFilenameFld->getValue();

                if(!file_exists($up_fileinfo['dirname'].'/'.$this->view->providerKey))
                {
                    mkdir($up_fileinfo['dirname'].'/'.$this->view->providerKey);
                }

                $filename = strtolower("_".$this->view->providerKey."_".$this->request->getPost('documentCategorieFld').'.'.$up_fileinfo['extension']);
                $new_destination = $up_fileinfo['dirname'].'/'.$this->view->providerKey.'/'.$filename;
                $filterRename = new Zend_Filter_File_Rename(array('target' => $new_destination, 'overwrite' => true)); 
                $filterRename->filter($locationFile); 
                $documentFilesObj->documentFilenameFld->receive();

                $ipps_obj = new Common_Model_Eppps();
                $ipps_obj->updateProviderDocument($this->view->providerDetail['id'],$this->request->getPost('documentCategorieFld'),$filename);

                // we refresh the page here
                return $this->_redirect('/cpadmin/providers/viewn/ckey/'.$this->view->providerKey);

            }
        }
        
        $this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
        echo $this->view->render('providers/viewn_view.php');   
    }


    public function approveAction()
    {
        
        $this->view->providerKey = $this->request->getParam('ckey', 'none');
        if ($this->view->providerKey != 'none')
        {
            $this->view->providerDetail = $this->providersObj->getProviderDetail($this->view->providerKey);
        }


        if ($this->view->providerKey == 'none' or $this->view->providerDetail == false)
        {
            $this->view->exitMade = 'provider_not_found';

        }
        else
        {
            $loadProviderSession = new Zend_Session_Namespace('provider_approval_process');
            $loadProviderSession->providerId = $this->view->providerKey;
            $loadProviderSession->providerUkey = sha1(time());
            $this->view->providerUkey = $loadProviderSession->providerUkey;
        }
        
        $this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
        echo $this->view->render('providers/approve_view.php');   
    }


    public function editprofileAction()
    {
        $this->view->providerKey = $this->request->getParam('ckey', 'none');
        if ($this->view->providerKey != 'none')
        {
            $this->view->providerDetail = $this->providersObj->getProviderDetail($this->view->providerKey);
        }


        if ($this->view->providerKey == 'none' or $this->view->providerDetail == false)
        {
            $this->view->exitMade = 'provider_not_found';
        }
        else
        {

        }

        $edprofilObj = new Cpadmin_Form_Providers();
        $edprofilObj->editprofile();

        if ($this->request->isPost()) 
        {
            if ($edprofilObj->isValid($this->request->getPost())) 
            {
                try
                {
                    $ipps_obj = new Common_Model_Eppps();
                    $ipps_obj->updateProviderMainData($this->view->providerDetail['id'],$this->request->getPost('IMT_prof_npinumber'),$this->request->getPost('IMT_prof_ssnumber'));

                    $ipps_obj->updateEppForProvider($this->view->providerDetail['eppid'],$this->request->getPost('IMT_prof_fullname'),$this->request->getPost('IMT_prof_gender'),$this->request->getPost('IMT_prof_maritalstatus'),$this->request->getPost('IMT_prof_dob'),$this->request->getPost('IMT_prof_email'),$this->request->getPost('IMT_prof_address'),$this->request->getPost('IMT_prof_apartnum'),$this->request->getPost('IMT_prof_streetnum'),$this->request->getPost('IMT_prof_zip'),$this->request->getPost('IMT_prof_country'),$this->request->getPost('IMT_prof_city'),$this->request->getPost('IMT_prof_state'),$this->request->getPost('IMT_prof_cellphone'),$this->request->getPost('IMT_prof_homephone'),$this->request->getPost('IMT_prof_workphone'));

                    return $this->_redirect('/cpadmin/providers/viewn/ckey/'.$this->view->providerKey);
                }
                catch (Exception $e)
                {
                    $this->view->notification = "Sorry, we cannot save the changes at the moment."; 

                }

            }
            else
            {

                //print_r($edprofilObj->getErrors());
                $this->view->notification = "Sorry, we cannot save the changes due to the error highligthed in Red below."; 
            }
        }
        else
        {
            $ddata_preset = array(
                'IMT_prof_fullname' => $this->view->providerDetail['firstname'],
                'IMT_prof_gender' => $this->view->providerDetail['sex'],
                'IMT_prof_maritalstatus' => $this->view->providerDetail['maritalstatus'],
                'IMT_prof_dob' => $this->view->providerDetail['birthdate'],
                'IMT_prof_email' => $this->view->providerDetail['email'],
                'IMT_prof_address' => $this->view->providerDetail['address'],
                'IMT_prof_apartnum' => $this->view->providerDetail['house_aptno'],
                'IMT_prof_streetnum' => $this->view->providerDetail['streetname'],
                'IMT_prof_zip' => $this->view->providerDetail['zip'],
                'IMT_prof_country' => $this->view->providerDetail['country'],
                'IMT_prof_city' => $this->view->providerDetail['city'],
                'IMT_prof_state' => $this->view->providerDetail['state'],
                'IMT_prof_cellphone' => $this->view->providerDetail['phonenumber1'],
                'IMT_prof_homephone' => $this->view->providerDetail['homephone'],
                'IMT_prof_workphone' => $this->view->providerDetail['workphone'],
                'IMT_prof_ssnumber' => $this->view->providerDetail['socialSecurity'],
                'IMT_prof_npinumber' => $this->view->providerDetail['npiNumber']);
            $edprofilObj->populate($ddata_preset);
        }
        
        $this->view->edit_profile_form = $edprofilObj;

        $this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
        echo $this->view->render('providers/edit_view.php');   
    }




    public function caqhAction()
    {
        $this->view->providerKey = $this->request->getParam('ckey', 'none');
        if ($this->view->providerKey != 'none')
        {
            $this->view->providerDetail = $this->providersObj->getProviderDetail($this->view->providerKey);
        }


        if ($this->view->providerKey == 'none' or $this->view->providerDetail == false)
        {
            $this->view->exitMade = 'provider_not_found';

        }
        else
        {

        }

        $edprofilObj = new Cpadmin_Form_Providers();
        $edprofilObj->editcaqh();
        

        if ($this->request->isPost()) 
        {
            if ($edprofilObj->isValid($this->request->getPost())) 
            {
                try
                {
                    $ipps_obj = new Common_Model_Eppps();
                    $ipps_obj->updateProviderCAQHData($this->view->providerDetail['id'],$this->request->getPost('prov_caqhusername'),$this->request->getPost('prov_caqhidnumber'),$this->request->getPost('prov_caqhpassword'));

                    return $this->_redirect('/cpadmin/providers/viewn/ckey/'.$this->view->providerKey);
                }
                catch (Exception $e)
                {
                    $this->view->notification = "Sorry, we cannot save the changes at the moment."; 

                }
            }
            else
            {

                $this->view->notification = "Sorry, we cannot save the changes due to the error highligthed in Red below."; 
            }
        }
        else
        {

            $ddata_preset = array(
                'prov_caqhusername' => $this->view->providerDetail['caqhUsername'],
                'prov_caqhidnumber' => $this->view->providerDetail['caqhIdNumber'],
                'prov_caqhpassword' => $this->view->providerDetail['caqhPassword']);
            $edprofilObj->populate($ddata_preset);
        }
        
        $this->view->edit_profile_form = $edprofilObj;
        $this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
        echo $this->view->render('providers/caqhedit_view.php');   
    }



    public function attachmentAction()
    {
        $this->view->providerKey = $this->request->getParam('ckey', 'none');
        if ($this->view->providerKey != 'none')
        {
            $this->view->providerDetail = $this->providersObj->getProviderDetail($this->view->providerKey);
        }


        if ($this->view->providerKey == 'none' or $this->view->providerDetail == false)
        {
            $this->view->exitMade = 'provider_not_found';

        }
        else
        {

        }

        $edprofilObj = new Cpadmin_Form_Providers();
        $edprofilObj->editcaqh();
        

        if ($this->request->isPost()) 
        {
            if ($edprofilObj->isValid($this->request->getPost())) 
            {
                try
                {
                    $ipps_obj = new Common_Model_Eppps();
                    $ipps_obj->updateProviderCAQHData($this->view->providerDetail['id'],$this->request->getPost('prov_caqhusername'),$this->request->getPost('prov_caqhidnumber'),$this->request->getPost('prov_caqhpassword'));

                    return $this->_redirect('/cpadmin/providers/viewn/ckey/'.$this->view->providerKey);
                }
                catch (Exception $e)
                {
                    $this->view->notification = "Sorry, we cannot save the changes at the moment."; 

                }
            }
            else
            {

                $this->view->notification = "Sorry, we cannot save the changes due to the error highligthed in Red below."; 
            }
        }
        else
        {

            $ddata_preset = array(
                'prov_caqhusername' => $this->view->providerDetail['caqhUsername'],
                'prov_caqhidnumber' => $this->view->providerDetail['caqhIdNumber'],
                'prov_caqhpassword' => $this->view->providerDetail['caqhPassword']);
            $edprofilObj->populate($ddata_preset);
        }
        
        $this->view->edit_profile_form = $edprofilObj;
        $this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
        echo $this->view->render('providers/attachments_view.php');   
    }












    public function searchAction()
    {
        $specialitiesObj = new Common_Model_Specialities();
        $this->view->listOfSpecialities = $specialitiesObj->getAllCategories(true);

        $this->view->specialisation = $this->request->getParam('sog_specialization_fld', 'none');
       // echo $this->view->specialisation;
        if ($this->view->specialisation != 'none')
        {
            $this->view->listProviders = $this->providersObj->getAllProvidersBySpec($this->view->specialisation);
        }
        else
        {

        }
        //


        $this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
        echo $this->view->render('providers/search_view.php');   
    }
    

    public function newAction()
    {
        $providerRegistrationFrm = new Auth_Form_ProvidersRegister();
        $account_obj = new Common_Model_Accounts();
        $this->view->errors_form = false;
        $providerRegistrationFrm->signup();
        
        if ($this->request->isPost()) 
        {
            if ($providerRegistrationFrm->isValid($this->request->getPost())) 
            {
                $mbr_obj = new Common_Model_Providers();
                if ($mbr_obj->checkNPIProvider($this->request->getPost('sog_npinumber_fld')) === false) 
                {
                    $this->view->errors_form = true;
                    $this->view->notification = 'Sorry, the NPI number entered is not valid.';
                }
                elseif ($account_obj->findAccountEmail($this->request->getPost('sog_emailaddress_fld')) != false)
                {
                    $this->view->errors_form = true;
                    $this->view->notification = 'Sorry, this email address is already associated to another account.';
                }
                elseif ($this->request->getPost('sog_boardcertified_fld') == 1 and ($this->request->getPost('sog_boardname_fld') == "" or $this->request->getPost('sog_boardyearsdone_fld') == "" or $this->request->getPost('sog_boardname_fld') == null or $this->request->getPost('sog_boardyearsdone_fld') == null))
                {
                    if ($this->request->getPost('sog_boardname_fld') == "" or $this->request->getPost('sog_boardname_fld') == null )
                    {
                        $reg_form->sog_boardname_fld->markAsError();
                        $reg_form->sog_boardname_fld->addError('Missing');
                    }
                    
                    $this->view->errors_form = true;
                    $this->view->notification = 'Please provide the Board name and the years completed';
                }
               else {
                    $session_key = sha1($this->request->getPost('sog_firstname_fld')).sha1($this->request->getPost('sog_lastname_fld')).sha1(time());
                    
                    /******************/
                    $prd_obj = new Common_Model_Eppps();
                    $idr = $prd_obj->createEppforProvider($this->request->getPost('sog_lastname_fld'),'',$this->request->getPost('sog_firstname_fld'),NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,$this->request->getPost('sog_residency1_fld'),$this->request->getPost('sog_emailaddress_fld'),$this->request->getPost('sog_phonenumber1_fld'),'','',$this->request->getPost('sog_designation_fld'),$this->request->getPost('sog_otherdesignation_fld'),'',$this->request->getPost('sog_boardcertified_fld'),$this->request->getPost('sog_boardname_fld'),$this->request->getPost('sog_boardyearsdone_fld'),$this->request->getPost('sog_areaspeciality1_fld'),$this->request->getPost('sog_areaspeciality2_fld'),0,0,$this->request->getPost('sog_phonenumber2_fld'),$this->request->getPost('sog_primarystatelic_fld'),$this->request->getPost('sog_otherstateslic_fld'),$this->request->getPost('sog_medicalname_fld'),$this->request->getPost('sog_fellowship_fld'),$this->request->getPost('sog_awards_fld'),$this->request->getPost('sog_comments_fld'));
                    /*********************/
                    
                    /*********************/
                    
                    //die($session_key);
                    $mbr_obj->createProvider($idr, $session_key, $this->request->getPost('sog_npinumber_fld'));
                    
                    $dateOfBirthCode = sha1(substr($this->request->getPost('sog_npinumber_fld'),0,6).$this->request->getPost('sog_emailaddress_fld'));
                    $dateOfBirthCodeFinal = substr($dateOfBirthCode, 0, 6);
                    $account_obj->createAccount($this->request->getPost('sog_emailaddress_fld'), '123',$session_key, 'p', $dateOfBirthCodeFinal, $this->request->getPost('sog_emailaddress_fld') );
                    /*********************/
                    
                    
                    //return $this->_redirect('/auth/access/proregistered');
                }
            }
            else {
                $this->view->errors_form = true;
                //print_r( $providerRegistrationFrm->getMessages());
                $this->view->error_message = $providerRegistrationFrm->getMessages();
                $this->view->notification = 'Errors in the form. Please fill or correct the fields highlithed in red.';
            }
        }
        
        $this->view->signupform = $providerRegistrationFrm;
        $this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');        
        echo $this->view->render('providers/new_view.php');  
    }
    
	
}