<?php

class Cpadmin_RevenueController extends Zend_Controller_Action
{
    public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$this->view->userislogged = $this->_helper->AccessControlTower->checkAccess();
		$this->view->defaultInfo = $this->_helper->LoadDefaultInfo->getNavigs($this->view->userislogged[1]['groupusers']);
		$this->view->activeId = 6;
		$this->casesObj = new Cpadmin_Model_Cases();
		$this->request = $this->getRequest();
		$this->prObj = new Common_Model_Paymentruns();
    }

    public function indexAction()
    {
		
    }
	
	public function detailAction()
	{
		$this->view->pref = $this->request->getParam('sog_pref_fld', NULL);
    	if (!is_null($this->view->pref))
    	{
			$this->view->prData = $this->prObj->getPRDetails($this->view->pref);
			//echo '<pre>'; print_r($this->view->prData);
    	}
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('revenues/detail_view.php');
	}
	
	public function patientAction()
	{
		$this->view->sog_daterange_fld = $this->request->getParam('sog_daterange_fld', NULL);
		$this->view->w_total_payment = 0;
		 
    	if (!is_null($this->view->sog_daterange_fld))
    	{
			//echo 'ww';
			$dateIntervals = split(' - ', $this->view->sog_daterange_fld);
			
			$this->view->startFrom = date('Y-m-d', strtotime($dateIntervals[0])).' 00:00:00';
			$this->view->endTo =  date('Y-m-d', strtotime($dateIntervals[1])).' 23:59:59';
			
			$this->view->list_data = $this->casesObj->getCasesInPeriod($this->view->startFrom, $this->view->endTo);
			
    	}
	
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('revenues/patient_view.php');
	}
	
	public function providerAction()
	{
		$this->view->sog_daterange_fld = $this->request->getParam('sog_daterange_fld', NULL);
		$this->view->w_total_payment = 0;
		 
    	if (!is_null($this->view->sog_daterange_fld))
    	{
			$dateIntervals = split(' - ', $this->view->sog_daterange_fld);
			
			$this->view->startFrom = date('Y-m-d', strtotime($dateIntervals[0])).' 00:00:00';
			$this->view->endTo =  date('Y-m-d', strtotime($dateIntervals[1])).' 23:59:59';
			
			$this->view->list_data = $this->prObj->getPaymentsInPeriod($this->view->startFrom, $this->view->endTo);
			//echo '<pre>';print_r($this->view->list_data);
    	}
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('revenues/provider_view.php');
	}
	
	public function consultationAction()
	{
		$this->view->sog_daterange_fld = $this->request->getParam('sog_daterange_fld', NULL);
		$this->view->w_total_payment = 0;
		 
    	if (!is_null($this->view->sog_daterange_fld))
    	{
			$dateIntervals = split(' - ', $this->view->sog_daterange_fld);
			
			$this->view->startFrom = date('Y-m-d', strtotime($dateIntervals[0])).' 00:00:00';
			$this->view->endTo =  date('Y-m-d', strtotime($dateIntervals[1])).' 23:59:59';
			
			$this->view->list_data = $this->prObj->getPaymentsInPeriod($this->view->startFrom, $this->view->endTo);
			//echo '<pre>';print_r($this->view->list_data);
    	}
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('revenues/consultation_view.php');
	}
	
	public function revenueAction()
	{
		$this->view->sog_daterange_fld = $this->request->getParam('sog_daterange_fld', NULL);
		$this->view->sog_specialization_fld = $this->request->getParam('sog_specialization_fld', "none");
		$this->view->w_total_payment = 0;
		
		$providersObj = new Cpadmin_Model_Providers();
		$this->view->listProviders = $providersObj->getAllActiveProviders();
		 
    	if (!is_null($this->view->sog_daterange_fld) and $this->view->sog_specialization_fld  != 'none')
    	{
			$dateIntervals = split(' - ', $this->view->sog_daterange_fld);
			$this->view->startFrom = date('Y-m-d', strtotime($dateIntervals[0])).' 00:00:00';
			$this->view->endTo =  date('Y-m-d', strtotime($dateIntervals[1])).' 23:59:59';
			
			$this->view->list_data = $this->prObj->getPaymentsInPeriodPerPeriod($this->view->sog_specialization_fld, $this->view->startFrom, $this->view->endTo);
			//echo '<pre>';print_r($this->view->list_data);
    	}
		
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('revenues/revenue_view.php');
	}
}