<?php

class Cpadmin_PatientsController extends Zend_Controller_Action
{
    public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$this->view->userislogged = $this->_helper->AccessControlTower->checkAccess();
		$this->view->defaultInfo = $this->_helper->LoadDefaultInfo->getNavigs($this->view->userislogged[1]['groupusers']);

		$this->patientsObj = new Cpadmin_Model_Patients();
		$this->request = $this->getRequest();
        $this->view->activeId = 4;
    }


    public function indexAction()
    {

        $this->view->sortby = $this->request->getParam('sortby', 'firstname');
        $this->view->orderby = $this->request->getParam('orderby', 'asc');

        if ($this->view->sortby == 'name')
        {
            $this->view->sortby = 'firstname';
            $this->view->orderby_1 = $this->view->orderby;
        }
        elseif ($this->view->sortby == 'createdon')
        {
            $this->view->sortby = 'activationdate';
            $this->view->orderby_2 = $this->view->orderby;
        }
        else
        {
            $this->view->sortby = 'firstname';
        }

        $this->view->listPatients = $this->patientsObj->getAllPatients($this->view->sortby, $this->view->orderby);	
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('patients/index_view.php');	
    }



    public function viewnAction()
    {
        $this->view->patientKey = $this->request->getParam('ckey', 'none');
        if ($this->view->patientKey != 'none')
        {
            $this->view->patientDetail = $this->patientsObj->getPatientDetail($this->view->patientKey);
        }


        if ($this->view->patientKey == 'none' or $this->view->patientDetail == false)
        {
            $this->view->exitMade = 'patient_not_found';

        }
        else
        {

        }//Zend_Controller_Action_Helper_SendFile




        $documentFilesObj = new Cpadmin_Form_Providers();
        $documentFilesObj->documentsProviderProfile();

        if ($this->request->isPost()) 
        {
            if (sizeof($documentFilesObj->documentFilenameFld->getFileName()) != 0) 
            {
                $locationFile = $documentFilesObj->documentFilenameFld->getFileName(); 
                $up_fileinfo = pathinfo($locationFile);
                $location = $documentFilesObj->documentFilenameFld->getValue();

                if(!file_exists($up_fileinfo['dirname'].'/'.$this->view->patientKey))
                {
                    mkdir($up_fileinfo['dirname'].'/'.$this->view->patientKey);
                }

                $filename = strtolower("_".$this->view->patientKey."_".$this->request->getPost('documentCategorieFld').'.'.$up_fileinfo['extension']);
                $new_destination = $up_fileinfo['dirname'].'/'.$this->view->patientKey.'/'.$filename;
                $filterRename = new Zend_Filter_File_Rename(array('target' => $new_destination, 'overwrite' => true)); 
                $filterRename->filter($locationFile); 
                $documentFilesObj->documentFilenameFld->receive();

                $ipps_obj = new Common_Model_Eppps();
                $ipps_obj->updateProviderDocument($this->view->providerDetail['id'],$this->request->getPost('documentCategorieFld'),$filename);

                // we refresh the page here
                return $this->_redirect('/cpadmin/patients/viewn/ckey/'.$this->view->patientKey);

            }
        }
        
        $this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
        echo $this->view->render('patients/viewn_view.php');   
    }


    public function viewcasesAction()
    {
        $this->view->patientKey = $this->request->getParam('ckey', 'none');
        if ($this->view->patientKey != 'none')
        {
            $this->view->patientDetail = $this->patientsObj->getPatientDetail($this->view->patientKey);
        }

        $this->view->patientpKey = $this->request->getParam('pkey', 'none');
        


        if ($this->view->patientpKey == 'none' or $this->view->patientKey == 'none' or $this->view->patientDetail == false)
        {
            $this->view->exitMade = 'patient_not_found';
        }
        else
        {
            $sogRequestsObj = new Common_Model_Sogcases();  
            $this->view->openedCases = $sogRequestsObj->getAllRequestsShaByUser($this->view->patientpKey);
            
        }

        $this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
        echo $this->view->render('patients/cases_view.php');   
    }



    public function newAction()
    {
        $patientRegistrationFrm = new Auth_Form_PatientsRegister();
        $this->view->errors_form = false;
        $patientRegistrationFrm->signup();
        if ($this->request->isPost()) 
        {
            
            if ($patientRegistrationFrm->isValid($this->request->getPost())) 
            {
                
                $account_obj = new Common_Model_Accounts();
                if ($account_obj->findAccount($this->request->getPost('sog_username_fld')) != false)
                {
                    $this->view->errors_form = true;
                    $this->view->notification = 'Sorry, there is already an account associated to this username.';
                }
                elseif ($account_obj->findAccountEmail($this->request->getPost('sog_emailaddress_fld')) != false)
                {
                    $this->view->errors_form = true;
                    $this->view->notification = 'Sorry, this email address is already associated to another account.';
                }
                else {
                    $ippp_obj = new Common_Model_Ippps();
                    $idr = $ippp_obj->createIppforMember($this->request->getPost('sog_firstname_fld'),$this->request->getPost('sog_lastname_fld'),'Not Specified',$this->request->getPost('sog_cityresidence_fld'),0,$this->request->getPost('sog_countryresidence_fld'),$this->request->getPost('sog_emailaddress_fld'),$this->request->getPost('sog_phonenumber_fld'), $this->request->getPost('sog_dateofbirth_fld'));
                    
                    $session_key = sha1($this->request->getPost('sog_firstname_fld')).sha1($this->request->getPost('sog_lastname_fld')).sha1(time());
                    $mbr_obj = new Common_Model_Patients();
                    $mbr_obj->createMember($idr, $session_key);
                    
                    $account_obj->createAccount($this->request->getPost('sog_username_fld'), $this->request->getPost('sog_password_fld'),$session_key, 'c', $this->request->getPost('sog_dateofbirth_fld'), $this->request->getPost('sog_emailaddress_fld') );
                    
                    $linkofactivation = 'https://soconnect.secondopinionglobal.com/auth/activate/ki/key/'.$session_key; 
                    include_once(CCPATH_APPLICATION.'/data/mails/at_account_creation.php');
  
                    $mail_obj = new Common_Model_Mail();
                    $mail_obj->sendmail($this->request->getPost('sog_emailaddress_fld'), $this->request->getPost('sog_firstname_fld'),'registration@secondopinionglobal.com', 'SOG Registration New Account.',$message_to_opener,'SOG registration of account'  );
                     
                    $patientRegistrationFrm->reset();
                    $this->view->completed_form = true;
                    $this->view->notification = 'Thank you. New Patient have been successfully created.';
                }
            }
            else {
                $this->view->errors_form = true;
                $this->view->error_message = $patientRegistrationFrm->getMessages();
                $this->view->notification = 'Errors in the form. Please fill or correct the fields highlithed in red.';
            }
        }
        
        $this->view->signupform = $patientRegistrationFrm;
        $this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');        
        echo $this->view->render('patients/new_view.php');   
    }  
	


    public function editprofileAction()
    {
        $this->view->patientKey = $this->request->getParam('ckey', 'none');
        if ($this->view->patientKey != 'none')
        {
            $this->view->patientDetail = $this->patientsObj->getPatientDetail($this->view->patientKey);
        }


        if ($this->view->patientKey == 'none' or $this->view->patientDetail == false)
        {
            $this->view->exitMade = 'patient_not_found';

        }
        else
        {

        }


        $patientRegistrationFrm = new Cpadmin_Form_Patients();
        $this->view->errors_form = false;
        $patientRegistrationFrm->editprofile();

        if ($this->request->isPost()) 
        {
            
            if ($patientRegistrationFrm->isValid($this->request->getPost())) 
            {
                
                $account_obj = new Common_Model_Accounts();
                if ($account_obj->findAccount($this->request->getPost('sog_username_fld')) != false)
                {
                    $this->view->errors_form = true;
                    $this->view->notification = 'Sorry, there is already an account associated to this username.';
                }
                elseif ($account_obj->findAccountEmail($this->request->getPost('sog_emailaddress_fld')) != false)
                {
                    $this->view->errors_form = true;
                    $this->view->notification = 'Sorry, this email address is already associated to another account.';
                }
                else {
                    $ippp_obj = new Common_Model_Ippps();
                    $idr = $ippp_obj->createIppforMember($this->request->getPost('sog_firstname_fld'),$this->request->getPost('sog_lastname_fld'),'Not Specified',$this->request->getPost('sog_cityresidence_fld'),0,$this->request->getPost('sog_countryresidence_fld'),$this->request->getPost('sog_emailaddress_fld'),$this->request->getPost('sog_phonenumber_fld'), $this->request->getPost('sog_dateofbirth_fld'));
                    
                    $session_key = sha1($this->request->getPost('sog_firstname_fld')).sha1($this->request->getPost('sog_lastname_fld')).sha1(time());
                    $mbr_obj = new Common_Model_Patients();
                    $mbr_obj->createMember($idr, $session_key);
                    
                    $account_obj->createAccount($this->request->getPost('sog_username_fld'), $this->request->getPost('sog_password_fld'),$session_key, 'c', $this->request->getPost('sog_dateofbirth_fld'), $this->request->getPost('sog_emailaddress_fld') );
                    
                    $linkofactivation = 'https://soconnect.secondopinionglobal.com/auth/activate/ki/key/'.$session_key; 
                    include_once(CCPATH_APPLICATION.'/data/mails/at_account_creation.php');
  
                    $mail_obj = new Common_Model_Mail();
                    $mail_obj->sendmail($this->request->getPost('sog_emailaddress_fld'), $this->request->getPost('sog_firstname_fld'),'registration@secondopinionglobal.com', 'SOG Registration New Account.',$message_to_opener,'SOG registration of account'  );
                     
                    $patientRegistrationFrm->reset();
                    $this->view->completed_form = true;
                    $this->view->notification = 'Thank you. New Patient have been successfully created.';
                }
            }
            else {
                $this->view->errors_form = true;
                $this->view->error_message = $patientRegistrationFrm->getMessages();
                $this->view->notification = 'Errors in the form. Please fill or correct the fields highlithed in red.';
            }
        }
        else
        {
//echo '<pre>'; print_r($this->view->patientDetail);die();
            $ddata_preset['IMT_prof_firstname'] = $this->view->patientDetail['firstname'];
            $ddata_preset['IMT_prof_middlename'] = $this->view->patientDetail['middlename'];
            $ddata_preset['IMT_prof_lastname'] = $this->view->patientDetail['lastname'];
            $ddata_preset['IMT_prof_gender'] = $this->view->patientDetail['sex'];
            $ddata_preset['IMT_prof_maritalstatus'] = $this->view->patientDetail['maritalstatus'];
            $ddata_preset['IMT_prof_dob'] = $this->view->patientDetail['birthdate'];
            $ddata_preset['IMT_prof_email'] = $this->view->patientDetail['email'];
            $ddata_preset['IMT_prof_address'] = $this->view->patientDetail['address'];
            $ddata_preset['IMT_prof_apartnum'] = $this->view->patientDetail['house_aptno'];
            $ddata_preset['IMT_prof_streetnum'] = $this->view->patientDetail['streetname'];
            $ddata_preset['IMT_prof_zip'] = $this->view->patientDetail['zip'];
            $ddata_preset['IMT_prof_country'] = $this->view->patientDetail['country'];
            $ddata_preset['IMT_prof_city'] = $this->view->patientDetail['city'];
            $ddata_preset['IMT_prof_state'] = $this->view->patientDetail['state'];
            $ddata_preset['IMT_prof_cellphone'] = $this->view->patientDetail['cellphone'];
            $ddata_preset['IMT_prof_homephone'] = $this->view->patientDetail['homephone'];
            $ddata_preset['IMT_prof_workphone'] = $this->view->patientDetail['workphone'];
            $patientRegistrationFrm->populate($ddata_preset);
        }
        
        $this->view->signupform = $patientRegistrationFrm;
        $this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');        
        echo $this->view->render('patients/edit_view.php');   
    }  
	
}