<?php

class Cpadmin_ConsultationsController extends Zend_Controller_Action
{
    public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$this->view->userislogged = $this->_helper->AccessControlTower->checkAccess();
		$this->view->defaultInfo = $this->_helper->LoadDefaultInfo->getNavigs($this->view->userislogged[1]['groupusers']);
		$this->view->activeId = 5;
		
		
		//print_r($this->view->defaultInfo);
		$this->casesObj = new Cpadmin_Model_Cases();
		$this->providersObj = new Cpadmin_Model_Providers();
		$this->request = $this->getRequest();
		$this->notificationObj = new Common_Model_Notifications();
		
    }

    public function indexAction()
    {
		
       $this->view->listCases = $this->casesObj->getAllCases();//$this->view->sortby, $this->view->orderby);	


		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('consultations/index_view.php');	
    }


    public function assignAction()
    {

    	$this->view->categorieKey = $this->request->getParam('ckey', 1);
    	$this->view->caseRef = $this->request->getParam('cref', "none");

    	if ($this->view->caseRef == 'none')
    	{
			echo 'No case specified';
			return;
    	}
    	//echo '<pre>'; print_r($this->request->getParams());

		$this->view->reAssignCase = $this->request->getParam('rekey', '0');
    	//echo $this->view->reAssignCase;

    	$specListObj = new Cpadmin_Form_Providers();
    	$providerListObj = new Cpadmin_Form_Providers();
    	$catgoriesListObj = new Common_Model_Specialities() ;
		$categoriesList = $catgoriesListObj->getAllCategories();
//echo $this->view->categorieKey;

        if ($this->view->categorieKey != 1)
        {
            $this->view->providerLists = $this->providersObj->getAllProvidersBySpec($this->view->categorieKey, true);
        }
        //echo '<pre>'; print_r($this->view->providerLists);


        if ($this->view->categorieKey == 'none' or $this->view->providerLists == false)
        {
            $this->view->providerLists = $this->providersObj->getAllProvidersBySpec(1, true);
        }


		$specListObj->categories($categoriesList);	

		if ($this->view->providerLists != false)
		{
			$providerListObj->providerCategories($this->view->providerLists);
		}
		else 
		{

		}


       //$this->view->listCases = $this->casesObj->getAllUnassignedCases();//$this->view->sortby, $this->view->orderby);	
		if ($this->request->isPost()) 
		{
			//echo 'suc/cess';
						//return;
			//die('');
			if ($providerListObj->isValid($this->request->getPost())) 
			{
				$pKode = $this->request->getPost('sog_providers_fld', NULL);

				//update the case status here
				if ($this->view->reAssignCase == '1')
				{
					$this->casesObj->updateStatusProAndProviderForCase($this->view->caseRef, 'reassigned', $pKode);
				}
				else
				{	
					$this->casesObj->updateStatusAndProviderForCase($this->view->caseRef, 'assigned', $pKode);
				}
				//echo $this->view->reAssignCase;

 				$providerDetail = $this->providersObj->getProviderDetail($pKode);


 				include_once(CCPATH_APPLICATION.'/data/mails/at_provider_assignment.php');
                $mail_obj = new Common_Model_Mail();
            
                $mail_obj->sendmail($providerDetail->email ,$providerDetail->firstname,'registration@secondopinionglobal.com','SOG Account Management', $message_to_opener, 'SOG: You have been assigned a new case');

                //re
                echo 'success';

				return;
			}
			else 
			{
				print_r($providerListObj->getErrors());
				echo 'Error in the data';
				return;
			}
		}
		else 
		{
			//if (!$isNewCase){
			//	$newCaseFormObj->populate(array('sog_categories_fld' => $this->view->defaultInfo['allBasket'][0]['Categorie'], 'sog_pricing_fld'=>$this->view->defaultInfo['allBasket'][0]['Selected Plan']));
			//}	
		}
		//$this->view->categorieKey
		$specListObj->populate(array('ckey' => $this->view->categorieKey));
		
		$this->view->categoriesForm = $specListObj;
		$this->view->providersForm = $providerListObj;

		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('consultations/assign_view.php');	
    }


    public function notepatientAction()
    {
    	$this->view->caseRef = $this->request->getParam('cref', "none");
    	if ($this->view->caseRef == 'none')
    	{
			echo 'No case specified';
			return;
    	}

    	$commentFormObj = new Cpadmin_Form_Providers();
    	$commentFormObj->notePatient();

		if ($this->request->isPost()) 
		{
			//echo 'suc/cess';
						//return;
			//die('');
			if ($commentFormObj->isValid($this->request->getPost())) 
			{
				$caseDetails = $this->casesObj->getCaseDetails($this->view->caseRef);
				//$pKode = $this->request->getPost('sog_providers_fld', NULL);
				$this->casesObj->setStatusPendingForCase($this->view->caseRef, 'pending');
				
				//isToBeEdited
				$this->notificationObj->addNotificationForUser('Case '.$this->view->caseRef.': Request for Additional Information', $this->request->getPost('sog_message_patient', NULL) , 'system', date("Y-m-d H:i:s"), $caseDetails['Patient Id'], 'message', 0);

 				include_once(CCPATH_APPLICATION.'/data/mails/at_customer_missing_evidences.php');
                $mail_obj = new Common_Model_Mail();
            
                $mail_obj->sendmail($caseDetails['Email'] ,$caseDetails['Email'],'registration@secondopinionglobal.com','Request for Additional Information', $message_to_opener, 'SOG: Request for Additional Information');

                //re
                echo 'success';

				return;
			}
			else 
			{
				print_r($commentFormObj->getErrors());
				echo 'Error in the data';
				return;
			}
		}
		else 
		{
			
		}
		//$this->view->categorieKey
		//$commentFormObj->populate(array('ckey' => $this->view->categorieKey));
		
		$this->view->commentsForm = $commentFormObj;

		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('consultations/notepatient_view.php');	
    }
    


    public function unassignedAction()
    {
		
       	$this->view->listCases = $this->casesObj->getAllUnassignedCases();

		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('consultations/unassigned_view.php');	
    }


    public function unresolvedAction()
    {
      	$this->view->listCases = $this->casesObj->getAllUnresolvedCases();	

		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('consultations/unresolved_view.php');	
    }


    public function viewnAction()
    {
    	$this->view->caseRef = $this->request->getParam('cref', 'none');
        if ($this->view->caseRef == 'none')
        {
        	$this->view->exitMade = 'case_not_found';
        }
        else
        {

        	$sogRequestsObj = new Common_Model_Sogcases();	
			$this->view->caseDetail = $sogRequestsObj->getCaseDetails($this->view->caseRef);
			//echo '<pre>'; print_r($this->view->caseDetail);die();
			if ($this->view->caseDetail == false)
			{
				$this->view->errorProcess = true;
				$this->view->errorDetail = 'CASE_NOT_FOUND';
			}
			else 
			{
				$rosSession = new Zend_Session_Namespace('case_request_ros');
				$keyConer = sha1($this->view->caseRef);
				$rosSession->link[$keyConer] = $this->view->caseRef;
				$this->view->keyCase = $keyConer;

				$soghealthObj = new Common_Model_Soghealth();
				$checkIfPHHFilled = $soghealthObj->isPHHFilledForCases($this->view->caseDetail);
				if ($checkIfPHHFilled == 1)
				{
					$this->view->noPHHProvided = true;
				}
				else
				{
					if (strlen(trim($this->view->caseDetail['medicPstInfo'])) != 0)
					{
						$this->view->noHealthInfo = false;
						$pffs = $sogRequestsObj->getHealthByCase($this->view->caseDetail['medicPstInfo']);
						if ($pffs)
						{
							$this->view->viewPHHH = true;
							$this->view->allPstQuestions = $pffs;
						}
					}

					if (strlen(trim($this->view->caseDetail['medicFamlInfo'])) != 0)
					{
						$this->view->noHealthInfo = false;
						$pffs = $sogRequestsObj->getHealthByCase($this->view->caseDetail['medicFamlInfo']);
						if ($pffs)
						{
							$this->view->viewFHHH = true;
							$this->view->allFamQuestions = $pffs;
						}
					}	

					if (strlen(trim($this->view->caseDetail['medicPrsInfo'])) != 0)
					{
						$this->view->noHealthInfo = false;
						$pffs = $sogRequestsObj->getHealthByCase2($this->view->caseDetail['medicPrsInfo']);
						if ($pffs)
						{
							$this->view->viewPreHHH = true;
							$this->view->allPreQuestions = $pffs;
						}
					}	
				}

				$sogfilesObj = new Common_Model_Sogfiles();
    			$this->view->listUploadedFiles = $sogfilesObj->getAttachmentsForCase($this->view->caseRef);
    			$targetDir = CCPATH_APPLICATION."/data/datacases/store/".$this->view->caseReferenceId;

				if (is_object($this->view->listUploadedFiles))
				{
					$caseFilesSession = new Zend_Session_Namespace('new_file_request_for_case');
					
					foreach ($this->view->listUploadedFiles as $key => $val)
					{
						$encryptedFileName = sha1($val['fileRef']);
						$caseFilesSession->objects[$encryptedFileName] = $targetDir.'/'.$val['fileRef'];

						$filesAttach[$val['fileRef']] = $encryptedFileName;
					}
					$this->view->filesAttach = $filesAttach;
				}
				
				$detailsPlan = $this->getPaymentPlan($this->view->caseDetail['planSelected']);
				$this->view->selected_plan = $detailsPlan['namea'];
				$this->view->cost_plan = $detailsPlan['plana'];
				$this->view->total_cost_plan = $detailsPlan['plana'];
				
				$this->view->allQuestions = $sogRequestsObj->getQuestionsByCase($this->view->caseDetail['id'], $this->view->caseDetail['Patient Id']);
				//}

				/*
				$this->view->caseViewSelected = $this->request->getParam('spf', 'Missing !!');
				
				if ($this->view->caseViewSelected == 'medical')
				{
					$this->view->noHealthInfo = true;
					
									

								
					
					$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
					echo $this->view->render('requests/viewmedical_view.php');
					return;	
				}
				else
				{*/
					//$caseFilesSession = new Zend_Session_Namespace('new_file_request_for_case');
				
			}
		}
        
        $this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
        echo $this->view->render('consultations/viewn_view.php');  
    }


	private function getPaymentPlan($selectedPlan)
	{
		$config = Zend_Controller_Front::getInstance()->getParam('bootstrap');
		$btKeys = $config->getOption('bt');

		if ($selectedPlan == 'a'){
			return array('namea' => $btKeys['namea'],'plana' => $btKeys['plana']);
		}
		elseif ($selectedPlan == 'b'){
			return array('namea' => $btKeys['nameb'],'plana' => $btKeys['planb']);
		}
		elseif ($selectedPlan == 'c'){
			return array('namea' => $btKeys['namec'],'plana' => $btKeys['planc']);
		}		
	}
}