<?php

class Common_Model_Sogcasesmedical extends Zend_Db_Table_Abstract
{
    protected $_name = 'cases_medical';
	protected $_primary = 'id';
	
	public function createNewCase($refenceId,$patientId,$openedDate,$planSelected, $inBasket)
	{
		$data = array('refenceId' => $refenceId,'patientId' => $patientId,'openedDate'=> $openedDate,'planSelected' => $planSelected, 'caseQuestion1' => '', 'caseQuestion2' => '', 'caseQuestion3' => '', 'inBasket' => $inBasket);
		return $this->insert($data);
	}
	
	public function updatePlanForCase($referenceId, $newPlan){
		$data = array('planSelected' => $newPlan);
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}
	
	public function updateBasketForCase($referenceId){
		$data = array('inBasket' => 0);
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}
	
	public function updateQuestionsForCase($referenceId, $q1, $q2, $q3){
		$data = array('caseQuestion1' => $q1, 'caseQuestion2' => $q2, 'caseQuestion3' => $q3);
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}
	
	public function searchForBasketCaseByRef($referenceId){
		$result = $this->fetchRow($this->select()->from(array('a' => 'cases'))
		->where('refenceId = ?', $referenceId)->where('inBasket = ?', 1));
		if (0 == count($result)) return false;
		return $result;
	}
	
	public function deleteBasketCaseByRef($id){
		return $this->_db->delete('cases', 'id = '.$id);
	}
	
	public function getCasesStillInBasket($patientId)
	{
		$resultSet = $this->fetchAll($this->select()
			->from($this, array('id' => 'id', 'Ref #' => 'refenceId', 'cod'=> 'openedDate', 'Selected Plan' => 'planSelected'))
			->where('patientId = ?', $patientId)
			->where('inBasket = ?', 1)
			->setIntegrityCheck(false));
			
		if (0 == count($resultSet)) return -1;
		else return $resultSet;
	}
	
	public function getRequestsByUser($userId = null)
	{
		$resultSet = $this->fetchAll($this->select()
			->from($this, array('id' => 'id', 'Ref #' => 'refenceId', 'Patient Id' => 'patientId', 'cod'=> 'openedDate', 'Provider id' => 'providerId', 'Case question 1' => 'caseQuestion1', 'Case question 2' => 'caseQuestion2', 'Case question 3' => 'caseQuestion3', 'Status' => 'caseStatus', 'Accessed date' => 'accessedDate', 'ccd' => 'closingDate', 'supervisor Id' => 'supervisorId', 'datec' => 'openedDate'))
			->where('patientId = ?', $userId)
			->setIntegrityCheck(false));
		
		if (0 == count($resultSet)) return false;
		else return $resultSet;
	}
	
	
	
	
	
	
	
	
	
	public function get_all_cases()
	{
		$resultSet = $this->fetchAll($this->select()
			->from($this, array('id' => 'id', 'refenceId' => 'Ref #', 'patientId' => 'Patient Id', 'openedDate'=> 'cod', 'providerId' => 'Provider id', 'caseQuestion1' => 'Case question 1', 'caseQuestion2' => 'Case question 2', 'caseQuestion3' => 'Case question 3', 'caseStatus' => 'Status', 'accessedDate' => 'Accessed date', 'closingDate' => 'ccd', 'supervisorId' => 'supervisor Id'))
			->join(array('i' => 'ipps'), 'c.ippid = i.ippid', array('First name' =>'firstname', 'Last name' => 'lastname', 'Email' => 'email'))
			->where('c.id = ?', $key)
			->setIntegrityCheck(false))
			
			
			;
		
		if (0 == count($resultSet)) return false;
		else return $rs;
		
		/*
		'id', 'refenceId', 'patientId', 'openedDate', 'providerId', 'caseQuestion1', 'caseQuestion2', 'caseQuestion3', 'caseStatus', 'accessedDate', 'closingDate', 'supervisorId'
		
		if ($as_array)
		{
			foreach ($resultSet as $k => $v)
			{
				$rs['keys'][$v['id']] = $v['title'];
				$rs['full'][$v['id']] = array('id' => $v['id'], 'title' => $v['title'], 'rate' => $v['ratesinitial'], 'ratef' => $v['ratesfollowup'], 'description' => $v['description'], 'initdurt' => $v['durationinitial'], 'foldurt' => $v['durationfollowup'], 'choiceduration' => $v['choiceduration']);
			}
			return $rs; 
		}*/	
		
	}	 
	 
	 
	 
	 
	 
	public function find_key($activationkey)
	{
		$result = $this->fetchRow($this->select()->from(array('a' => 'accounts'),array('id' => 'id','activationkey' => 'activationkey','accountactivated' => 'accountactivated', 'activationdate' => 'activationdate', 'object' => 'object'))->where('activationkey = ?', $activationkey));
		
		if (0 == count($result) or $result['accountactivated'] == 1) return false;
		return $result;
	}
	
	public function activate_account($id)
	{
		$data = array('accountactivated' => 1,
              'activationdate' => new Zend_Db_Expr('NOW()'));
		return $this->_db->update('accounts', $data, array('id = '.$id));
	}
	

    public function find_account($username, $password = NULL, $strict = false)
    {
		$result = $this->fetchRow($this->select()->from(array('a' => 'accounts'), array('password','accountactivated','activationkey','object'))->where('username = ?', $username));
		if (0 == count($result)) return false;
		if (is_null($password))
		{
			if ($result['object'] == 'c') $valObject = 'patients';
			elseif ($result['object'] == 'p') $valObject = 'providers';
			elseif ($result['object'] == 'a') $valObject = 'consol';
			return array($result['accountactivated'],$result['activationkey'],$result['object'], $valObject);
		}
		else
		{
			if (sha1($password) != $result['password']) return false;
			else {
				if ($result['object'] == 'c') $valObject = 'patients';
				elseif ($result['object'] == 'p') $valObject = 'providers';
				elseif ($result['object'] == 'a') $valObject = 'consol';
				return array($result['accountactivated'],$result['activationkey'],$result['object'], $valObject);
			}
		}
	}
	
	public function check_password($id, $password)
	{
		$resultSet = $this->fetchAll($this->select()->where('id = ?', $id));
		if (0 == count($resultSet)) return false;
		$row = $resultSet->current(); 
		if ($this->crypPassword($password) != $row['password']) return false;
		return $row['password'];
	}
	
	public function crypPassword($password)
	{
		return sha1($password);	
	}
	
	public function updatePassword($id, $password)
	{
		$data = array('password' => $this->crypPassword($password));
		return $this->_db->update('customers', $data, array('id = '.$id));
	}
	
	
}
