<?php

class Common_Model_Sogcases extends Zend_Db_Table_Abstract
{
    protected $_name = 'cases';
	protected $_primary = 'id';

	
	public function createNewCase($refenceId,$patientId,$openedDate,$planSelected, $inBasket, $categorie)
	{
		$data = array('refenceId' => $refenceId,'patientId' => $patientId,'openedDate'=> $openedDate,'planSelected' => $planSelected, 'caseQuestion1' => '', 'caseQuestion2' => '', 'caseQuestion3' => '', 'inBasket' => $inBasket, 'categorie' => $categorie);
		$this->insert($data);
		return $this->_db->lastInsertId();

	}

	public function updateRefNumber($id, $referenceId)
	{
		$data = array('refenceId' => $referenceId);
		return $this->_db->update('cases', $data, array('id = \''.$id.'\''));
	}

	
	public function updatePlanForCase($referenceId, $newPlan){
		$data = array('planSelected' => $newPlan);
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}
	
	public function updatePlanAndCategorieForCase($referenceId, $newPlan, $newCategorie){
		$data = array('planSelected' => $newPlan, 'categorie' => $newCategorie);
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}
	
	public function updateBasketForCase($referenceId){
		$data = array('inBasket' => 0);
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}
	
	public function putCaseInBasket($referenceId){
		$data = array('inBasket' => 1);
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}
	
	public function lockCaseForCustomer($referenceId){
		$data = array('isToBeEdited' => 0,'caseStatus' => 'new', 'caseStatusPro' => 'reassigned');
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}


	public function updateQuestionsForCase($referenceId, $q1, $q2, $q3){
		$data = array('caseQuestion1' => $q1, 'caseQuestion2' => $q2, 'caseQuestion3' => $q3);
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}
	
	
	public function updateDescriptionForCase($referenceId, $description){
		$data = array('description' => $description);
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}

	public function updateAttachmentsForCase($referenceId, $option){
		$data = array('optionAttachment' => $option);
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}
	
	public function searchForBasketCaseByRef($referenceId){
		$result = $this->fetchRow($this->select()->from(array('a' => 'cases'))
		->where('refenceId = ?', $referenceId)->where('inBasket = ?', 1));
		if (0 == count($result)) return false;
		return $result;
	}
	
	public function deleteBasketCaseByRef($id){
		return $this->_db->delete('cases', 'id = '.$id);
	}

	
	public function deleteBasketCaseByRef2($id){
		return $this->_db->delete('cases', 'refenceId = \''.$id.'\'');
	}
	
	public function getCasesStillInBasket($patientId)
	{
		$resultSet = $this->fetchAll($this->select()
			->from(array('c' => 'cases'), array('id' => 'id', 'Ref #' => 'refenceId', 'cod'=> 'openedDate', 'Selected Plan' => 'planSelected', 'Categorie' => 'categorie', 'descriptionPstInfo' =>'descriptionPstInfo', 'medicPstInfo' => 'medicPstInfo', 'medicFamlInfo' => 'medicFamlInfo', 'descriptionFamlInfo' => 'descriptionFamlInfo', 'description' => 'description', 'question1' => 'caseQuestion1', 'question2' => 'caseQuestion2', 'question3' => 'caseQuestion3', 'optionAttachment' => 'optionAttachment'))
			//->join(array('cmc' => 'cases_medical_categories'), 'cmc.id = c.categorie', array('Categorie Name' =>'name'))
			->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
			->where('patientId = ?', $patientId)
			->where('inBasket = ?', 1)
			->setIntegrityCheck(false));
			
		if (0 == count($resultSet)) return -1;
		else return $resultSet;
	}


	public function getAllRequestsByUser($userId = null, $limited = false)
	{
			$resultSet = $this->fetchAll($this->select()
				->from(array('c' => 'cases'))
				->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
				->where('patientId = ?', $userId)
				
				->setIntegrityCheck(false));
		
		if (0 == count($resultSet)) return false;
		else return $resultSet;
	}


	public function getAllRequestsShaByUser($userId = null, $limited = false)
	{
			$resultSet = $this->fetchAll($this->select()
				->from(array('c' => 'cases'))
				->join(array('cmc' => 'customers'), 'cmc.id = c.patientId')
				->join(array('ip' => 'ipps'), 'ip.ippid = cmc.ippid')
				->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
				->where('sha1(patientId) = ?', $userId)
				
				->setIntegrityCheck(false));
		
		if (0 == count($resultSet)) return false;
		else return $resultSet;
	}


	public function getCasesInPeriod($startDate = null, $endDate = false)
	{
			$resultSet = $this->fetchAll($this->select()
				->from(array('c' => 'cases'))
				->join(array('cmc' => 'customers'), 'cmc.id = c.patientId')
				->join(array('ip' => 'ipps'), 'ip.ippid = cmc.ippid')
				->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
				->where("c.openedDate >= ?",  $startDate)
    			->where("c.openedDate <= ?",  $endDate)
	
	
				//->where('sha1(patientId) = ?', $userId)
				
				->setIntegrityCheck(false));
		
		if (0 == count($resultSet)) return false;
		else return $resultSet;
	}




	
	public function getRequestsByUser($userId = null, $limited = false)
	{

			$resultSet = $this->fetchAll($this->select()
				->from(array('c' => 'cases'))
				->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
				->where('patientId = ?', $userId)
				->where('caseStatus = ?', 'new')
				->setIntegrityCheck(false));
		
		if (0 == count($resultSet)) return false;
		else return $resultSet;
	}



	public function getCurrentCasesByUser($userId = null, $limited = false)
	{
		if ($limited)
		{
			$resultSet = $this->fetchAll($this->select()
				->from(array('c' => 'cases'), array('openedDate', 'caseStatus', 'refenceId'))
				->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
				->where('patientId = ?', $userId)
				->where('caseStatus = ?', 'new')//assigned
				->setIntegrityCheck(false));
		}
		else
		{
			$resultSet = $this->fetchAll($this->select()
				->from(array('c' => 'cases'))
				->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
				->where('patientId = ?', $userId)
				->where('caseStatus = ?', 'new')
				->setIntegrityCheck(false));
		}
		if (0 == count($resultSet)) return false;
		else return $resultSet;
	}



	public function getClosedCasesByUser($userId = null, $limited = false)
	{
		if ($limited)
		{
			$resultSet = $this->fetchAll($this->select()
				->from(array('c' => 'cases'), array('openedDate', 'caseStatus', 'refenceId'))
				->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
				->where('patientId = ?', $userId)
				->where('caseStatus = ?', 'closed')
				->setIntegrityCheck(false));
		}
		else
		{
			$resultSet = $this->fetchAll($this->select()
				->from(array('c' => 'cases'))
				->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
				->where('patientId = ?', $userId)
				->where('caseStatus = ?', 'closed')
				->setIntegrityCheck(false));
		}
		if (0 == count($resultSet)) return false;
		else return $resultSet;
	}







	public function getNewRequestsByProvider($userId = null)
	{
		$resultSet = $this->fetchAll($this->select()
			->from(array('c' => 'cases'), array('id' => 'id', 'Ref #' => 'refenceId', 'Patient Id' => 'patientId', 'cod'=> 'openedDate', 'Provider id' => 'providerId', 'Case question 1' => 'caseQuestion1', 'Case question 2' => 'caseQuestion2', 'Case question 3' => 'caseQuestion3', 'Status' => 'caseStatus', 'Accessed date' => 'accessedDate', 'ccd' => 'closingDate', 'supervisor Id' => 'supervisorId', 'datec' => 'openedDate'))
			->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
			->join(array('cst' => 'customers'), 'cst.id = c.patientId')
			->join(array('i' => 'ipps'),'cst.ippid = i.ippid',
				array('Last name' => 'lastname','Ippp Id'  => 'ippid', 'Middle name'  => 'middlename', 'First name'  => 'firstname', 'Birth date'  => 'birthdate', 'Sex'  => 'sex', 'Marital status'  => 'maritalstatus', 'House or Apt no'  => 'house_aptno', 'Street name'  => 'streetname', 'City'  => 'city', 'State'  => 'state', 'Zip'  => 'zip', 'Email'  => 'email', 'Address'  => 'address', 'Country Code'  => 'country', 'Cellphone'  => 'cellphone', 'Homephone'  => 'homephone', 'Workphone'  => 'workphone', 'Occupation' => 'occupation', 'Medicinsur_planname' => 'medicinsur_planname', 'employerid' => 'Employerid', 'Address' => 'address', 'Picture' => 'picture'))
			->where('providerId = ?', $userId)
			->where('caseStatus = ?', 'assigned')
			->where('caseStatusPro = ?', 'ini')
			->ORwhere('caseStatusPro = ?', 'reassigned')
			->setIntegrityCheck(false));
		if (0 == count($resultSet)) return false;
		else return $resultSet;
	}


	public function getCurrentRequestsByProvider($userId = null)
	{
		$resultSet = $this->fetchAll($this->select()
			->from(array('c' => 'cases'), array('id' => 'id', 'Ref #' => 'refenceId', 'Patient Id' => 'patientId', 'cod'=> 'openedDate', 'Provider id' => 'providerId', 'Case question 1' => 'caseQuestion1', 'Case question 2' => 'caseQuestion2', 'Case question 3' => 'caseQuestion3', 'Status' => 'caseStatus', 'Accessed date' => 'accessedDate', 'ccd' => 'closingDate', 'supervisor Id' => 'supervisorId', 'datec' => 'openedDate'))
			->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
			->join(array('cst' => 'customers'), 'cst.id = c.patientId')
			->join(array('i' => 'ipps'),'cst.ippid = i.ippid',
				array('Last name' => 'lastname','Ippp Id'  => 'ippid', 'Middle name'  => 'middlename', 'First name'  => 'firstname', 'Birth date'  => 'birthdate', 'Sex'  => 'sex', 'Marital status'  => 'maritalstatus', 'House or Apt no'  => 'house_aptno', 'Street name'  => 'streetname', 'City'  => 'city', 'State'  => 'state', 'Zip'  => 'zip', 'Email'  => 'email', 'Address'  => 'address', 'Country Code'  => 'country', 'Cellphone'  => 'cellphone', 'Homephone'  => 'homephone', 'Workphone'  => 'workphone', 'Occupation' => 'occupation', 'Medicinsur_planname' => 'medicinsur_planname', 'employerid' => 'Employerid', 'Address' => 'address', 'Picture' => 'picture'))
			->where('providerId = ?', $userId)
			->where('caseStatus = ?', 'assigned')
			->where('caseStatusPro = ?', 'accepted')
			->setIntegrityCheck(false));
		if (0 == count($resultSet)) return false;
		else return $resultSet;
	}


	public function getClosedRequestsByProvider($userId = null)
	{
		$resultSet = $this->fetchAll($this->select()
			->from(array('c' => 'cases'), array('id' => 'id', 'Ref #' => 'refenceId', 'Patient Id' => 'patientId', 'cod'=> 'openedDate', 'Provider id' => 'providerId', 'Case question 1' => 'caseQuestion1', 'Case question 2' => 'caseQuestion2', 'Case question 3' => 'caseQuestion3', 'Status' => 'caseStatus', 'Accessed date' => 'accessedDate', 'ccd' => 'closingDate', 'supervisor Id' => 'supervisorId', 'datec' => 'openedDate'))
			->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
			->join(array('cst' => 'customers'), 'cst.id = c.patientId')
			->join(array('i' => 'ipps'),'cst.ippid = i.ippid',
				array('Last name' => 'lastname','Ippp Id'  => 'ippid', 'Middle name'  => 'middlename', 'First name'  => 'firstname', 'Birth date'  => 'birthdate', 'Sex'  => 'sex', 'Marital status'  => 'maritalstatus', 'House or Apt no'  => 'house_aptno', 'Street name'  => 'streetname', 'City'  => 'city', 'State'  => 'state', 'Zip'  => 'zip', 'Email'  => 'email', 'Address'  => 'address', 'Country Code'  => 'country', 'Cellphone'  => 'cellphone', 'Homephone'  => 'homephone', 'Workphone'  => 'workphone', 'Occupation' => 'occupation', 'Medicinsur_planname' => 'medicinsur_planname', 'employerid' => 'Employerid', 'Address' => 'address', 'Picture' => 'picture'))
			->where('providerId = ?', $userId)
			->where('caseStatus = ?', 'completed')
			->where('caseStatusPro = ?', 'completed')
			->setIntegrityCheck(false));
		if (0 == count($resultSet)) return false;
		else return $resultSet;
	}



	public function getRequestsByProvider($userId = null)
	{
		$resultSet = $this->fetchAll($this->select()
			->from(array('c' => 'cases'), array('id' => 'id', 'Ref #' => 'refenceId', 'Patient Id' => 'patientId', 'cod'=> 'openedDate', 'Provider id' => 'providerId', 'Case question 1' => 'caseQuestion1', 'Case question 2' => 'caseQuestion2', 'Case question 3' => 'caseQuestion3', 'Status' => 'caseStatus', 'Accessed date' => 'accessedDate', 'ccd' => 'closingDate', 'supervisor Id' => 'supervisorId', 'datec' => 'openedDate'))
		//	->join(array('cmc' => 'cases_medical_categories'), 'cmc.id = c.categorie', array('Categorie Name' =>'name'))
			->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))

			->join(array('cst' => 'customers'), 'cst.id = c.patientId')
			->join(array('i' => 'ipps'),'cst.ippid = i.ippid',
				array('Last name' => 'lastname','Ippp Id'  => 'ippid', 'Middle name'  => 'middlename', 'First name'  => 'firstname', 'Birth date'  => 'birthdate', 'Sex'  => 'sex', 'Marital status'  => 'maritalstatus', 'House or Apt no'  => 'house_aptno', 'Street name'  => 'streetname', 'City'  => 'city', 'State'  => 'state', 'Zip'  => 'zip', 'Email'  => 'email', 'Address'  => 'address', 'Country Code'  => 'country', 'Cellphone'  => 'cellphone', 'Homephone'  => 'homephone', 'Workphone'  => 'workphone', 'Occupation' => 'occupation', 'Medicinsur_planname' => 'medicinsur_planname', 'employerid' => 'Employerid', 'Address' => 'address', 'Picture' => 'picture'))
		
			



			->where('providerId = ?', $userId)
			->setIntegrityCheck(false));
		
		if (0 == count($resultSet)) return false;
		else return $resultSet;
	}

	
	public function getRequestById($idCase = null)
	{
		$result = $this->fetchRow($this->select()
			->from(array('c' => 'cases'), array('id' => 'id', 'Ref #' => 'refenceId', 'Patient Id' => 'patientId', 'cod'=> 'openedDate', 'Provider id' => 'providerId', 'Case question 1' => 'caseQuestion1', 'Case question 2' => 'caseQuestion2', 'Case question 3' => 'caseQuestion3', 'Status' => 'caseStatus', 'Accessed date' => 'accessedDate', 'ccd' => 'closingDate', 'supervisor Id' => 'supervisorId', 'datec' => 'openedDate', 'planSelected' => 'planSelected', 'description' => 'description',  'descriptionPstInfo' =>'descriptionPstInfo', 'medicPstInfo' => 'medicPstInfo', 'medicFamlInfo' => 'medicFamlInfo', 'descriptionFamlInfo' => 'descriptionFamlInfo', 'description' => 'description', 'medicPrsInfo' => 'medicPrsInfo', 'height' => 'height', 'weight' => 'weight', 'isToBeEdited' => 'isToBeEdited'))
			->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name', 'Categorie Id' =>'id'))
			->where('refenceId = ?', $idCase)
			->setIntegrityCheck(false));
		
		if (0 == count($result))
		{
			return false;
		}
		return $result;
	}
	

	//
	public function getCaseByIdAndProvider($idCase = null, $providerCode = null)
	{
		$result = $this->fetchRow($this->select()
			->from(array('c' => 'cases'), array('id' => 'id', 'Ref #' => 'refenceId', 'Patient Id' => 'patientId', 'cod'=> 'openedDate', 'Provider id' => 'providerId', 'Case question 1' => 'caseQuestion1', 'Case question 2' => 'caseQuestion2', 'Case question 3' => 'caseQuestion3', 'Status' => 'caseStatus', 'Accessed date' => 'accessedDate', 'ccd' => 'closingDate', 'supervisor Id' => 'supervisorId', 'datec' => 'openedDate', 'planSelected' => 'planSelected', 'description' => 'description',  'descriptionPstInfo' =>'descriptionPstInfo', 'medicPstInfo' => 'medicPstInfo', 'medicFamlInfo' => 'medicFamlInfo', 'descriptionFamlInfo' => 'descriptionFamlInfo', 'description' => 'description', 'medicPrsInfo' => 'medicPrsInfo', 'height' => 'height', 'weight' => 'weight', 'isToBeEdited' => 'isToBeEdited'))
			//->join(array('cmc' => 'cases_medical_categories'), 'cmc.id = c.categorie', array('Categorie Name' =>'name'))
			->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
			->where('refenceId = ?', $idCase)
			->where('providerId = ?', $providerCode)
			->setIntegrityCheck(false));
		
		if (0 == count($result))
		{
			return false;
		}
		return $result;
	}


	public function getCaseDetails($idCase = null)
	{
		$result = $this->fetchRow($this->select()
			->from(array('c' => 'cases'), array('id' => 'id', 'Ref #' => 'refenceId', 'Patient Id' => 'patientId', 'cod'=> 'openedDate', 'Provider id' => 'providerId', 'Case question 1' => 'caseQuestion1', 'Case question 2' => 'caseQuestion2', 'Case question 3' => 'caseQuestion3', 'Status' => 'caseStatus', 'Accessed date' => 'accessedDate', 'ccd' => 'closingDate', 'supervisor Id' => 'supervisorId', 'datec' => 'openedDate', 'planSelected' => 'planSelected', 'description' => 'description',  'descriptionPstInfo' =>'descriptionPstInfo', 'medicPstInfo' => 'medicPstInfo', 'medicFamlInfo' => 'medicFamlInfo', 'medicPrsInfo' => 'medicPrsInfo', 'descriptionFamlInfo' => 'descriptionFamlInfo', 'description' => 'description', 'height' => 'height', 'weight' => 'weight', 'isToBeEdited' => 'isToBeEdited', 'caseStatusPro' => 'caseStatusPro'))
			//->join(array('cmc' => 'cases_medical_categories'), 'cmc.id = c.categorie', array('Categorie Name' =>'name'))
			->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
			->join(array('cst' => 'customers'), 'cst.id = c.patientId')
			->join(array('i' => 'ipps'),'cst.ippid = i.ippid',
				array('Last name' => 'lastname','Ippp Id'  => 'ippid', 'Middle name'  => 'middlename', 'First name'  => 'firstname', 'Birth date'  => 'birthdate', 'Sex'  => 'sex', 'Marital status'  => 'maritalstatus', 'House or Apt no'  => 'house_aptno', 'Street name'  => 'streetname', 'City'  => 'city', 'State'  => 'state', 'Zip'  => 'zip', 'Email'  => 'email', 'Address'  => 'address', 'Country Code'  => 'country', 'Cellphone'  => 'cellphone', 'Homephone'  => 'homephone', 'Workphone'  => 'workphone', 'Occupation' => 'occupation', 'Medicinsur_planname' => 'medicinsur_planname', 'employerid' => 'Employerid', 'Address' => 'address', 'Picture' => 'picture'))
			->where('refenceId = ?', $idCase)
			->setIntegrityCheck(false));
		
		if (0 == count($result))
		{
			return false;
		}
		return $result;
	}

	public function getHealthByCase($healths)
	{
		//die($healths);
		$resultSet = $this->fetchAll($this->select()
			->from(array('c' => 'hhcodes'), array('question' =>'question'))
			->where('c.id IN ('.$healths.')')
			->setIntegrityCheck(false));	
			//die();
		if (0 == count($resultSet)) return false;
		else return $resultSet;
	}
	


	public function getHealthByCase2($healths)
	{
		//die($healths);
		$resultSet = $this->fetchAll($this->select()
			->from(array('c' => 'roscodes'), array('question' =>'question'))
			->where('c.id IN ('.$healths.')')
			->setIntegrityCheck(false));	
			//die();
		if (0 == count($resultSet)) return false;
		else return $resultSet;
	}
	
	public function getQuestionsByCase($caseRef, $patientId)
	{
		$resultSet = $this->fetchAll($this->select()
			->from(array('c' => 'hhcodes_patients'))
			->join(array('h' => 'hhcodes'), 'c.questionId = h.id', array('question' =>'question'))
			->where('c.patientId = ?', $patientId)
			->where('c.caseRef = ?', $caseRef)
			->setIntegrityCheck(false));	
			
		if (0 == count($resultSet)) return false;
		else return $resultSet;
	}
	
	public function closeCaseByProvider($referenceId){
		$data = array('caseStatus' => 'completed', 'caseStatusPro' => 'completed', 'closingDate' => new Zend_Db_Expr('NOW()'));
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}
	
	
	public function updateAdminStatusForCase($referenceId, $caseStatus){
		$data = array('caseStatusPro' => $caseStatus);
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}


	public function updateStatusForCase($referenceId, $caseStatus){
		$data = array('caseStatus' => $caseStatus);
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}
	
	public function updateRejectionForCase($referenceId, $reasonsReject, $nextAction, $comments)
	{
		$data = array('rejectionReasons' => $reasonsReject, 'actionRecommended' => $nextAction, 'commentsActionProvider' => $comments);
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}
	
	
	
	public function getCompletedCase()
	{
		$result = $this->fetchRow($this->select()
			->from(array('c' => 'cases'), array('id' => 'id', 'Ref #' => 'refenceId', 'Patient Id' => 'patientId', 'cod'=> 'openedDate', 'Provider id' => 'providerId', 'Case question 1' => 'caseQuestion1', 'Case question 2' => 'caseQuestion2', 'Case question 3' => 'caseQuestion3', 'Status' => 'caseStatus', 'Accessed date' => 'accessedDate', 'ccd' => 'closingDate', 'supervisor Id' => 'supervisorId', 'datec' => 'openedDate', 'planSelected' => 'planSelected', 'description' => 'description',  'descriptionPstInfo' =>'descriptionPstInfo', 'medicPstInfo' => 'medicPstInfo', 'medicFamlInfo' => 'medicFamlInfo', 'descriptionFamlInfo' => 'descriptionFamlInfo', 'description' => 'description', 'medicPrsInfo' => 'medicPrsInfo', 'height' => 'height', 'weight' => 'weight', 'isToBeEdited' => 'isToBeEdited'))
			->join(array('sp' => 'specialities'), 'sp.id = c.categorie', array('Categorie Name' =>'name'))
			->where('caseStatus = ?', 'completed')
			->where('caseStatusPro = ?', 'completed')
			->where('isPRProcessed = ?', 0)
			->setIntegrityCheck(false));
		
		if (0 == count($result))
		{
			return false;
		}
		return $result;		
	}
	
	public function updatePrForCase($referenceId){
		$data = array('isPRProcessed' => 1);
		return $this->_db->update('cases', $data, array('refenceId = \''.$referenceId.'\''));
	}
		

	
}
