<?php

class Common_Model_Settings extends Zend_Db_Table_Abstract
{
    protected $_name = 'csettings';
	protected $_primary = 'id';
	
	public function getGeneralSettingsByCustomer($cid)
	{
		// preparing and executing the research
		$resultSet = $this->fetchAll($this->select()->from(array('cs' => 'csettings'),array('id' => 'id', 'description' => 'nameset', 'type' => 'type', 'displayoptions' => 'displayoptions', 'options' => 'options', 'default_value' => 'defaultvalue','name' => 'keyset'))->joinLeft(array('s' => 'settings_customers'), 's.setting_id = cs.id AND s.customer_id = '.$cid, array('value' => 'value'))->where('cs.category = \'general\'')->setIntegrityCheck(false));
		if (!$resultSet or 0 == count($resultSet)) return false;
		foreach ($resultSet as $k => $v)
		{
			if (strlen($v['value']) == 0)
			{
				$rs[] = array('name' => $v['name'], 'default_value' => $v['default_value'], 'id' => $v['id'], 'description' => $v['description'], 'type' => $v['type'], 'options' => $v['options'], 'displayoptions' => $v['displayoptions']);
			}
			else 
			{
				$rs[] = array('name' => $v['name'], 'value' => $v['value'], 'default_value' => $v['default_value'], 'id' => $v['id'], 'description' => $v['description'], 'type' => $v['type'], 'options' => $v['options'], 'displayoptions' => $v['displayoptions']);
			}
		}
		return $rs;
	}
	
	public function getAppointmentsSettingsByCustomer($cid)
	{
		// preparing and executing the research
		$resultSet = $this->fetchAll($this->select()->from(array('cs' => 'csettings'),array('id' => 'id', 'description' => 'nameset', 'type' => 'type', 'displayoptions' => 'displayoptions', 'options' => 'options', 'default_value' => 'defaultvalue','name' => 'keyset'))->joinLeft(array('s' => 'settings_customers'), 's.setting_id = cs.id AND s.customer_id = '.$cid, array('value' => 'value'))->where('cs.category = \'appointments\'')->setIntegrityCheck(false));
		if (!$resultSet or 0 == count($resultSet)) return false;
		foreach ($resultSet as $k => $v)
		{
			if (strlen($v['value']) == 0)
			{
				$rs[] = array('name' => $v['name'], 'default_value' => $v['default_value'], 'id' => $v['id'], 'description' => $v['description'], 'type' => $v['type'], 'options' => $v['options'], 'displayoptions' => $v['displayoptions']);
			}
			else 
			{
				$rs[] = array('name' => $v['name'], 'value' => $v['value'], 'default_value' => $v['default_value'], 'id' => $v['id'], 'description' => $v['description'], 'type' => $v['type'], 'options' => $v['options'], 'displayoptions' => $v['displayoptions']);
			}
		}
		return $rs;
	}
	
	public function updateGeneralSettingsForUser($cid, $sid, $value)
	{
		$resultSet = $this->fetchAll($this->select()->from(array('cs' => 'settings_customers'))
						->where('cs.customer_id = ?', $cid)
						->where('cs.setting_id = ?', $sid)
						->setIntegrityCheck(false));
		if (!$resultSet or 0 == count($resultSet))
		{
			$data = array('customer_id' => $cid,'setting_id' => $sid,'value' => $value);
			$this->_db->insert('settings_customers', $data);
			return $this->_db->lastInsertId();
		}
		else {
			$data = array('value' => $value);
			$where = array('customer_id = ?' => $cid,'setting_id = ?' => $sid);
			return $this->_db->update('settings_customers', $data, $where);
		}
	}
	
	public function getGeneralSettingsForUser_email($cid)
	{
		$resultSet = $this->fetchAll($this->select()->from(array('cs' => 'csettings'),array('default_value' => 'defaultvalue'))->joinLeft(array('s' => 'settings_customers'), 's.setting_id = cs.id AND s.customer_id = '.$cid, array('value' => 'value'))->where('cs.id = 1')->setIntegrityCheck(false));
		if (!$resultSet or 0 == count($resultSet)) return false;
		
		$row = $resultSet->current(); 
		return (strlen($row['value']) == 0)?$row['default_value']:$row['value'];
	}
	
	
	
	
}
