<?php

class Common_Model_Sessionux extends Zend_Db_Table_Abstract
{
    protected $_name = 'sessions_ux';
	protected $_primary = 'id';
	 
	public function createNewSession($id, $topic, $type, $duration, $patient, $dates)
	{
		$data = array('id' => $id,'topic' => $topic,'type' => $type,'duration' => $duration,'patient' => $patient, 'datesession' => $dates);
		$this->_db->insert('sessions_ux', $data);
		return $this->_db->lastInsertId();
	}
	 
	
	public function getAllSessions()
	{
		$resultSet = $this->fetchAll($this->select()
			->from($this, array('id', 'topic','type', 'duration', 'patient', 'datesession')));
		if (0 == count($resultSet)) return false;
		foreach ($resultSet as $k => $v)
		{
			$rs[] = array(	'topic' => $v['topic'], 
							'id' => $v['id'], 'datesession' => $v['datesession']);
		}	
		return $rs; 
	}	
	
	
	


    public function findMember($username, $password = NULL)
    {
		// preparing and executing the research
		$resultSet = $this->fetchAll($this->select()->where('username = ?', $username));
		if (0 == count($resultSet)) return false;
		//
		
		///die('123');
		
		$row = $resultSet->current(); 
		foreach ($row as $obj => $objval) $this->setFieldData($obj, $objval);

		//if parameter password is null and user is found return the information back to the user
		if (is_null($password)) return true;			
		
		// if parameter password is not null, veriyfiing now the password
		if (sha1($password) != $this->getPassword()) return false;
		
		return true;
	}
	
	
	public function getRequiredUserDetail($userId)
	{
		$resultSet = $this->fetchAll($this->select()
			->from($this, array('email1', 'firstName','departmentId'))
			->where('id = ?', $userId));
		if (0 == count($resultSet)) return false;
		foreach ($resultSet as $k => $v)
		{
			$rs[] = array(	'email' => $v['email1'], 
							'name' => $v['firstName'],
							'departmentId' => $v['departmentId']);
		}	
		return $rs; 
	}

	public function getDeptId()
	{
		$username = $_SESSION['signingin']['svd_username'];
		$resultSet = $this->fetchRow($this->select()->from($this, array('departmentId'))->where('username = ?', $username));
		
		if (0 == count($resultSet)) return false;
		
		$dept = $resultSet['departmentId'];
		return $dept; 
	}

	public function getUseridByUsername()
	{
		$username = $_SESSION['signingin']['svd_username'];
		$password = $_SESSION['signingin']['svd_password'];
		$resultSet = $this->fetchRow($this->select()
							->from($this, array('id'))
							->where('username = ?', $username)
							->where('password = ?', sha1($password)));
		if (0 == count($resultSet)) return false;
		
		$id = $resultSet['id'];
		return $id;
	}
}
