<?php

class Common_Model_Session extends Zend_Db_Table_Abstract
{
    protected $_name = 'sessions';
	protected $_primary = 'id';

	public function _loadDefaultSession() {
		$loadSession = new Zend_Session_Namespace('member_is_logged_in');	
		if (isset($loadSession->svd_username))
		{		
			$account_obj = new Common_Model_Accounts();
			//echo $loadSession->svd_password;
			$info_account = $account_obj->find_account($loadSession->svd_username,$loadSession->svd_password);
			//echo '<pre>'; print_r($info_account);
			if (!$info_account)
			{
				unset($loadSession->svd_username);
				unset($loadSession->svd_password);
				return false;
			}
			else
			{	if ($info_account[2] == 'c')
				{
					$ippp = new Common_Model_Ippps();
					$ipp_info = $ippp->loadIpp_combined(sha1($info_account[1]));
					return array(array($ipp_info['id'],$ipp_info['ippid'],
					$ipp_info['billingid'],$info_account[0], $info_account),$ipp_info,$loadSession->svd_username);
				}
				elseif ($info_account[2] == 'p')
				{
					$ippp = new Common_Model_Eppps();
					//echo sha1($info_account[1]);
					$ipp_info = $ippp->loadEpp_combined(sha1($info_account[1]));
				//	echo '<pre>';print_r($ipp_info);
				//	//echo '<pre>'; print_r($ipp_info);
					return array(array($ipp_info['id'],$ipp_info['eppid'],$info_account[0], $info_account),$ipp_info,$loadSession->svd_username);
				}
				elseif ($info_account[2] == 'a')
				{
					$ippp = new Common_Model_Appps();
					$ipp_info = $ippp->loadApp_combined(sha1($info_account[1]));
					return array(array($ipp_info['id'],$ipp_info['appid'],$info_account[0], $info_account),$ipp_info,$loadSession->svd_username);
				}
			}
		}
		else {
			return false;	
		}
	}
	

	public function addSessionEntry($ipaddress, $logintime, $accountid, $active)
	{
		$data = array('ipaddress' => $ipaddress,'logintime' => $logintime,'accountid' => $accountid, 'active' => $active);
		return $this->insert($data);
	}

	//public function check
	
	
	
	





















	
	public function setFieldData($param, $value) {
		$this->$param = $value;
		return $this;
	}


    public function findMember($username, $password = NULL)
    {
		// preparing and executing the research
		$resultSet = $this->fetchAll($this->select()->where('username = ?', $username));
		if (0 == count($resultSet)) return false;
		//
		
		///die('123');
		
		$row = $resultSet->current(); 
		foreach ($row as $obj => $objval) $this->setFieldData($obj, $objval);

		//if parameter password is null and user is found return the information back to the user
		if (is_null($password)) return true;			
		
		// if parameter password is not null, veriyfiing now the password
		if (sha1($password) != $this->getPassword()) return false;
		
		return true;
	}
	
	
	public function getRequiredUserDetail($userId)
	{
		$resultSet = $this->fetchAll($this->select()
			->from($this, array('email1', 'firstName','departmentId'))
			->where('id = ?', $userId));
		if (0 == count($resultSet)) return false;
		foreach ($resultSet as $k => $v)
		{
			$rs[] = array(	'email' => $v['email1'], 
							'name' => $v['firstName'],
							'departmentId' => $v['departmentId']);
		}	
		return $rs; 
	}

	public function getDeptId()
	{
		$username = $_SESSION['signingin']['svd_username'];
		$resultSet = $this->fetchRow($this->select()->from($this, array('departmentId'))->where('username = ?', $username));
		
		if (0 == count($resultSet)) return false;
		
		$dept = $resultSet['departmentId'];
		return $dept; 
	}

	public function getUseridByUsername()
	{
		$username = $_SESSION['signingin']['svd_username'];
		$password = $_SESSION['signingin']['svd_password'];
		$resultSet = $this->fetchRow($this->select()
							->from($this, array('id'))
							->where('username = ?', $username)
							->where('password = ?', sha1($password)));
		if (0 == count($resultSet)) return false;
		
		$id = $resultSet['id'];
		return $id;
	}
}
