<?php

class Common_Model_Providers extends Zend_Db_Table_Abstract
{
    protected $_name = 'providers';
	protected $_primary = 'id';
	 

	public function checkNPIProvider($npi, $brut = false)
	{
		//return true;
		try
		{
			$response = file_get_contents('https://npiregistry.cms.hhs.gov/api/?number='.$npi.'&enumeration_type=&taxonomy_description=&first_name=&last_name=&organization_name=&address_purpose=&city=&state=&postal_code=&country_code=&limit=&skip=');

			if ($brut)
			{
				return $response;
			}	
			else
			{
				$response = json_decode($response);
				if (!isset($response->result_count) or ($response->result_count != 1))
				{
					return false;
				}
				else 
				{
					return true;
				}
			}
		}
		catch(Exception $e) 
		{
			return false;
		}
		
	}
	
	
	public function createProvider($eppid,$ckeyprovider,$npiNumber, $providercode)
	{
		$data = array('eppid' => $eppid,'ckeyprovider' => sha1($ckeyprovider), 'npiNumber' => $npiNumber, 'providercode' => $providercode);
		$this->insert($data);
		return $this->_db->lastInsertId();
	}
	

	public function updateProviderCode($id, $providercode)
	{
		$data = array('providercode' => $providercode);
		return $this->_db->update('providers', $data, array('id = \''.$id.'\''));
	}
	
	
	public function findKeyActivation($activationkey)
	{
		$result = $this->fetchRow($this->select()->from(array('c' => 'customers'),array('id' => 'id','activationkey' => 'activationkey','accountactivated' => 'accountactivated', 'activationdate' => 'activationdate', 'ippid' => 'ippid'))->where('activationkey = ?', $activationkey));
		
		if (0 == count($result) or $result['accountactivated'] == 1) return false;
		return $result;
	}
	
	public function activateProvider($id)
	{
		$data = array('accountactivated' => 1,
              'activationdate' => new Zend_Db_Expr('NOW()'));
		return $this->_db->update('customers', $data, array('id = '.$id));
	}
	
	public function getProviderDetail($providerCode)
	{
		$resultSet = $this->fetchRow($this->select()->from(array('a' => 'accounts'), array('mainId' => 'id','username','password','activationkey','accountactivated','activationdate','dateofbirth','emailaddress','object'))
			->joinLeft(array('p' => 'providers'), 'sha1(a.activationkey) = p.ckeyprovider')
			->joinLeft(array('ep' => 'epps'), 'p.eppid = ep.eppid')
			->joinLeft(array('c' => 'countries'), 'c.id = ep.country', array('Country' => 'name'))
			->where('a.object = ?', 'p')
			->where('p.providercode = ?', $providerCode)
			->setIntegrityCheck(false));

		if (!$resultSet or 0 == count($resultSet)) return false;
			//echo '<pre>';print_r($resultSet);
		return $resultSet;


	} 
	
	public function checkPassword($id, $password)
	{
		$resultSet = $this->fetchAll($this->select()->where('id = ?', $id));
		if (0 == count($resultSet)) return false;
		$row = $resultSet->current(); 
		if ($this->crypPassword($password) != $row['password']) return false;
		return $row['password'];
	}
	
	public function crypPassword($password)
	{
		return sha1($password);	
	}
	
	public function updatePassword($id, $password)
	{
		$data = array('password' => $this->crypPassword($password));
		return $this->_db->update('customers', $data, array('id = '.$id));
	}
	
	
	
}
