<?php

class Common_Model_Paymentruns extends Zend_Db_Table_Abstract
{
    protected $_name = 'payment_runs';
	protected $_primary = 'prnumber';
	
	
	public function createPaymentRun($referenceId, $patientamount, $paymentamount, $status, $paymentdate, $paymentstatus )
	{
		$data = array('prdate' => new Zend_Db_Expr('NOW()'),'refenceId'=> $referenceId,'pramount' => $paymentamount,'status' => $status, 'paymentdate' => $paymentdate, 'patientamount' => $patientamount);
		$this->insert($data);
		return $this->_db->lastInsertId();
	}
	
	public function checkIfPRFoundForCase($referenceId)
	{
		$result = $this->fetchRow($this->select()
			->from(array('p' => 'payment_runs'), array())
			->where('p.refenceId = ?', $referenceId)
			->setIntegrityCheck(false));
		
		if (0 == count($result))
		{
			return false;
		}
		return $result;	
	}
	
	public function getPRDetails($pref)
	{
		$result = $this->fetchRow($this->select()
			->from(array('c' => 'payment_runs'))
			->join(array('sp' => 'cases'), 'sp.refenceId = c.refenceId')
			
			->join(array('cst' => 'customers'), 'cst.id = sp.patientId')
			->join(array('i' => 'ipps'),'cst.ippid = i.ippid', array('Last name' => 'lastname','Ippp Id'  => 'ippid', 'Middle name'  => 'middlename', 'First name'  => 'firstname', 'Birth date'  => 'birthdate', 'Sex'  => 'sex', 'Marital status'  => 'maritalstatus', 'House or Apt no'  => 'house_aptno', 'Street name'  => 'streetname', 'City'  => 'city', 'State'  => 'state', 'Zip'  => 'zip', 'Email'  => 'email', 'Address'  => 'address', 'Country Code'  => 'country', 'Cellphone'  => 'cellphone', 'Homephone'  => 'homephone', 'Workphone'  => 'workphone', 'Occupation' => 'occupation', 'Medicinsur_planname' => 'medicinsur_planname', 'employerid' => 'Employerid', 'Address' => 'address', 'Picture' => 'picture'))
				
			->join(array('pvd' => 'providers'), 'pvd.providercode = sp.providerId')
			->join(array('e' => 'epps'),'pvd.eppid = e.eppid', array('Last name' => 'lastname','Eppp Id'  => 'eppid', 'Middle name'  => 'middlename', 'First name'  => 'firstname', 'Birth date'  => 'birthdate', 'Sex'  => 'sex', 'Marital status'  => 'maritalstatus', 'House or Apt no'  => 'house_aptno', 'Street name'  => 'streetname', 'City'  => 'city', 'State'  => 'state', 'Zip'  => 'zip', 'Email'  => 'email', 'Address'  => 'address', 'Country Code'  => 'country'))
				
			->where('prnumber = ?', $pref)
			->setIntegrityCheck(false));
		
		if (0 == count($result))
		{
			return false;
		}
		return $result;
	}
	
	
	public function getPaymentsInPeriod($startDate = null, $endDate = false)
	{
			$resultSet = $this->fetchAll($this->select()
				->from(array('c' => 'payment_runs'))
				->join(array('sp' => 'cases'), 'sp.refenceId = c.refenceId')
				
				->join(array('cst' => 'customers'), 'cst.id = sp.patientId')
				->join(array('i' => 'ipps'),'cst.ippid = i.ippid', array('Last name' => 'lastname','Ippp Id'  => 'ippid', 'Middle name'  => 'middlename', 'First name'  => 'firstname', 'Birth date'  => 'birthdate', 'Sex'  => 'sex', 'Marital status'  => 'maritalstatus', 'House or Apt no'  => 'house_aptno', 'Street name'  => 'streetname', 'City'  => 'city', 'State'  => 'state', 'Zip'  => 'zip', 'Email'  => 'email', 'Address'  => 'address', 'Country Code'  => 'country', 'Cellphone'  => 'cellphone', 'Homephone'  => 'homephone', 'Workphone'  => 'workphone', 'Occupation' => 'occupation', 'Medicinsur_planname' => 'medicinsur_planname', 'employerid' => 'Employerid', 'Address' => 'address', 'Picture' => 'picture'))
					
				->join(array('pvd' => 'providers'), 'pvd.providercode = sp.providerId')
				->join(array('e' => 'epps'),'pvd.eppid = e.eppid', array('Last name' => 'lastname','Eppp Id'  => 'eppid', 'Middle name'  => 'middlename', 'First name'  => 'firstname', 'Birth date'  => 'birthdate', 'Sex'  => 'sex', 'Marital status'  => 'maritalstatus', 'House or Apt no'  => 'house_aptno', 'Street name'  => 'streetname', 'City'  => 'city', 'State'  => 'state', 'Zip'  => 'zip', 'Email'  => 'email', 'Address'  => 'address', 'Country Code'  => 'country'))
					
				
				->where("sp.closingDate >= ?",  $startDate)
    			->where("sp.closingDate <= ?",  $endDate)
	
				
				->setIntegrityCheck(false));
		
		if (0 == count($resultSet)) return false;
		else return $resultSet;
	}
	

	public function getPaymentsInPeriodPerPeriod($providerId, $startDate = null, $endDate = false)
	{
			$resultSet = $this->fetchAll($this->select()
				->from(array('c' => 'payment_runs'))
				->join(array('sp' => 'cases'), 'sp.refenceId = c.refenceId')
				
				->join(array('cst' => 'customers'), 'cst.id = sp.patientId')
				->join(array('i' => 'ipps'),'cst.ippid = i.ippid', array('Last name' => 'lastname','Ippp Id'  => 'ippid', 'Middle name'  => 'middlename', 'First name'  => 'firstname', 'Birth date'  => 'birthdate', 'Sex'  => 'sex', 'Marital status'  => 'maritalstatus', 'House or Apt no'  => 'house_aptno', 'Street name'  => 'streetname', 'City'  => 'city', 'State'  => 'state', 'Zip'  => 'zip', 'Email'  => 'email', 'Address'  => 'address', 'Country Code'  => 'country', 'Cellphone'  => 'cellphone', 'Homephone'  => 'homephone', 'Workphone'  => 'workphone', 'Occupation' => 'occupation', 'Medicinsur_planname' => 'medicinsur_planname', 'employerid' => 'Employerid', 'Address' => 'address', 'Picture' => 'picture'))
					
				->join(array('pvd' => 'providers'), 'pvd.providercode = sp.providerId')
				->join(array('e' => 'epps'),'pvd.eppid = e.eppid', array('Last name' => 'lastname','Eppp Id'  => 'eppid', 'Middle name'  => 'middlename', 'First name'  => 'firstname', 'Birth date'  => 'birthdate', 'Sex'  => 'sex', 'Marital status'  => 'maritalstatus', 'House or Apt no'  => 'house_aptno', 'Street name'  => 'streetname', 'City'  => 'city', 'State'  => 'state', 'Zip'  => 'zip', 'Email'  => 'email', 'Address'  => 'address', 'Country Code'  => 'country'))
					
				
				->where("sp.closingDate >= ?",  $startDate)
    			->where("sp.closingDate <= ?",  $endDate)
				->where("sp.providerId = ?",  $providerId)
	
				
				->setIntegrityCheck(false));
		
		if (0 == count($resultSet)) return false;
		else return $resultSet;
	}	
	
}
