<?php

class Common_Model_Notifications extends Zend_Db_Table_Abstract
{
    protected $_name = 'notifications';
	protected $_primary = 'id';
	 
	
	
	public function getNotificationsByUser($user_id = null)
	{
		$resultSet = $this->fetchAll($this->select()
			->from(array('c' => 'notifications'), array('id' => 'id', 'Topic' => 'topic', 'Message' => 'message', 'aoi'=> 'issuedBy', 'doi' => 'issuedOn'))
			->where('c.issuedTo = ?', $user_id)
			->setIntegrityCheck(false));
		if (0 == count($resultSet)) return -1;
		else return $resultSet;
	}
	
	public function addNotificationForUser($topic, $message, $issuedBy, $issuedOn, $issuedTo, $category, $actionRequired)
	{
		$data = array('topic' => $topic,'message' => $message,'issuedBy'=> $issuedBy,'issuedOn' => $issuedOn, 'issuedTo' => $issuedTo, 'category' => $category, 'isRead' => 0, 'actionRequired' => $actionRequired);
		return $this->insert($data);
	}

	
	
	
}
