<?php

class Common_Model_Naviguations extends Zend_Db_Table_Abstract
{
    protected $_name = 'naviguations';
	protected $_primary = 'id';
	 
	public function getMainNaviguationOptions($groupid)
	{
		$resultSet = $this->fetchAll($this->select()->from(array('pn' => 'naviguationusers'))->join(array('n' => 'naviguations'), 'n.id = pn.naviguationid', array('id' => 'id','name' => 'name','link' => 'link','parent' => 'parent','orderb' => 'orderb', 'enabled' => 'enabled'))->where('pn.allowed = 1')->where('n.parent = 0')->where('pn.groupusers = ?',$groupid)->order('n.orderb')->setIntegrityCheck(false));
		if (!$resultSet or 0 == count($resultSet)) return false;
		
		//echo '<pre>'; print_r($resultSet);
		
		foreach ($resultSet as $k => $v)
		{
			$parents[$v['id']] = array('id' => $v['id'],'name' => $v['name'], 'enabled' => $v['enabled'], 'link' => $v['link']);
		}
		return $parents;
	}


	public function getNaviguationOptions($groupid)
	{
		$resultSet = $this->fetchAll($this->select()->from(array('pn' => 'naviguationusers'))->join(array('n' => 'naviguations'), 'n.id = pn.naviguationid', array('id' => 'id','name' => 'name','link' => 'link','parent' => 'parent','orderb' => 'orderb', 'enabled' => 'enabled'))->where('pn.allowed = 1')->where('pn.groupusers = ?',$groupid)->order('n.orderb')->setIntegrityCheck(false));
		if (!$resultSet or 0 == count($resultSet)) return false;
		
		//echo '<pre>'; print_r($resultSet);
		
		foreach ($resultSet as $k => $v)
		{
			if ($v['parent'] == '0')
			{
				$parents[$v['id']] = array('id' => $v['id'],'name' => $v['name'], 'enabled' => $v['enabled'], 'link' => $v['link']);
			}
			else
			{
				$menus[$v['parent'].'_sub'][$v['id']] = array('id' => $v['id'], 'name' => $v['name'], 'link' => $v['link'], 'parent' => $v['parent'], 'enabled' => $v['enabled']);	
			}
		}
		return array($parents,$menus);
	}
	
	
	
}
