<?php

class Common_Model_Ippps extends Zend_Db_Table_Abstract
{
    protected $_name = 'ipps';
	protected $_primary = 'ippid';

    public function loadIpp_combined($ckey)
    {
		$resultSet = $this->fetchRow($this->select()
			->from(array('c' => 'customers'))
			->join(array('i' => 'ipps'),'c.ippid = i.ippid',
				array('Last name' => 'lastname','Ippp Id'  => 'ippid', 'Middle name'  => 'middlename', 'First name'  => 'firstname', 'Birth date'  => 'birthdate', 'Sex'  => 'sex', 'Marital status'  => 'maritalstatus', 'House or Apt no'  => 'house_aptno', 'Street name'  => 'streetname', 'City'  => 'city', 'State'  => 'state', 'Zip'  => 'zip', 'Email'  => 'email', 'Address'  => 'address', 'Country Code'  => 'country', 'Cellphone'  => 'cellphone', 'Homephone'  => 'homephone', 'Workphone'  => 'workphone', 'Occupation' => 'occupation', 'Medicinsur_planname' => 'medicinsur_planname', 'employerid' => 'Employerid', 'Address' => 'address', 'Picture' => 'picture'))
			->join(array('co' => 'countries'), 'co.id = i.country', array('Country' => 'name'))
			->where('c.ckeystomer = ?', $ckey)
			->setIntegrityCheck(false));
			
		if (!$resultSet or 0 == count($resultSet)) return false;
		
		return $resultSet;
	}

	public function createIppforMember($firstname,$lastname,$address,$city,$zip,$country,$email,$cellphone,$dob)
	{
		$data = array(
			'lastname' => $firstname,
			'middlename' => '',
			'firstname'      => $lastname,
			'address'      => $address,
			'city'      => $city,
			'zip'      => $zip,
			'country'      => $country,
			'email'      => $email,
			'cellphone'      => $cellphone,
			'birthdate'      => date("Y-m-d", strtotime($dob))
		);
		$this->insert($data);
		return $this->_db->lastInsertId();
	}	
	public function updateIppByCat_occupation($id, $occupation)
	{
		$data = array('occupation' => $occupation);
		return $this->_db->update('ipps', $data, array('ippid = '.$id));	
	}
	
	public function updateIppByCat_medical($id, $medinsur)
	{
		$data = array('medicinsur_planname' => $medinsur);
		return $this->_db->update('ipps', $data, array('ippid = '.$id));	
	}

	public function updateIppByCat_basic($id, $firstname, $middlename, $lastname, $gender, $marital, $birthdate)
	{
		$data = array('firstname' => $firstname,'middlename' => $middlename,'lastname' => $lastname,'sex' => $gender,'maritalstatus' => $marital,'birthdate' => $birthdate);
		return $this->_db->update('ipps', $data, array('ippid = '.$id));	
	}

	public function updateIppByCat_contact($id, $email, $address, $apartnum, $streetnum, $zip, $country, $city, $state, $cell, $home, $work)
	{
		$data = array('address' => $address,'house_aptno' => $apartnum,'streetname' => $streetnum,'city' => $city,'state' => $state,'zip' => $zip,'country' => $country,'email' => $email,'cellphone' => $cell,'homephone' => $home,'workphone' => $work);
		return $this->_db->update('ipps', $data, array('ippid = '.$id));	
	}	
	
	public function updateIppByCat_picture($id, $picture)
	{
		$data = array('picture' => $picture);
		return $this->_db->update('ipps', $data, array('ippid = '.$id));	
	}	

}
