<?php

class Common_Model_Eppps extends Zend_Db_Table_Abstract
{
    protected $_name = 'epps';
	protected $_primary = 'eppid';

    public function loadEpp($ippid, $asarray = false)
    {
		if ($asarray) 
		{
			// preparing and executing the research
			$resultSet = $this->fetchAll($this->select()
										->from(array('e' => 'epps'),
                    						array('Last name' => 'lastname','Eppp Id'  => 'eppid', 'Middle name'  => 'middlename', 'First name'  => 'firstname', 'Birth date'  => 'birthdate', 'Sex'  => 'sex', 'Marital status'  => 'maritalstatus', 'House or Apt no'  => 'house_aptno', 'Street name'  => 'streetname', 'City'  => 'city', 'State'  => 'state', 'Zip'  => 'zip', 'Email'  => 'email', 'Address'  => 'address', 'Country Code'  => 'country', 'Cellphone'  => 'cellphone', 'Homephone'  => 'homephone', 'Workphone'  => 'workphone', 'Practice Name' => 'practicename', 'Designation' => 'designation', 'Picture' => 'picture'))
											
										->join(array('c' => 'countries'), 'c.id = e.country', array('Country' => 'name'))
										->where('eppid = ?', $ippid)
										->setIntegrityCheck(false));
			if (!$resultSet or 0 == count($resultSet)) return false;
			$row = $resultSet->current(); 
			$results = array();
			foreach ($row as $obj => $objval) $results[$obj] = $objval;
			return $results;
		}
		else {
			// preparing and executing the research
			$resultSet = $this->fetchAll($this->select()->where('ippid = ?', $ippid));
			if (!$resultSet or 0 == count($resultSet)) return false;
			
			$row = $resultSet->current(); 
			
			foreach ($row as $obj => $objval) $this->setFieldData($obj, $objval);
			return true;
		}
	}
	
	
    public function loadEpp_combined($ckey)
    {
		$resultSet = $this->fetchRow($this->select()->from(array('p' => 'providers'))->join(array('e' => 'epps'),'p.eppid = e.eppid', array('Last name' => 'lastname','Eppp Id'  => 'eppid', 'Middle name'  => 'middlename', 'First name'  => 'firstname', 'Birth date'  => 'birthdate', 'Sex'  => 'sex', 'Marital status'  => 'maritalstatus', 'House or Apt no'  => 'house_aptno', 'Street name'  => 'streetname', 'City'  => 'city', 'State'  => 'state', 'Zip'  => 'zip', 'Email'  => 'email', 'Address'  => 'address', 'Country Code'  => 'country', 'Cellphone'  => 'phonenumber1', 'Homephone'  => 'phonenumber2', 'Workphone'  => 'phonenumber2', 'Practice Name' => 'practicename', 'Designation' => 'designation', 'Picture' => 'picture'))
		->joinLeft(array('co' => 'countries'), 'co.id = e.country', array('Country' => 'name'))
		->where('p.ckeyprovider = ?', $ckey)
		->setIntegrityCheck(false));
					
		if (!$resultSet or count($resultSet) == 0) return false;
		else return $resultSet;
	}

	
	public function createEppforProvider($lastname,$middlename,$firstname,$birthdate,$sex,$maritalstatus,$house_aptno,$streetname,$country,$city,$state,$zip,$address,$email,$phonenumber1,$homephone,$workphone,$designation,$practicename,$webaddress,$isboardcertified,$boardname,$boardyearsdone,$speciality1,$speciality2,$subspeciality1,$subspeciality2,$phonenumber2,$primStateLicense,$otherStateLicense,$medicalSchool,$fellowship,$awards,$comments)
	{
		$data = array(
			'lastname' => $lastname ,
			'middlename' => $middlename ,
			'firstname' => $firstname ,
			'birthdate' => $birthdate ,
			'sex' => $sex ,
			'maritalstatus' => $maritalstatus ,
			'house_aptno' => $house_aptno ,
			'streetname' => $streetname ,
			'country' => $country ,
			'city' => $city ,
			'state' => $state ,
			'zip' => $zip ,
			'address' => $address ,
			'email' => $email ,
			'phonenumber1' => $phonenumber1 ,
			'homephone' => $homephone ,
			'workphone' => $workphone ,
			'designation' => $designation ,
			'practicename' => $practicename ,
			'webaddress' => $webaddress ,
			'isboardcertified' => $isboardcertified ,
			'boardname' => $boardname ,
			'boardyearsdone' => $boardyearsdone ,
			'speciality1' => $speciality1 ,
			'speciality2' => $speciality2 ,
			'subspeciality1' => $subspeciality1 ,
			'subspeciality2' => $subspeciality2 ,
			'phonenumber2' => $phonenumber2 ,
			'primStateLicense' => $primStateLicense ,
			'otherStateLicense' => $otherStateLicense ,
			'medicalSchool' => $medicalSchool ,
			'fellowship' => $fellowship ,
			'awards' => $awards ,
			'comments' => $comments
		);
		$this->insert($data);
		return $this->_db->lastInsertId();
	}	


	public function updateEppForProvider($id, $fullname, $gender, $marital, $dob, $email, $address, $apartNumber, $streetName, $zipCode, $country, $city, $state, $cellphone, $homephone, $workphone)
	{
		$data = array('firstname' => $fullname,'sex' => $gender,'maritalstatus' => $marital,'birthdate' => date('Y-m-d', strtotime(str_replace('-', '/', $dob))),'email' => $email,'address' => $address,'house_aptno' => $apartNumber,'streetname' => $streetName,'zip' => $zipCode,'country' => $country,'city' => $city,'state' => $state,'phonenumber1' => $cellphone,'homephone' => $homephone,'workphone' => $workphone);

		return $this->_db->update('epps', $data, array('eppid = '.$id));	
	}


	public function updateProviderMainData($id, $npiNumber, $socialSecurity)
	{
		$data = array('npiNumber' => $npiNumber, 'socialSecurity' => $socialSecurity);
		return $this->_db->update('providers', $data, array('id = '.$id));	
	}


	public function updateProviderCAQHData($id, $caqhUsername, $caqhIdNumber, $caqhPassword)
	{
		$data = array('caqhUsername' => $caqhUsername, 'caqhIdNumber' => $caqhIdNumber, 'caqhPassword' => $caqhPassword, 'applicationReceived' => 1, 'ApplicationDateReceived' => new Zend_Db_Expr('NOW()'));
		return $this->_db->update('providers', $data, array('id = '.$id));	
	}

	public function updateProviderDocument($id, $type, $fileName)
	{
		if ($type == 'cv')
		{
			$data = array('attachCv' => $fileName, 'attachCvDate' => new Zend_Db_Expr('NOW()'));
		}
		elseif ($type == 'picture')
		{
			$data = array('attachPicture' => $fileName, 'attachPictureDate' => new Zend_Db_Expr('NOW()'));
		}
		elseif ($type == 'application')
		{
			$data = array('attachApplication' => $fileName, 'applicationDateReceived' => new Zend_Db_Expr('NOW()'));
		}
		elseif ($type == 'license')
		{
			$data = array('attachLicense' => $fileName, 'attachLicenseDate' => new Zend_Db_Expr('NOW()'));
		}
		elseif ($type == 'certification')
		{
			$data = array('attachCertification' => $fileName, 'attachCertificationDate' => new Zend_Db_Expr('NOW()'));
		}
		elseif ($type == 'malpractice')
		{
			$data = array('attachMalpractice' => $fileName, 'attachMalpracticeDate' => new Zend_Db_Expr('NOW()'));
		}
		elseif ($type == 'dea')
		{
			$data = array('attachDea' => $fileName, 'attachDeaDate' => new Zend_Db_Expr('NOW()'));
		}
		else
		{
			return;
		}
		
		return $this->_db->update('providers', $data, array('id = '.$id));	
	}














	
	public function updateIppByCat_occupation($id, $occupation)
	{
		$data = array('occupation' => $occupation);
		return $this->_db->update('ipps', $data, array('ippid = '.$id));	
	}
	
	public function updateIppByCat_medical($id, $medinsur)
	{
		$data = array('medicinsur_planname' => $medinsur);
		return $this->_db->update('ipps', $data, array('ippid = '.$id));	
	}

	public function updateIppByCat_basic($id, $firstname, $middlename, $lastname, $gender, $marital, $birthdate)
	{
		$data = array('firstname' => $firstname,'middlename' => $middlename,'lastname' => $lastname,'sex' => $gender,'maritalstatus' => $marital,'birthdate' => $birthdate);
		return $this->_db->update('ipps', $data, array('ippid = '.$id));	
	}

	public function updateIppByCat_contact($id, $email, $address, $apartnum, $streetnum, $zip, $country, $city, $state, $cell, $home, $work)
	{
		$data = array('address' => $address,'house_aptno' => $apartnum,'streetname' => $streetnum,'city' => $city,'state' => $state,'zip' => $zip,'country' => $country,'email' => $email,'cellphone' => $cell,'homephone' => $home,'workphone' => $work);
		return $this->_db->update('ipps', $data, array('ippid = '.$id));	
	}	
	
	public function updateIppByCat_picture($id, $picture)
	{
		$data = array('picture' => $picture);
		return $this->_db->update('ipps', $data, array('ippid = '.$id));	
	}		
	
	
	
	
	
	
	
	
	
}
