<?php

class Common_Model_Cnsiq extends Zend_Db_Table_Abstract
{
    protected $_name = 'cnsiqcodes';
	protected $_primary = 'id';
	
	public function hasCnsiqFilledByCustomer($cid)
	{
		
		// preparing and executing the research
		$resultSet = $this->fetchAll($this->select()
									->from(array('c' => 'customers'))
									->where('c.id = ?', $cid)
									->setIntegrityCheck(false));
									
		if (!$resultSet or 0 == count($resultSet)) 
		{
			//Halt execution because customer not found. 
			die("Halt executions");
		}
		
		$row = $resultSet->current(); 
		if ($row['cnsiq_completed'] == 0) return false;
		else return $row['cnsiq_datecompletion'];
		// to do - check if cnsiq_datecompletion is more than one year
	}
	
	public function getCnsiqByCustomer($cid)
	{
		$resultSet = $this->fetchAll($this->select()->from(array('cc' => 'cnsiqcodes'),array('idqx' => 'id', 'question'=>'question'))->join(array('ccg' => 'cnsiqcodes_categories'), 'ccg.id = cc.categoryid', array('name' => 'name'))->join(array('cct' => 'cnsiq_customers'), 'cct.cnsiq_questionid = cc.id AND cct.customerid = '.$cid, array('value' => 'answer'))->setIntegrityCheck(false));
		
		
		
		
		if (!$resultSet or 0 == count($resultSet)) return false;
		
		foreach ($resultSet as $k => $v)
		{		
			$rs[$v['name']][] = array('idqx' => $v['idqx'], 'question' => $v['question'], 'value' => $v['value'], 'categorie' => $v['name']);
			if (!isset($rs_simplfield[$v['name']]['questions']))
			{
				$rs_simplfield[$v['name']]['questions'] = '\'Q'.$v['idqx'].'\'';
				$rs_simplfield[$v['name']]['labels'] = '\''.$v['question'].'\'';
				$rs_simplfield[$v['name']]['data'] = $v['value'];
			}
			else
			{
				$rs_simplfield[$v['name']]['questions'] .= ',\'Q'.$v['idqx'].'\'';
				$rs_simplfield[$v['name']]['labels'] .= ',\''.$v['question'].'\'';
				$rs_simplfield[$v['name']]['data'] .= ','.$v['value'];
			}
		}
		//echo '<pre>';print_r($rs_simplfield);
		return array($rs, $rs_simplfield);
	}
	
	public function getCnsiqCodes($categorie = NULL)
	{
		// preparing and executing the research
		if (is_null($categorie))
		{
			$resultSet = $this->fetchAll($this->select()->from(array('cs' => 'cnsiqcodes_categories'),array('name' => 'name'))->joinRight(array('s' => 'cnsiqcodes'), 's.	categoryid = cs.id', array('idqx' => 'id', 'question' => 'question'))->setIntegrityCheck(false));
		}
		else
		{
			$resultSet = $this->fetchAll($this->select()->from(array('cs' => 'cnsiqcodes_categories'),array('name' => 'name'))->joinRight(array('s' => 'cnsiqcodes'), 's.	categoryid = cs.id', array('idqx' => 'id', 'question' => 'question'))->where('cs.id = ?',$categorie)->setIntegrityCheck(false));	
		}
		if (!$resultSet or 0 == count($resultSet)) return false;
		
		foreach ($resultSet as $k => $v)
		{		
			$rs[$v['name']][] = array('idqx' => $v['idqx'], 'question' => $v['question']);
		}
		return $rs;
	}
	
	public function saveCnsiqAnswersForCustomer($qid, $cid, $value)
	{
		echo "$qid, $cid, $value";
		die();
		$data = array('cnsiq_questionid' => $qid,'customerid' => $cid,'answer' => $value);
		$this->_db->insert('cnsiq_customers', $data);
		return $this->_db->lastInsertId();
	}
	
	public function updateCnsiqAnswersForCustomer($qid, $cid, $value)
	{
		$data = array('answer' => $value);
		$where = array('cnsiq_questionid = ?' => $qid,'customerid = ?' => $cid);
		return $this->_db->update('cnsiq_customers', $data, $where);
	}
	
	public function customerFillCnsiq($id)
	{
		$data = array('cnsiq_completed' => 1,
              'cnsiq_datecompletion' => new Zend_Db_Expr('NOW()'));
		return $this->_db->update('customers', $data, array('id = '.$id));
	}
	
	
	
	
	
	
}
