		<?php

class Common_Model_Cities extends Zend_Db_Table_Abstract
{
    protected $_name = 'cities';
	protected $_primary = 'id';
	 
	public function getAllCities($as_array = true)
	{
		$resultSet = $this->fetchAll($this->select()->from($this, array('id', 'name')));
		if (0 == count($resultSet)) return false;
		if ($as_array)
		{
			foreach ($resultSet as $k => $v)
			{
				$rs['keys'][$v['id']] = $v['name'];
				$rs['full'][] = array('id' => $v['id'], 'name' => $v['name']);
			}
			return $rs; 
		}
	}
	 
	public function getAllCitiesByCountry($as_array = true, $countryCode)
	{
		$resultSet = $this->fetchAll($this->select()->from($this, array('id', 'name'))->where('countryCode = ?',$countryCode)->order('name ASC'));
		//die('ger');
		
		if (0 == count($resultSet)) return false;
		if ($as_array)
		{
			foreach ($resultSet as $k => $v)
			{
				$rs['keys'][$v['id']] = $v['name'];
				$rs['full'][] = array('id' => $v['id'], 'name' => $v['name']);
			}
			return $rs; 
		}
	}
	
	
}
